<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Header Widget .
 *
 */
class Travolo_Language_Switcher extends Widget_Base {

	public function get_name() {
		return 'travololanguageswitcher';
	}

	public function get_title() {
		return __( 'Gtranslate', 'travolo' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'travolo_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'gtranslate',
			[
				'label' 	=> __( 'Gtranslate', 'travolo' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'style_select',
			[
				'label' 		=> __( 'Please Select Your Style From Gtranslate', 'travolo' ),
				'type' 			=> Controls_Manager::HEADING,
			]
		);

        $this->end_controls_section();


    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        
        if( class_exists( 'Gtranslate' ) ){
            echo '<ul class="head-top-links">';
                echo '<li>';
                    echo '<!-- Dropdown -->';
                    echo '<a class="dropdown-toggle" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false"><i class="fal fa-globe"></i>';
                        echo esc_html__( 'English', 'travolo' );
                    echo '</a>';
                    echo '<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink1">';
                        echo '<li>';
                            echo do_shortcode('[gtranslate]');
                        echo '</li>';
                    echo '</ul>';
                echo '</li>';
            echo '</ul>';
        }

	}

}