// Global filters
jQuery(document).on('modula_api_after_init', function (event, data) {

    // Define our variables
    var filters,filterClick,urlFilter,currentFilter,urlFilter,filtersWrapper;

    // Get shortcode filters wrapper
    filtersWrapper = jQuery(data.element).parent().find('.modula-gallery-filters-shortcode');
    // Get shortcode filters
    filters = filtersWrapper.find('.filters > ul.menu__list > li > a');

    if ( filters.length > 0 ) {
        var filterClick = data.options.filterClick;

        // Check url to see if we have a filter
        var urlFilter = modula_pro_get_url_parameters('jtg-filter');

        if ( urlFilter ) {
            var currentFilter = 'jtg-filter-' + urlFilter;

            // Show filtered items
            data.$items.find('a').attr('data-cyclefilter', 'show');
            data.$items.show();

            // If we need to show all, don't hide anything
            if ('all' != urlFilter) {
                data.$items.not("." + currentFilter).hide().addClass('jtg-hidden');
                data.$items.not("." + currentFilter).find('a').attr('data-cyclefilter', 'hide');

                filtersWrapper.find('.menu__item--current' ).removeClass( 'menu__item--current' );
                filtersWrapper.find("a[data-filter='" + urlFilter + "']").parent().addClass( 'menu__item--current' );

                data.reset();

            }

        }


        //options for default active filter
        if ( 'All' != data.options.defaultActiveFilter && 'all' != data.options.defaultActiveFilter &&  '' != data.options.defaultActiveFilter && ! urlFilter ) {
            var defaultFilterItems = filtersWrapper.find('a[data-filter="' + data.options.defaultActiveFilter + '"]' );

            if ( defaultFilterItems.length > 0 ) {

                // Process filters
                filters.parent().removeClass('menu__item--current');
                filters.filter( '[data-filter="' + data.options.defaultActiveFilter + '"]' ).parent().addClass('menu__item--current');
                data.$items.hide().addClass('jtg-hidden');
                data.$items.filter( '.jtg-filter-' + data.options.defaultActiveFilter ).show().removeClass('jtg-hidden');
                data.$items.filter( '.jtg-filter-' + data.options.defaultActiveFilter ).find('a').attr('data-cyclefilter', 'show');

            }

            data.reset();

        }

        filters.on( 'click', function (e) {

            if ('0' == filterClick) {
                e.preventDefault();
            }else{
                return true;
            }

            if ( jQuery(this).parent().hasClass( "menu__item--current" ) ) {
                return;
            }

            var currentFilter = jQuery(this).data('filter');

            filtersWrapper.find( '.filters .menu__item--current' ).removeClass( 'menu__item--current' );
            filtersWrapper.find(".filters a[data-filter='" + jQuery(this).attr('data-filter') + "']").parent().addClass( 'menu__item--current' );

            var filter = 'jtg-filter-' + currentFilter;
            if (filter) {
                data.$items.show().removeClass('jtg-hidden');
                data.$items.find('a').attr('data-cyclefilter', 'show');
                data.$items.not("." + filter).hide().addClass('jtg-hidden');
                data.$items.not("." + filter).find('a').attr('data-cyclefilter', 'hide');
            } else {
                data.$items.find('a').attr('data-cyclefilter', 'show');
                data.$items.show().removeClass('jtg-hidden');
            }

            //reinitialize lightboxes
            modula_pro_enable_lightbox( data );
            data.reset();
        });
    }

    // initialize lightboxes
    modula_pro_enable_lightbox( data );

});