<?php

class Modula_Advanced_Shortcodes_Setings {

	/**
	 * Holds the admin class object.
	 *
	 * @since 1.0.0
	 *
	 * @var object
	 */
	public static $instance;

	function __construct() {

		add_filter('modula_admin_page_tabs', array($this,'mas_menu_page'));

		/* Show pro vs lite tab content */
		add_action( 'modula_admin_tab_shortcodes', array( $this, 'show_advanced_shortcodes_tab' ) );
		$this->register_mas_option();
		$this->mas_save_options();

	}

	/**
	 * Returns the singleton instance of the class.
	 *
	 * @since 1.0.0
	 *
	 * @return object The Modula_Advanced_Shortcodes_Setings object.
	 */
	public static function get_instance() {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Modula_Advanced_Shortcodes_Setings ) ) {
			self::$instance = new Modula_Advanced_Shortcodes_Setings();
		}

		return self::$instance;

	}

	/**
	 * Add menu page
	 */

	public function mas_menu_page($tabs){

		$tabs['shortcodes'] = array(
			'label'    => esc_html__( 'Advanced Shortcodes', 'modula-advanced-shortcodes' ),
			'priority' => 40
		);
		
		return $tabs;
    }

    public function show_advanced_shortcodes_tab(){

	    include MODULA_ADVANCED_SHORTCODES_PATH . 'includes/admin/modula_advanced_shortcodes_page.php';
    }

	/**
	 * Register Modula Advanced Shortcodes settings
	 */
    public function register_mas_option(){
	    // creates our settings in the options table
	    register_setting('modula_advanced_shortcode', 'mas_gallery_link',array('type'=>'string','default' => 'gallery_id') );
    }

	/**
	 * Save Modula Advanced Shortcodes options
	 */
    public function mas_save_options(){
		if(isset($_POST['mas_gallery_link'])){
			$gallery_link = sanitize_text_field($_POST['mas_gallery_link']);
			$no_spaces = array(' ','.',',');
			update_option( 'mas_gallery_link', str_replace($no_spaces,'-',$gallery_link));
			wp_redirect( admin_url( 'edit.php?post_type=modula-gallery&page=modula&modula-tab=shortcodes' ) );
			exit();
		}
    }

}

// Load the main plugin class.
$modula_advanced_settings = Modula_Advanced_Shortcodes_Setings::get_instance();