wp.Modula = 'undefined' === typeof( wp.Modula ) ? {} : wp.Modula;

jQuery.fn.setting_state = function( el, state) {

	if( state == 'off'){
		this.css('opacity', '0.5');
		this.find('input, textarea, select, button').attr('disabled', 'disabled');
	}
	if( state == 'on'){
		this.css('opacity', '1');
		this.find('input, textarea, select, button').removeAttr('disabled');
	}
}; 

var modulaGalleryConditions = Backbone.Model.extend({

	initialize: function( args ){

		var rows = jQuery('.modula-settings-container tr[data-container]');
		var tabs = jQuery('.modula-tabs .modula-tab');
		var imageSizesInfo = jQuery('.modula-settings-container tr[data-container="image_size"] .modula-imagesizes-infos .modula-imagesize-info');
		this.set( 'rows', rows );
		this.set( 'tabs', tabs );
		this.set( 'imagesizes', imageSizesInfo );

		this.initEvents();
		this.initValues();

	},

	initEvents: function(){

		this.listenTo( wp.Modula.Settings, 'change:type', this.changedType );
		this.listenTo( wp.Modula.Settings, 'change:effect', this.changedEffect );
		this.listenTo( wp.Modula.Settings, 'change:image_size', this.changeImageSize );
		this.listenTo( wp.Modula.Settings, 'change:enable_lightbox', this.changeLightbox );
        this.listenTo(wp.Modula.Settings, 'change:cursor', this.changeCustomCursor );
        this.listenTo(wp.Modula.Settings, 'change:uploadCursor', this.changeUploadCursor );
		// Check title
		this.listenTo( wp.Modula.Settings, 'change:hide_title', this.hideTitle );
		// Check description
		this.listenTo( wp.Modula.Settings, 'change:hide_description', this.hideDescription );
		// check image count
		this.listenTo( wp.Modula.Settings, 'change:display_image_count', this.showImageCount );
		// check custom responsivness
		this.listenTo( wp.Modula.Settings, 'change:enable_responsive', this.checkCustomResponsivness );
		// check for animation
		this.listenTo( wp.Modula.Settings, 'change:animation_effect', this.changeAnimation );
		// check for transition
		this.listenTo( wp.Modula.Settings, 'change:transition_effect', this.changeTransition );
		// check for share button
		this.listenTo( wp.Modula.Settings, 'change:enable_share', this.changeShare );
		//check for lightbox email share
		this.listenTo( wp.Modula.Settings, 'change:lightbox_email', this.changeEmail );
		// check for autoplay button
		this.listenTo( wp.Modula.Settings, 'change:enable_slideshow', this.changeAutoplay );
		// check for thumbnails
		this.listenTo( wp.Modula.Settings, 'change:enable_thumbs', this.changeThumbnails );

		this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_lightbox', this.toggleShare);

		this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_lightbox', this.toggleEmail);

		this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_lightbox', this.toggleAnimation);

		this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_lightbox', this.toggleTransition);

		this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_share', this.toggleEmail);


	},

	initValues: function(){
        this.changeCustomCursor( false, wp.Modula.Settings.get( 'cursor' ) );
        this.changeUploadCursor( false, wp.Modula.Settings.get( 'uploadCursor') );
		this.changedType( false, wp.Modula.Settings.get( 'type' ) );
		this.changedEffect( false, wp.Modula.Settings.get( 'effect' ) );
		this.changeImageSize( false, wp.Modula.Settings.get( 'image_size' ) );
		this.changeLightbox( false, wp.Modula.Settings.get( 'enable_lightbox' ) );
		this.showImageCount( false, wp.Modula.Settings.get( 'display_image_count' ) );
		this.checkCustomResponsivness( false, wp.Modula.Settings.get( 'enable_responsive' ) );
		this.changeAnimation( false, wp.Modula.Settings.get( 'animation_effect' ) );
		this.changeTransition( false, wp.Modula.Settings.get( 'transition_effect' ) );
		this.changeShare( false, wp.Modula.Settings.get( 'enable_share' ) );
		this.changeEmail( false, wp.Modula.Settings.get( 'lightbox_email') );
		this.changeAutoplay( false, wp.Modula.Settings.get( 'enable_slideshow' ) );
		this.changeThumbnails( false, wp.Modula.Settings.get( 'enable_thumbs' ) );
	},

	changeCustomCursor: function( settings, value) {
        var cursorBox = jQuery( '.modula-effects-preview > div' );
        var rows = this.get( 'rows' );
        if ( 'custom' != value ) {
            rows.filter( '[data-container="uploadCursor"]' ).setting_state( this, 'off' );
            cursorBox.css('cursor', wp.Modula.Settings.get( 'cursor' ) );
        }else {
            rows.filter( '[data-container="uploadCursor"]' ).setting_state( this, 'on' );
            var imageSource;
            if(jQuery("#modula_cursor_preview")[0]) {
                imageSource = jQuery("#modula_cursor_preview")[0].src;

            cursorBox.css('cursor', 'url(' + imageSource + '), auto' );
            }
        }

    },

    changeUploadCursor: function( settings, value ) {
        cursorBox = jQuery( '.modula-effects-preview > div' );
        customCursorValue =  wp.Modula.Settings.get( 'cursor' );
        if ( 0 != value  && 'custom' == customCursorValue ) {
            var imageSource = jQuery("#modula_cursor_preview")[0].src;
            cursorBox.css('cursor', 'url(' + imageSource + '), auto' );
        }else {
            cursorBox.css( 'cursor', wp.Modula.Settings.get( 'cursor' ) );
        }
    },

	changedType: function( settings, value ){
		var rows = this.get( 'rows' ),
			tabs = this.get( 'tabs' );

		if ( 'custom-grid' == value ) {
			rows.filter( '[data-container="columns"], [data-container="gutter"]' ).setting_state( this, 'on' );
			rows.filter( '[data-container="width"], [data-container="height"], [data-container="margin"], [data-container="randomFactor"], [data-container="shuffle"],[data-container="shuffle_galleries"]' ).setting_state( this, 'off' );
			jQuery('.modula-helper-guidelines-container').setting_state( this, 'on' );
		}else {
			rows.filter( '[data-container="columns"]' ).setting_state( this, 'off' );
			rows.filter( '[data-container="width"], [data-container="height"], [data-container="margin"], [data-container="randomFactor"], [data-container="shuffle"],[data-container="shuffle_galleries"]' ).setting_state( this, 'on' );
			jQuery('.modula-helper-guidelines-container').setting_state( this, 'off' );
		}

	},

	changeImageSize: function( settings, value ){
		var rows = this.get( 'rows' ),
			tabs = this.get( 'tabs' ),
			imagesizes = this.get( 'imagesizes' );

		if ( 'custom' == value ) {
			
			rows.filter( '[data-container="image_dimensions"], [data-container="crop_images"]' ).setting_state( this, 'on' );

		}else{

			rows.filter( '[data-container="image_dimensions"], [data-container="crop_images"]' ).setting_state( this, 'off' );

		}

		var currentInfo = imagesizes.filter( '[data-size="' + value + '"]' );
		imagesizes.setting_state( this, 'off' );
		if ( currentInfo.length > 0 ) {
			currentInfo.setting_state( this, 'on' );
		}

	},

	changeLightbox: function( settings, value ){
		var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_lightbox"]'),
            children  = currentRow.data( 'children' );

        jQuery.each(children, function(index, item) {

            var child = jQuery('[data-container="'+item+'"]');

            if ( 0 == value && currentRow.hasClass( 'modula_accordion_open' )) {
            	child.setting_state( this, 'off');
				child.show();
            }else if( 0 == value ){
				child.hide();
            }else{
				child.css('opacity', '1');
                child.find('input, textarea, select, button').removeAttr('disabled');
            	child.show();
			}
        });

		if ( '1' == value ) {
			currentRow.addClass( 'modula_accordion_open' );
		}

		this.changeAnimation( false, wp.Modula.Settings.get( 'animation_effect' ) );
		this.changeTransition( false, wp.Modula.Settings.get( 'transition_effect' ) );
		this.changeShare( false, wp.Modula.Settings.get( 'enable_share' ) );
		this.changeAutoplay( false, wp.Modula.Settings.get( 'enable_slideshow' ) );
		this.changeThumbnails( false, wp.Modula.Settings.get( 'enable_thumbs' ) );
	},

	hideTitle: function( settings, value ) {
		
		var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="hide_title"]'),
            children  = currentRow.data( 'children' );

			currentRow.addClass( 'modula_accordion_reversed' );

        jQuery.each(children, function(index, item) {

            var child = jQuery('[data-container="'+item+'"]');

            if ( 1 == value && currentRow.hasClass( 'modula_accordion_open' )) {
            	child.setting_state( this, 'off');
				child.show();
            }else if( 1 == value ){
				child.hide();
            }else{
				child.css('opacity', '1');
                child.find('input, textarea, select, button').removeAttr('disabled');
            	child.show();
			}

        });


		if( 1 != value ) {

			currentRow.addClass( 'modula_accordion_open' );
		}
	},

	hideDescription: function( settings, value ) {
		var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="hide_description"]'),
            children  = currentRow.data( 'children' );

			currentRow.addClass( 'modula_accordion_reversed' );

        jQuery.each(children, function(index, item) {

            var child = jQuery('[data-container="'+item+'"]');

            if ( 1 == value && currentRow.hasClass( 'modula_accordion_open' )) {
            	child.setting_state( this, 'off');
				child.show();
            }else if( 1 == value ){
				child.hide();
            }else{
				child.css('opacity', '1');
                child.find('input, textarea, select, button').removeAttr('disabled');
            	child.show();
			}

        });

		if( 1 != value ) {
			
			currentRow.addClass( 'modula_accordion_open' );
		}
	},
	showImageCount: function( settings, value ){
		var rows = this.get( 'rows' );

		if ( '1' == value ) {
			rows.filter( '[data-container="imageCountColor"], [data-container="imageCountFontSize"]' ).setting_state( this, 'on' );
		}else{
			rows.filter( '[data-container="imageCountColor"], [data-container="imageCountFontSize"]' ).setting_state( this, 'off' );
		}

	},

	changedEffect: function( settings, value ){
		var rows = this.get( 'rows' ),
			withTitle = [ 'under', 'fluid-up', 'hide', 'quiet', 'reflex', 'curtain', 'lens', 'appear', 'crafty', 'seemo', 'comodo', 'pufrobo','lily','sadie','honey','layla','zoe','oscar','marley','ruby','roxy','bubba','dexter','sarah','chico','milo','julia','hera','winston','selena','terry','phoebe','apollo','steve','jazz','ming','lexi','duke','tilt_1' ,'tilt_3' ,'tilt_7' ],
			withCaption = [ 'under', 'fluid-up', 'hide', 'reflex', 'lens', 'crafty', 'pufrobo','lily','sadie','layla','zoe','oscar','marley','ruby','roxy','bubba','dexter','sarah','chico','milo','julia','selena','apollo','steve','jazz','ming','lexi','duke','tilt_1' ,'tilt_3' ,'tilt_7' ];

		this.hideTitle( false, wp.Modula.Settings.get( 'hide_title' ) );
		this.hideDescription( false, wp.Modula.Settings.get( 'hide_description' ) );
		

		if ( 'under' != value ) {
			rows.filter( '[data-container="backgroundColor"]' ).setting_state( this, 'off' );
		}else{
			rows.filter( '[data-container="backgroundColor"]' ).setting_state( this, 'on' );
		}

		if ( ! withTitle.includes( value ) ) {
			rows.filter( '[data-container="hide_title"], [data-container="titleColor"], [data-container="titleFontSize"], [data-container="mobileTitleFontSize"]' ).setting_state( this, 'off' );
		}else{
			rows.filter( '[data-container="hide_title"], [data-container="titleColor"], [data-container="titleFontSize"], [data-container="mobileTitleFontSize"]' ).setting_state( this, 'on' );
		}

		if ( ! withCaption.includes( value ) ) {
			rows.filter( '[data-container="hide_description"], [data-container="captionColor"], [data-container="captionFontSize"], [data-container="mobileCaptionFontSize"]' ).setting_state( this, 'off' );
		}else{
			rows.filter( '[data-container="hide_description"], [data-container="captionColor"], [data-container="captionFontSize"], [data-container="mobileCaptionFontSize"]' ).setting_state( this, 'on' );
		}

	},



	checkCustomResponsivness: function( settings, value){
		var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_responsive"]'),
            children  = currentRow.data( 'children' );

        jQuery.each(children, function(index, item) {

            var child = jQuery('[data-container="'+item+'"]');

            if ( 0 == value && currentRow.hasClass( 'modula_accordion_open' )) {
            	child.setting_state( this, 'off');
				child.show();
            }else if( 0 == value ){
				child.hide();
            }else{
				child.css('opacity', '1');
                child.find('input, textarea, select, button').removeAttr('disabled');
            	child.show();
			}

        });

		if( 1 == value ) {
			currentRow.addClass( 'modula_accordion_open' );
		}
	},

	changeAnimation: function( settings, value ){
		var rows = this.get( 'rows' ),
			parentRow = rows.filter('[data-container="enable_lightbox"]');

		if( '' == value ){ value = '0';	}
		if ( ('0' == value || 0 == wp.Modula.Settings.get( 'enable_lightbox') ) &&  parentRow.hasClass( 'modula_accordion_open' ) ) {

			rows.filter( '[data-container="animation_duration"]' ).setting_state( this, 'off' );
			rows.filter( '[data-container="animation_duration"]' ).show();
		}else if( ('0' != value && 1 == wp.Modula.Settings.get( 'enable_lightbox') ) &&  parentRow.hasClass( 'modula_accordion_open' )) {
			
			rows.filter( '[data-container="animation_duration"]' ).setting_state( this, 'on' );
			rows.filter( '[data-container="animation_duration"]' ).show();
		}else{

			rows.filter( '[data-container="animation_duration"]' ).hide();
		}

	},
	toggleAnimation: function(){
		var rows = this.get( 'rows' ),
			parentRow = rows.filter('[data-container="enable_lightbox"]');

		
		if( !parentRow.hasClass( 'modula_accordion_open' ) ){
			rows.filter( '[data-container="animation_duration"]' ).hide();
		}else{
			rows.filter( '[data-container="animation_duration"]' ).show();
		}
	},
	changeTransition: function( settings, value ){
		var rows = this.get( 'rows' ),
			parentRow = rows.filter('[data-container="enable_lightbox"]');

		if( '' == value ){ value = '0';	}
		if ( ('0' == value || 0 == wp.Modula.Settings.get( 'enable_lightbox') ) &&  parentRow.hasClass( 'modula_accordion_open' ) ) {

			rows.filter( '[data-container="transition_duration"]' ).setting_state( this, 'off' );
			rows.filter( '[data-container="transition_duration"]' ).show();
		}else if( ('0' != value && 1 == wp.Modula.Settings.get( 'enable_lightbox') ) &&  parentRow.hasClass( 'modula_accordion_open' )) {
			
			rows.filter( '[data-container="transition_duration"]' ).setting_state( this, 'on' );
			rows.filter( '[data-container="transition_duration"]' ).show();
		}else{

			rows.filter( '[data-container="transition_duration"]' ).hide();
		}
	},

	toggleTransition: function(){
		var rows = this.get( 'rows' ),
		parentRow = rows.filter('[data-container="enable_lightbox"]');

		
		if( !parentRow.hasClass( 'modula_accordion_open' ) ){
			rows.filter( '[data-container="transition_duration"]' ).hide();
		}else{
			rows.filter( '[data-container="transition_duration"]' ).show();
		}
	},
	changeShare: function( settings, value){

		var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_share"]'),
            children  = currentRow.data( 'children' );

        jQuery.each(children, function(index, item) {

            var child = jQuery('[data-container="'+item+'"]');


            if ( (0 == value || 0 == wp.Modula.Settings.get( 'enable_lightbox')) && currentRow.hasClass( 'modula_accordion_open' )) {
            	child.setting_state( this, 'off');
				child.show();
            }else if( 0 == value || 0 == wp.Modula.Settings.get( 'enable_lightbox')){
				child.hide();
            }else{
				child.css('opacity', '1');
                child.find('input, textarea, select, button').removeAttr('disabled');
            	child.show();
			}
        });


		if ( 1 == value && 1 == wp.Modula.Settings.get( 'enable_lightbox') ) {
			currentRow.addClass( 'modula_accordion_open' );
		}

		this.changeEmail( false, wp.Modula.Settings.get( 'lightbox_email' ) );
	},

	toggleShare: function(){
		var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_share"]'),
			parentRow = rows.filter('[data-container="enable_lightbox"]'),
			children  = currentRow.data( 'children' );

		jQuery.each(children, function(index, item) {

			var child = jQuery('[data-container="'+item+'"]');

			if ( 1 == wp.Modula.Settings.get( 'enable_share' ) && parentRow.hasClass( 'modula_accordion_open' ) && 1 == wp.Modula.Settings.get( 'enable_lightbox' ) && currentRow.hasClass( 'modula_accordion_open' ) ) {
				child.css('opacity', '1');
				child.find('input, textarea, select, button').removeAttr('disabled');
				child.show();
				
			}else if( ( 0 == wp.Modula.Settings.get( 'enable_share' ) || 0 == wp.Modula.Settings.get( 'enable_lightbox' ) ) && parentRow.hasClass( 'modula_accordion_open' ) && currentRow.hasClass( 'modula_accordion_open' ) ){
				child.setting_state( this, 'off');
				child.show();
			}else{
				child.hide();
			}

		});

		if ( 1 == wp.Modula.Settings.get( 'enable_share' ) && parentRow.hasClass( 'modula_accordion_open' ) ) {
			currentRow.addClass( 'modula_accordion_open' );

		}

	},
	changeEmail: function( settings, value ) {
		var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="lightbox_email"]'),
            children  = currentRow.data( 'children' );

        jQuery.each(children, function(index, item) {

            var child = jQuery('[data-container="'+item+'"]');

            if ( ( ( 0 == value || 0 == wp.Modula.Settings.get( 'enable_lightbox')) ||  0 == wp.Modula.Settings.get( 'enable_share') ) && currentRow.hasClass( 'modula_accordion_open' )) {
            	child.setting_state( this, 'off');
				child.show();
            }else if( 0 == value || 0 == wp.Modula.Settings.get( 'enable_lightbox') ||  0 == wp.Modula.Settings.get( 'enable_share') ){
				child.hide();
            }else{
				child.css('opacity', '1');
                child.find('input, textarea, select, button').removeAttr('disabled');
            	child.show();
			}
        });

		if ( 1 == value && 1 == wp.Modula.Settings.get( 'enable_share') && 1 == wp.Modula.Settings.get( 'enable_lightbox') ) {
			currentRow.addClass( 'modula_accordion_open' );
		}
	},
	
	toggleEmail: function(){
		var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="lightbox_email"]'),
			parentRow = rows.filter('[data-container="enable_share"]'),
			parentRowTwo = rows.filter('[data-container="enable_lightbox"]'),
			children  = currentRow.data( 'children' );

		jQuery.each(children, function(index, item) {

			var child = jQuery('[data-container="'+item+'"]');
			
			if ( 1 == wp.Modula.Settings.get( 'lightbox_email' ) && currentRow.hasClass( 'modula_accordion_open' ) && 1 == wp.Modula.Settings.get( 'enable_share' ) && parentRow.hasClass( 'modula_accordion_open' )  && 1 == wp.Modula.Settings.get( 'enable_lightbox' ) && parentRowTwo.hasClass( 'modula_accordion_open' )  ) {
				child.css('opacity', '1');
				child.find('input, textarea, select, button').removeAttr('disabled');
				child.show();
			}else if( ( 0 == wp.Modula.Settings.get( 'enable_share' ) || 0 == wp.Modula.Settings.get( 'enable_lightbox' ) || 0 == wp.Modula.Settings.get( 'lightbox_email' ) ) && parentRow.hasClass( 'modula_accordion_open' ) && currentRow.hasClass( 'modula_accordion_open' ) && parentRowTwo.hasClass( 'modula_accordion_open' ) ){
				child.setting_state( this, 'off');
				child.show();
			}else{
				child.hide();
			}
		});

		if ( 1 == wp.Modula.Settings.get( 'lightbox_email' ) && parentRow.hasClass( 'modula_accordion_open' ) && parentRowTwo.hasClass( 'modula_accordion_open' ) ) {
			
			currentRow.addClass( 'modula_accordion_open' );

		}

	},
	changeAutoplay: function( settings, value ){
		var rows = this.get( 'rows' );

		if ( '1' == value && 1 == wp.Modula.Settings.get( 'enable_lightbox') ) {
			rows.filter( '[data-container="slideshow_duration"]' ).setting_state( this, 'on' );
			rows.filter( '[data-container="slideshow_duration"]' ).show();
		}else{
			rows.filter( '[data-container="slideshow_duration"]' ).setting_state( this, 'on' );
			rows.filter( '[data-container="slideshow_duration"]' ).hide();
		}
	},
	changeThumbnails: function( settings, value ){
		var rows = this.get( 'rows' ),
			parentRow = rows.filter('[data-container="enable_lightbox"]');

		if( '' == value ){ value = '0';	}
		if ( ('0' == value || 0 == wp.Modula.Settings.get( 'enable_lightbox') ) &&  parentRow.hasClass( 'modula_accordion_open' ) ) {

			rows.filter( '[data-container="autostart_thumbs"]' ).setting_state( this, 'off' );
			rows.filter( '[data-container="autostart_thumbs"]' ).show();
		}else if( ('0' != value && 1 == wp.Modula.Settings.get( 'enable_lightbox') ) &&  parentRow.hasClass( 'modula_accordion_open' )) {
			
			rows.filter( '[data-container="autostart_thumbs"]' ).setting_state( this, 'on' );
			rows.filter( '[data-container="autostart_thumbs"]' ).show();
		}else{

			rows.filter( '[data-container="autostart_thumbs"]' ).hide();
		}
	},

	toggleThumbnails: function(){
		var rows = this.get( 'rows' ),
		parentRow = rows.filter('[data-container="enable_lightbox"]');

		
		if( !parentRow.hasClass( 'modula_accordion_open' ) ){
			rows.filter( '[data-container="autostart_thumbs"]' ).hide();
		}else{
			rows.filter( '[data-container="autostart_thumbs"]' ).show();
		}
	},

});