wp.Modula = 'undefined' === typeof( wp.Modula ) ? {} : wp.Modula;

(function( $, modula ){

	var selection = Backbone.Collection.extend({});
    var library = Backbone.Collection.extend({
        modelId: function( attrs ) {
            return attrs.id;
        },

        searchItems: function( string ){
            var library = this;

            elements = _.filter(library.models, function( item ) {
                var title = item.get( 'title' ).toLowerCase(),
                    check = title.search( string );

                if ( -1 == check ) {
                    item.set( 'visible', false )
                    return false;
                }
                item.set( 'visible', true )
                return true;
            });

            library.trigger( 'modula-search-complete' );
            return elements;

        }
    });

	var modal = Backbone.Model.extend({
		initialize: function( args ){
            var self = this;
            var selection = new modula.modal['selection']();
            var library = new modula.modal['library']();
            this.set( 'selection', selection );
            this.set( 'library', library );

            // var library = ;
            wp.ajax.post( 'modula_get_galleries', {
                _wpnonce: modulaAlbumsAdmin._wpnonce,
            }).done(function( data ){

                jQuery.each( data,function( index, gallery ){

                    // Create Models
                    var item = new modula.modal['itemModel']( gallery );
                    library.add( item );

                });

                self.set( 'library', library );
            });

            var modalView = new modula.modal['view']({
                'model': this,
            });
            this.set( 'modalView', modalView );

            var wpMediaView = new wp.media.view.Modal( {
                controller: {
                    trigger: function() {}
                },
                title: 'Choose Galleries'
            } );
            this.set( 'modal', wpMediaView );

        },
        open: function() {
            var modal = this.get( 'modal' ),
                modalView = this.get( 'modalView' ),
                selection = this.get( 'selection' ),
                library = this.get( 'library' );

            _.each( modula.Galleries.models, function( item ){
                var id = item.get('id'),
                    itemLibrary = library.get( id );

                selection.add( itemLibrary );

            });

            // Render Modula View
            modalView.render();
            // Append modulaModalView to wpMediaView
            modal.content( modalView );
            // Open wpMediaView
            modal.open();

        },
        close: function(){
        	var modal = this.get( 'modal' ),
        		selection = this.get( 'selection' ),
                oldGalleriesCollection = wp.Modula.Galleries;

            modula.Galleries = new modula.galleries['collection']();
            // Iterate through selected images, building an images array
            selection.each( function( gallery ) {
                var attachmentAtts = gallery.attributes,
                    currentModel = oldGalleriesCollection.get( attachmentAtts['id'] );

                if ( currentModel ) {
                    modula.Galleries.addItem( currentModel );
                    oldGalleriesCollection.remove( currentModel );
                }else{
                    new modula.galleries['model']( gallery.toJSON() );
                }
            }, this );

            while ( model = oldGalleriesCollection.first() ) {
              model.delete();
            }

        	modal.close();
        	selection.reset();
        }
	});

    var itemModel = Backbone.Model.extend( {

        /**
        * Defaults
        * As we always populate this model with existing data, we
        * leave these blank to just show how this model is structured.
        */
        defaults: {
            'id':        '',
            'title':     '',
            'caption':   '',
            'alt':       '',
            'visible':   true,
            'cover':     0,
            'customurl': '',
            'coverinfo': {},
            'thumb':     {},
            'images':    {}
        },

        initialize: function( args ){

            var library = modula.galleriesModal.get( 'library' );
            this.listenTo( library, 'modula-search-complete', function(){
                var visible = this.get( 'visible' ),
                    view = this.get( 'view' );

                if ( ! visible ) {
                    if ( view ) {
                        view.$el.hide();
                    }
                }else{
                    if ( view ) {
                        view.$el.show();
                    }
                }
            } );

        },

    } );

	var modalView = Backbone.View.extend({
		/**
        * The Tag Name and Tag's Class(es)
        */
        tagName:    'div',
        className:  'modula-bulkedit-popup',
        childViews: [],
        items:      [],

        /**
        * Template
        * - The template to load inside the above tagName element
        */
        template:   wp.template( 'modula-albums-bulkedit' ),

        events: {
            'click #save-modula-albums-galleries': 'close',
            'click #modula-select-all':            'select',
            'click #modula-deselect-all':          'deselect',
            'click #modula-toggle':                'toggle',
            'keyup #modula-search-input':          'search',
            'change #modula-search-input':         'search',
        },

        initialize: function() {
            var self = this;
        },

        /**
        * Render
        * - Binds the model to the view, so we populate the view's fields and data
        */
        render: function() {
        	var self      = this,
                selection = this.model.get( 'selection' ),
                library   = this.model.get( 'library' );

            // Reset selection
            // selection.reset();

        	// Get HTML
            this.$el.html( this.template() );

            // Left area
            library.each( function( item ) {
            	var view = item.get( 'view' );

                if( '' == item.attributes.title ) {
                    item.attributes.title = 'Untitled';
                }

                if ( view ) {
                    view.remove();
                }

                var newView = new modula.modal['itemView']({ model: item });
                item.set( 'view', newView );

            	self.$el.find('ul.attachments').append( newView.render().el );
            });

        },

        close: function(){
            var self = this;
            self.model.close();
        },

        select: function(){
            var selection = this.model.get( 'selection' ),
                library   = this.model.get( 'library' );
            selection.add( library.models );
        },

        deselect: function(){
            var selection = this.model.get( 'selection' );
            selection.reset();
        },

        toggle: function(){
            var selection    = this.model.get( 'selection' ),
                library      = this.model.get( 'library' ),
                oldSelection = selection.clone();

            if ( selection.length == 0 ) {
                selection.add( modula.Items.models );
            }else if ( selection.length == modula.Items.length ) {
                selection.reset();
            }else{
                selection.reset();
                library.each( function( item ) {
                    if ( ! oldSelection.findWhere( { 'id': item.get('id') } ) ) {
                        selection.add( item );
                    }
                });
            }

            oldSelection.reset();
        },

        search: function(){
            var self = this,
                searchInput = self.$el.find('#modula-search-input'),
                library = self.model.get( 'library' );

            library.searchItems( searchInput.val() );
        }

	});

	var itemView = Backbone.View.extend({
		/**
        * The Tag Name and Tag's Class(es)
        */
        tagName:    'li',
        className:  'attachment',

        /**
        * Template
        * - The template to load inside the above tagName element
        */
        template:   wp.template( 'modula-gallery-item' ),

        events: {
            'click': 'checkStatus',
        },

        initialize: function( args ) {
		    var selection = modula.galleriesModal.get( 'selection' );
		    this.listenTo( selection, 'add', this.itemAdded );
            this.listenTo( selection, 'remove', this.itemRemoved );
		    this.listenTo( selection, 'reset', this.removeItem );

            this.checkSelected();

		},

        checkSelected: function(){
            var model = this.model,
                selection = modula.galleriesModal.get( 'selection' );

            if ( selection.contains( model ) ) {
                this.$el.addClass( 'selected details' );
            }

        },

        /**
        * Render
        * - Binds the model to the view, so we populate the view's fields and data
        */
        render: function() {

        	// Get HTML
            this.$el.html( this.template( this.model.toJSON() ) );
            return this;

        },

        checkStatus: function() {
        	var selection = modula.galleriesModal.get( 'selection' );

        	if ( this.$el.hasClass( 'selected' ) ) {
        		selection.remove( this.model );
        		// this.$el.removeClass( 'selected details' );
        	}else{
        		selection.add( this.model );
        		// this.$el.addClass( 'selected details' );
        	}
        },

        itemAdded: function() {
        	var selection = modula.galleriesModal.get( 'selection' );

        	if ( selection.findWhere( { 'id': this.model.get('id') } ) ) {
        		this.$el.addClass( 'selected details' );
        	}

        },

        itemRemoved: function() {
        	var selection = modula.galleriesModal.get( 'selection' );
        	if ( ! selection.findWhere( { 'id': this.model.get('id') } ) ) {
        		this.$el.removeClass( 'selected details' );
        	}

        },

        removeItem: function() {
            this.$el.removeClass( 'selected details' );
        }

	});

    modula.modal = {
        'model'      : modal,
        'view'       : modalView,
        'selection'  : selection,
        'library'    : library,
        'itemView'   : itemView,
        'itemModel'  : itemModel
    };

}( jQuery, wp.Modula ))