wp.Modula = 'undefined' === typeof( wp.Modula ) ? {} : wp.Modula;

(function( $, modula ){

	modula.hovereffects = {
        init: function(){

        	var style = '<style id="modula-hovereffect"></style>',
        		hoverEffects = this;
        	$('.modula-effects-preview').append( style );
        	this.generateCSS();

        	modula.Settings.on( 'change', function(){
        		hoverEffects.generateCSS();
        	});
        },

        generateCSS: function(){
        	var settings = modula.Settings.toJSON(),
        		style    = $('#modula-hovereffect'),
        		css      = '';

            if ( '0' != settings['captionFontSize'] ) {
                css += '.modula-settings-container .form-table td .modula-items .figc p.description{font-size:' + settings['captionFontSize'] + 'px;}';
            }else{
                css += '.modula-settings-container .form-table td .modula-items .figc p.description{font-size:inherit;}';
            }
        	css += '.modula-settings-container .form-table td .modula-items .figc p.description{ color:' + settings['captionColor'] + ';}';

            if ( '0' != settings['titleFontSize'] ) {
                css += '#poststuff .modula-effects-preview .modula-items .figc .figc-inner h2 {font-size:' + settings['titleFontSize'] + 'px}';
            }else{
                css += '#poststuff .modula-effects-preview .modula-items .figc .figc-inner h2 {font-size:inherit}';
            }
        	css += '#poststuff .modula-effects-preview .modula-items .figc .figc-inner h2 { color:' + settings['titleColor'] + ';}';
        	css += '.modula-effects-preview .modula-items .modula-item{ background-color:' + settings['hoverColor'] + ';}';
        	css += '.modula-effects-preview .modula-items .modula-item.effect-under .figc{ background-color:' + settings['backgroundColor'] + ';}';
        	css += '.modula-effects-preview .modula-items .modula-item:hover img.pic { opacity:' + parseInt(settings['hoverOpacity'])/100 + ';}'

        	if ( '1' == settings.display_image_count ) {
        		css += '#poststuff .modula-effects-preview .modula-item .figc h2 .image_count{display:inline-block}';
        	}

        	if ( '1' == settings.hide_title ) {
        		css += '#poststuff .modula-effects-preview .modula-item .figc h2 .title{display:none}';
        	}

        	if ( '1' == settings.hide_description ) {
        		css += '#poststuff .modula-effects-preview .modula-item .figc .description{display:none}';
        	}

            if ( '0' != settings.imageCountFontSize ) {
                css += '#poststuff .modula-effects-preview .modula-item .figc h2 .image_count{font-size:' + settings['imageCountFontSize'] + 'px;}';
            }

            if ( '' != settings.imageCountColor ) {
                css += '#poststuff .modula-effects-preview .modula-item .figc h2 .image_count{color:' + settings['imageCountColor'] + ';}';
            }



        	style.html( css );

        }
    }

}( jQuery, wp.Modula ));