wp.Modula = 'undefined' === typeof( wp.Modula ) ? {} : wp.Modula;

(function( $, modula ){

    var modulaSaveGalleries = {
        updateInterval: false,

        checkSave: function() {
            var self = this;

            $('#publishing-action .spinner').addClass( 'is-active' );
            $('#publishing-action #publish').attr( 'disabled', 'disabled' );

            if ( ! self.updateInterval ) {
                self.updateInterval = setInterval( $.proxy( self.saveImages, self), 1000);
            }else{
                clearInterval( self.updateInterval );
                self.updateInterval = setInterval( $.proxy( self.saveImages, self), 1000);
            }
        },

    	saveImages: function( callback = false ) {
            var galleries = [],
                self = this,
                ajaxData;

            clearInterval( self.updateInterval );

            wp.Modula.Galleries.each( function( item ) {
                var attributes = item.getAttributes();
                galleries[ attributes['index'] ] = attributes;
            });

            ajaxData = { '_wpnonce' : modulaHelper['_wpnonce'], 'action' : 'modula_albums_save_galleries', 'album' : modulaHelper['id'] };
            ajaxData['galleries'] = JSON.stringify( galleries );

            $.ajax({
                method: 'POST',
                url: modulaHelper['ajax_url'],
                data: ajaxData,
                dataType: 'json',
            }).done(function( msg ) {
                $('#publishing-action .spinner').removeClass( 'is-active' );
                $('#publishing-action #publish').removeAttr( 'disabled' );

                if( typeof callback === "function" ) {
                    callback();
                }
            });
        },

        saveImage: function( id, callback = false ) {
            var gallery = wp.Modula.Galleries.get( id ),
            	json  = gallery.getAttributes();

            $('#publishing-action .spinner').addClass( 'is-active' );
            $('#publishing-action #publish').attr( 'disabled', 'disabled' );

            ajaxData = { '_wpnonce': modulaHelper['_wpnonce'], 'action': 'modula_albums_save_gallery', 'album': modulaHelper['id'] };
            ajaxData['gallery'] = JSON.stringify( json );

            $.ajax({
                method: 'POST',
                url: modulaHelper['ajax_url'],
                data: ajaxData,
                dataType: 'json',
            }).done(function( msg ) {
                $('#publishing-action .spinner').removeClass( 'is-active' );
                $('#publishing-action #publish').removeAttr( 'disabled' );

                if( typeof callback === "function" ) {
                    callback();
                }
            });
        }
    }

    modula.Save = modulaSaveGalleries;

}( jQuery, wp.Modula ))
