wp.Modula = 'undefined' === typeof( wp.Modula ) ? {} : wp.Modula;

(function( $, modula ){

    var modulaSettings = Backbone.Model.extend({
    	initialize: function( args ){
            var model = this;
            $.each( args, function( att, value ){
                model.set( att, value );
            });

      		var view = new modula.settings['view']({
      			model: this,
      			el: $( '#modula-album-settings' )
      		});

      		this.set( 'view', view );

        },
    });

    var modulaSettingsView = Backbone.View.extend({

    	events: {
    		// Tabs specific events
    		'click .modula-tab':     'changeTab',
            'click .modula-tab > *': 'changeTabFromChild',
            'click .modula_settings_accordion': 'changeAcordeon',

    		// Settings specific events
            'keyup input':         'updateModel',
            'keyup textarea':      'updateModel',
            'change input':        'updateModel',
            'change textarea':     'updateModel',
            'blur textarea':       'updateModel',
            'change select':       'updateModel',
        },

        initialize: function( args ) {

        	this.tabs          = this.$el.find( '.modula-tabs .modula-tab' );
        	this.tabContainers = this.$el.find( '.modula-tabs-content > div' );
        	this.sliders       = this.$el.find( '.modula-ui-slider' );
        	this.colorPickers  = this.$el.find( '.modula-color' );

        	// initialize 3rd party scripts
        	this.initSliders();
        	this.initColorPickers();

        },

        updateModel: function( event ) {
        	var value, setting;

        	// Check if the target has a data-field. If not, it's not a model value we want to store
            if ( undefined === event.target.dataset.setting ) {
                return;
            }

            setting = event.target.dataset.setting;

            // Update the model's value, depending on the input type
            if ( event.target.type == 'checkbox' ) {
                value = ( event.target.checked ? event.target.value : 0 );
            } else {
                value = event.target.value;
            }

            // Update the model
            this.model.set( setting, value );

        },

        changeTab: function ( event ) {

        	var currentTab = jQuery( event.target ).data( 'tab' );

            if ( this.tabContainers.filter( '#' + currentTab ).length < 1 ) {
                return;
            }

    		this.tabs.removeClass( 'active-tab' );
    		this.tabContainers.removeClass( 'active-tab' );
    		jQuery( event.target ).addClass( 'active-tab' );
    		this.tabContainers.filter( '#' + currentTab ).addClass( 'active-tab' );

        },

        changeTabFromChild: function ( event ) {

            var currentTab = jQuery( event.target ).parent().data( 'tab' );

            if ( this.tabContainers.filter( '#' + currentTab ).length < 1 ) {
                return;
            }

            this.tabs.removeClass( 'active-tab' );
            this.tabContainers.removeClass( 'active-tab' );
            jQuery( event.target ).parent().addClass( 'active-tab' );
            this.tabContainers.filter( '#' + currentTab ).addClass( 'active-tab' );

        },
        
        changeAcordeon: function ( event ) {
            var row = jQuery( event.target ).parents( 'tr' ),
                settingID = row.data( 'container' ),
                children  = row.data( 'children' ),
                value = wp.Modula.Settings.get( settingID ),
                parentval = 1;

            row.toggleClass( 'modula_accordion_open' );
           
            if( row.hasClass( 'modula_accordion_reversed' ) ){
                if( 0 == value ){ value = 1; }else{ value = 0; }
            }

            if( row.data( 'parent' ) ){
                //recursively check for parents
                parentval = this.chechParents(row[0], parentval);
            }

            jQuery.each(children, function(index, item) {

                var child = jQuery('[data-container="'+item+'"]');
                    
                if ( 1 == value && 1 == parentval ) {
                    child.css('opacity', '1');
                    child.find('input, textarea, select, button').removeAttr('disabled');
                }else{
                    child.css('opacity', '0.5');
                    child.find('input, textarea, select, button').attr('disabled', 'disabled');
                    
                }

                if ( row.hasClass( 'modula_accordion_open' ) ) {
                    child.show();
                }else{
                    child.hide();
                }

            });

            let customEvent = 'toggleAccordeon:'+settingID;
            this.model.trigger( 'toggleAccordeon' );
            this.model.trigger( customEvent );

            
        },

        chechParents: function ( parent, parentval ) {

            if( jQuery(parent).data( 'parent' ) && 1 == parentval ){

                if( 1 == wp.Modula.Settings.get( jQuery(parent).data( 'parent' ) ) ){
                    
                    parentval = this.chechParents( jQuery('[data-container="'+jQuery(parent).data( 'parent' ) +'"]'), parentval );
                }else{

                    parentval = 0;
                    return 0;
                   
                }
                
            }

            return parentval;

        },

        initSliders: function() {

        	if ( this.sliders.length > 0 ) {
    			this.sliders.each( function( $index, $slider ) {
                    var input = jQuery( $slider ).parent().find( '.modula-ui-slider-input' ),
                        max = input.data( 'max' ),
                        min = input.data( 'min' ),
                        step = input.data( 'step' ),
                        value = parseInt( input.val(), 10 );

                    jQuery( $slider ).slider({
                        value: value,
                        min: min,
                        max: max,
                        step: step,
                        range: 'min',
                        slide: function( event, ui ) {
                            input.val( ui.value ).trigger( 'change' );
                        }
                    });
                });
    		}

        },

        initColorPickers: function() {
        	if ( this.colorPickers.length > 0 ) {
                this.colorPickers.each( function( $index, colorPicker ) {
                    jQuery( colorPicker ).wpColorPicker({
                        change: function( event, ui ) {
                            $(event.target).val( ui.color.toString() );
                            $( event.target ).trigger('change')
                        }
                    });
                });
            }
        }
       
    });

    modula.settings = {
        'model' : modulaSettings,
        'view' : modulaSettingsView
    };

}( jQuery, wp.Modula ))

