wp.Modula = 'undefined' === typeof( wp.Modula ) ? {} : wp.Modula;
wp.Modula.modalChildViews = 'undefined' === typeof( wp.Modula.modalChildViews ) ? [] : wp.Modula.modalChildViews;
wp.Modula.previewer = 'undefined' === typeof( wp.Modula.previewer ) ? {} : wp.Modula.previewer;
wp.Modula.modal = 'undefined' === typeof( wp.Modula.modal ) ? {} : wp.Modula.modal;
wp.Modula.galleries = 'undefined' === typeof( wp.Modula.galleries ) ? {} : wp.Modula.galleries;
wp.Modula.upload = 'undefined' === typeof( wp.Modula.upload ) ? {} : wp.Modula.upload;

jQuery( document ).ready( function( $ ){

	// Here we will have all gallery's items.
	if(wp.Modula.galleries['collection']){
		wp.Modula.Galleries = new wp.Modula.galleries['collection']();
	}

	// Settings related objects.
	wp.Modula.Settings = new wp.Modula.settings['model']( modulaHelper.settings );

	// Modula conditions
	wp.Modula.Conditions = new modulaGalleryConditions();

	// Add this here in order for other extensions to hook into it. This fixes some problems regarding the
	// order of execution.
	jQuery(document).trigger( 'modula_albums_admin_trigger' );

	// Initiate Modula Resizer
	if ( 'undefined' == typeof wp.Modula.Resizer && wp.Modula.previewer['resizer'] ) {
		wp.Modula.Resizer = new wp.Modula.previewer['resizer']();
	}
	
	// Initiate Gallery View
	if(wp.Modula.previewer['view']){
		wp.Modula.GalleryView = new wp.Modula.previewer['view']({
			'el' : $( '#modula-uploader-container' ),
		});
	}

	if('undefined' !== typeof wp.Modula.editModal){
		// Modula edit item modal.
		wp.Modula.EditModal = new wp.Modula.editModal['model']({
			'childViews' : wp.Modula.modalChildViews
		});
	}

	// Here we will add items for the gallery to collection.
	if ( 'undefined' !== typeof modulaHelper.items ) {
		$.each( modulaHelper.items, function( index, image ){
			var imageModel = new wp.Modula.galleries['model']( image );
		});
	}

	// Hover Effects
	wp.Modula.hovereffects.init();

	// Bulk Edit
	if(wp.Modula.modal['model']){
		wp.Modula.galleriesModal = new wp.Modula.modal['model'];
	}

	$('#modula-wp-gallery').click(function( evt ){
		evt.preventDefault();
		wp.Modula.galleriesModal.open();
	});

	// Save on CTRL/Meta Key + S
	$( document ).keydown( function ( e ) {
		if ( ( e.keyCode === 115 || e.keyCode === 83 ) && ( e.ctrlKey || e.metaKey ) && !( e.altKey ) ) {
			e.preventDefault();
			$( '#publish' ).click();
			return false;
		}
	} );
	jQuery( 'tr[data-container="lightboxEmailMessage"] td .modula-placeholders' ).on('click', 'span', function(){
		let input = jQuery( 'textarea[data-setting="lightboxEmailMessage"]');
		let placeholder = jQuery(this).attr('data-placeholder') ;
		input.val( function( index, value ){
			value += placeholder;
			return value;
		})
	})
	jQuery( document ).on( 'click', '#modula-hover-effect .modula-hover-effect-item' ,function () {
		let input = jQuery( this ).find( 'input[type="radio"]' );
		if ( input.length > 0 ) {
			input.prop( "checked", false );
			input.prop( "checked", true );
			input.trigger( "change" );
		}
	} ); 

});