/*
 *  Project: jQuery Modula 2
 *  Version: 1.0
 *  Description: Artistic gallery
 *  Author: WPChill
 */
function tg_getURLParameter(name) {
	return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search) || [, ""])[1].replace(/\+/g, '%20')) || null
}


// Compatibility with WPBakery Page Builder
jQuery(document).on('vc-full-width-row-single vc-full-width-row', function (event, element) {
	if (jQuery('body').find('.modula').length > 0) {
		jQuery(window).trigger('modula-update');
	}
});

// Compatibility with Elementor
jQuery(window).on('elementor/frontend/init', function () {
	if (window.elementorFrontend) {
		window.elementorFrontend.hooks.addAction('frontend/element_ready/global', function ($scope) {
			if (jQuery('body').find('.modula').length > 0) {
				jQuery(window).trigger('modula-update');
			}
		});
	}
});

;(function ($, window, document, undefined) {


	// Create the defaults once
	var pluginName = 'modulaAlbums',
		defaults = {
			resizer: '/',
			keepArea: true,
			type: '3',
			columns: 3,
			gutter: 10,
			enableResponsive: false,
			tabletColumns: 2,
			mobileColumns: 1,
			/*enableTwitter: false,
			enableFacebook: false,
			enableGplus: false,
			enablePinterest: false,
			enableLinkedin: false,
			enableWhatsapp: false,*/
			lazyLoad: 0,
			initLightbox: false,
			lightbox_settings: {},
		};

	// The actual plugin constructor
	function Plugin(element, options) {
		this.element = element;
		this.$element = $(element);
		this.$itemsCnt = this.$element.find(".modula-items");
		this.$items = this.$itemsCnt.find(".modula-item");

		this.options = $.extend({}, defaults, options);

		this._defaults = defaults;
		this._name = pluginName;

		this.tiles = [];
		this.$tilesCnt = null;
		this.completed = false;
		this.lastWidth = 0;
		this.resizeTO = 0;
		this.isIsotope = false;

		// Initiate Gallery
		this.init();
	}

	Plugin.prototype.init = function () {

		var instance = this;

		// Trigger event before init
		$(document).trigger('modula_albums_api_before_init', [instance]);

		if ('custom-grid' === this.options.type) {
			this.createCustomGallery();
		} else {
			this.createColumnsGrid();
		}

		$(window).resize(function () {
			instance.onResize(instance);
		});

		$(window).on('modula-update', function () {
			instance.onResize(instance);
		});

		$(document).on('lazyloaded',  function (evt) {
			var element = $(evt.target),
				parent, index;

			if ('modula-album' == element.data('source')) {
				element.data('size', {width: element.width(), height: element.height()});
				parent = element.parents('.modula-item');
				parent.addClass('tg-loaded');
				index = instance.$items.index(parent);
				instance.placeImage(index);

				if ( instance.isIsotope ) {
					instance.$itemsCnt.modulaisotope('layout');
				}
			}

		});


		// Create social links
		//this.setupSocial();
		$(instance.$element).addClass('modula-album-initialized');
		// Trigger custom gallery JS
		if (this.options.onComplete) {
			this.options.onComplete();
		}

		// Init lightox
		if (!instance.options['initLightbox']) {
			this.initLightbox();
		}

		// Trigger event after init
		$(document).trigger('modula_albums_api_after_init', [instance]);


	};

	Plugin.prototype.initLightbox = function () {
		var self = this;

		self.$element.find('.gallery-link:not(.simple-link)').click( function( evt ){
			evt.preventDefault();

			var images = $(this).data( 'gallery-images' ),
				gallery = $(this).data( 'gallery-id' );

			self.options.lightbox_settings['beforeLoad'] = function () {
                jQuery(document).trigger('modula_albums_fancybox_lightbox_before_load', [self, this]);
            };
            self.options.lightbox_settings['afterLoad'] = function () {
                jQuery(document).trigger('modula_albums_fancybox_lightbox_after_load', [self, this]);
            };
            self.options.lightbox_settings['beforeShow'] = function () {
                jQuery(document).trigger('modula_albums_fancybox_lightbox_before_show', [self, this]);
            };
            self.options.lightbox_settings['afterShow'] = function () {
                jQuery(document).trigger('modula_albums_fancybox_lightbox_after_show', [self, this]);
            };
            self.options.lightbox_settings['beforeClose'] = function () {
                jQuery(document).trigger('modula_albums_fancybox_lightbox_before_close', [self, this]);
            };
            self.options.lightbox_settings['afterClose'] = function () {
                jQuery(document).trigger('modula_albums_fancybox_lightbox_after_close', [self, this]);
            };
            self.options.lightbox_settings['onInit'] = function () {
                jQuery(document).trigger('modula_albums_fancybox_lightbox_on_init', [self, this]);
            };
            self.options.lightbox_settings['onActivate'] = function () {
                jQuery(document).trigger('modula_albums_fancybox_lightbox_on_activate', [self, this]);
            };
            self.options.lightbox_settings['onDeactivate'] = function () {
                jQuery(document).trigger('modula_albums_fancybox_lightbox_on_deactivate', [self, this]);
            };
			$.modulaFancybox.open( images, self.options.lightbox_settings );

		});

	}

	Plugin.prototype.trunc = function (v) {

		if (Math.trunc) {
			return Math.trunc(v);
		} else {
			v = +v;
			if (!isFinite(v)) return v;

			return (v - v % 1) || (v < 0 ? -0 : v === 0 ? v : 0);
		}
	}

	// Create custom grid gallery based on packery.
	Plugin.prototype.createCustomGallery = function () {

		var instance = this,
			size,
			containerWidth = this.$element.width(),
			plugin = this,
			columns = this.options.columns,
			viewport = document.documentElement.clientWidth;

		if ('1' == this.options.enableResponsive) {

			if (viewport <= 568) {
				columns = this.options.mobileColumns;
			} else if (viewport <= 768) {
				columns = this.options.tabletColumns;
			}

		}

		if (this.options.gutter > 0) {
			size = (containerWidth - this.options.gutter * (columns - 1)) / columns;
		} else {
			size = Math.floor((containerWidth / columns) * 1000) / 1000;
		}

		this.$items.each(function (i, item) {
			var slot = {}, widthColumns, heightColumns, auxWidth, auxHeight;

			widthColumns = $(item).data('width');
			heightColumns = $(item).data('height');

			if (widthColumns > 12) {
				widthColumns = 12;
			}

			if ('1' == plugin.options.enableResponsive) {
				auxWidth = widthColumns;
				auxHeight = heightColumns;

				if (1 == columns) {

					widthColumns = 1;
					heightColumns = widthColumns * auxHeight / auxWidth;

				} else {

					widthColumns = Math.round(columns * auxWidth / 12);
					if (widthColumns < 1) {
						widthColumns = 1;
					}

					heightColumns = Math.round(widthColumns * auxHeight / auxWidth);
					if (heightColumns < 1) {
						heightColumns = 1;
					}

				}

			}

			slot.width = size * widthColumns + (plugin.options.gutter * (widthColumns - 1));
			slot.height = Math.round(size) * heightColumns + (plugin.options.gutter * (heightColumns - 1));

			$(item)
				.data('size', slot)
				.addClass('tiled')
				.addClass(slot.width > slot.height ? 'tile-h' : 'tile-v')
				.data('position');

			$(item).css($(item).data('size'));
			$(item).find(".figc").css({
				width: $(item).data('size').width,
				height: $(item).data('size').height
			});

			// Load Images
			if ('1' != instance.options.lazyLoad) {
				instance.loadImage(i);
			}

		});

		var packery_args = {
			itemSelector: '.modula-item',
			layoutMode: 'packery',
			packery: {
				gutter: parseInt(plugin.options.gutter)
			}
		};

		if ( ! this.isIsotope ) {
			this.$itemsCnt.modulaisotope(packery_args);
			this.isIsotope = true;
		}else{
			instance.$itemsCnt.modulaisotope('layout');
		}


	}

	Plugin.prototype.createColumnsGrid = function () {
		var instance = this;

		// Load Images
		if ('1' != instance.options.lazyLoad) {
			this.$items.each(function (index, el) {
				instance.loadImage(index);
			});
		}

		if ( ! this.isIsotope ) {
			this.$itemsCnt.modulaisotope({
				// set itemSelector so .grid-sizer is not used in layout
				itemSelector: '.modula-item',
				// percentPosition: true,
				layoutMode: 'packery',
				packery: {
					// use element for option
					gutter: parseInt(this.options.gutter)
				}

			});
			this.isIsotope = true;
		}else{
			instance.$itemsCnt.modulaisotope('layout');
		}

	}

	Plugin.prototype.getSlot = function () {

		if (this.tiles.length == 0) {
			var tile = {
				top: 0,
				left: 0,
				width: this.$itemsCnt.width(),
				height: this.options.height,
				area: this.$itemsCnt.width() * this.options.height,
				position: 0
			};

			return tile;
		}

		var maxTileIdx = 0;
		for (var i = 0; i < this.tiles.length; i++) {
			var tile = this.tiles[i];
			if (tile.area > this.tiles[maxTileIdx].area) {
				maxTileIdx = i;
			}
		}

		var tile = {};

		var maxTileData = this.tiles[maxTileIdx];

		if (maxTileData.width > maxTileData.height) {

			var randomMaxDelta = maxTileData.width / 2 * this.options.randomFactor;


			maxTileData.prevWidth = maxTileData.width;
			maxTileData.width = Math.floor((maxTileData.width / 2) +
				(randomMaxDelta * (Math.random() - .5)));

			tile = {
				top: maxTileData.top,
				left: maxTileData.left + maxTileData.width + this.options.gutter,
				width: maxTileData.prevWidth - maxTileData.width - this.options.gutter,
				height: maxTileData.height
			}

		} else {
			var randomMaxDelta = maxTileData.height / 2 * this.options.randomFactor;

			maxTileData.prevHeight = maxTileData.height;
			maxTileData.height = Math.floor((maxTileData.height / 2) +
				(randomMaxDelta * (Math.random() - .5)));

			tile = {
				left: maxTileData.left,
				top: maxTileData.top + maxTileData.height + this.options.gutter,
				width: maxTileData.width,
				height: maxTileData.prevHeight - maxTileData.height - this.options.gutter
			}
		}

		tile.area = tile.width * tile.height;
		tile.position = tile.top * 1000 + tile.left;

		maxTileData.position = maxTileData.top * 1000 + maxTileData.left;

		this.tiles[maxTileIdx] = maxTileData;
		this.tiles[maxTileIdx].area = maxTileData.width * maxTileData.height;

		return tile;
	}

	Plugin.prototype.reset = function () {
		var instance = this;
		instance.tiles = [];

		if ('custom-grid' === instance.options.type) {
			this.createCustomGallery();
		} else {
			this.createColumnsGrid();
		}

		instance.lastWidth = instance.$itemsCnt.width();

	}

	Plugin.prototype.onResize = function (instance) {

		if (instance.lastWidth == instance.$itemsCnt.width())
			return;

		clearTimeout(instance.resizeTO);
		instance.resizeTO = setTimeout(function () {

			if (instance.options.keepArea) {
				var area = instance.$itemsCnt.data('area');
				instance.$itemsCnt.height(area / instance.$itemsCnt.width());
			}

			instance.reset();
			if ( instance.isIsotope ) {
				instance.$itemsCnt.modulaisotope('layout');
			}

		}, 1000);
	}

	Plugin.prototype.loadImage = function (index) {
		var instance = this;
		var source = instance.$items.eq(index).find('.pic');
		var img = new Image();
		img.onerror = function () {
			console.log("error loading image [" + index + "] : " + this.src);
			if (index + 1 < instance.$items.length)
				instance.loadImage(index + 1);
		}
		img.onload = function () {
			source.data('size', {width: this.width, height: this.height});
			instance.placeImage(index);

			instance.$items.eq(index).addClass("tg-loaded");
			if (index + 1 < instance.$items.length)
				instance.loadImage(index + 1);
		}

		var original_src = source.data('src');
		img.src = original_src;
		source.attr("src", original_src);

		instance.placeImage(index);

	}

	Plugin.prototype.placeImage = function (index) {

		if ('custom-grid' != this.options.type) {
			return;
		}

		var $tile = this.$items.eq(index);
		var $image = $tile.find('.pic');

		var tSize = $tile.data('size');
		var iSize = $image.data('size');

		// if ( $image.parent() != $tile ) {
		// 	tSize = {
		// 		'width': $image.parent().width(),
		// 		'height': $image.parent().height()
		// 	};
		// }

		if (typeof tSize == 'undefined') {
			return;
		}
		if (typeof iSize == 'undefined') {
			return;
		}

		var tRatio = tSize.width / tSize.height;
		var iRatio = iSize.width / iSize.height;


		var valign = $image.data('valign') ? $image.data('valign') : 'middle';
		var halign = $image.data('halign') ? $image.data('halign') : 'center';

		var cssProps = {
			top: 'auto',
			bottom: 'auto',
			left: 'auto',
			right: 'auto',
			width: 'auto',
			height: 'auto',
			margin: '0',
			maxWidth: '999em'
		};

		if (tRatio > iRatio) {
			cssProps.width = tSize.width;
			cssProps.left = 0;

			switch (valign) {
				case 'top':
					cssProps.top = 0;
					break;
				case 'middle':
					cssProps.top = 0 - (tSize.width * (1 / iRatio) - tSize.height) / 2;
					break;
				case 'bottom':
					cssProps.bottom = 0;
					break;
			}

		} else {

			cssProps.height = tSize.height;
			cssProps.top = 0;

			switch (halign) {
				case 'left':
					cssProps.left = 0;
					break;
				case 'center':
					cssProps.left = 0 - (tSize.height * iRatio - tSize.width) / 2;
					break;
				case 'right':
					cssProps.right = 0;
					break;
			}
		}

		$image.css(cssProps);
		this.$items.eq(index).addClass("tg-loaded");
	}

	/*Plugin.prototype.setupSocial = function () {
		if (this.options.enableTwitter) {
			setupTwitter(this.$items, this);
		}
		if (this.options.enableFacebook) {
			setupFacebook(this.$items, this);
		}
		if (this.options.enablePinterest) {
			setupPinterest(this.$items, this);
		}
		if (this.options.enableLinkedin) {
			setupLinkedIN(this.$items, this);
		}
		if (this.options.enableWhatsapp) {
			setupWhatsapp(this.$items, this);
		}
	}*/

	Plugin.prototype.destroy = function () {

		if (this.isPackeryActive) {
			this.$itemsCnt.packery('destroy');
			this.isPackeryActive = false;
		}

	}

	//credits James Padolsey http://james.padolsey.com/
	var qualifyURL = function (url) {
		var img = document.createElement('img');
		img.src = url; // set string url
		url = img.src; // get qualified url
		img.src = null; // no server request
		return url;
	}

	/*var setupTwitter = function ($tiles, plugin) {
		$tiles.find(".modula-icon-twitter").click(function (e) {
			e.preventDefault();

			//var $caption = $(this).parents(".tile:first").find(".description");
			var $caption = '';

			var text = plugin.options.twitterText || document.title;
			if (!plugin.options.twitterText && $caption.length == 1 && $caption.text().length > 0)
				text = $.trim($caption.text());

			var w = window.open("https://twitter.com/intent/tweet?url=" + encodeURI(location.href.split('#')[0]) + "&text=" + encodeURI(text), "ftgw", "location=1,status=1,scrollbars=1,width=600,height=400");
			w.moveTo((screen.width / 2) - (300), (screen.height / 2) - (200));
			return false;
		});
	}

	var setupFacebook = function ($tiles, plugin) {
		$tiles.find(".modula-icon-facebook").click(function (e) {
			e.preventDefault();

			var image = $(this).parents(".tile:first").find(".pic");

			//var $caption = $(this).parents(".tile:first").find(".description");
			var $caption = '';

			var text = plugin.options.facebookText || document.title;
			if (!plugin.options.facebookText && $caption.length == 1 && $caption.text().length > 0)
				text = $.trim($caption.text());


			var src = image.attr("src");
			var url = "//www.facebook.com/sharer.php?u=" + location.href;

			var w = window.open(url, "ftgw", "location=1,status=1,scrollbars=1,width=600,height=400");
			w.moveTo((screen.width / 2) - (300), (screen.height / 2) - (200));
			return false;
		});
	}

	var setupWhatsapp = function ($tiles, plugin) {
		$tiles.find(".modula-icon-whatsapp").click(function (e) {
			e.preventDefault();

			//var $caption = $(this).parents(".tile:first").find(".description");
			var $caption = '';

			var text = plugin.options.whatsappText || document.title;

			if (!plugin.options.whatsappText && $caption.length == 1 && $caption.text().length > 0)
				text = $.trim($caption.text());

			var w = window.open("https://api.whatsapp.com/send?text=" + encodeURI((window.location.href.split("#")[0])) + '&preview_url=true', "ftgw", "location=1,status=1,scrollbars=1,width=600,height=400");
			w.moveTo((screen.width / 2) - (300), (screen.height / 2) - (200));
			return false;
		});
	}

	var setupPinterest = function ($tiles, plugin) {
		$tiles.find(".modula-icon-pinterest").click(function (e) {
			e.preventDefault();

			var image = $(this).parents(".tile:first").find(".pic");

			//var $caption = $(this).parents(".tile:first").find(".description");
			var $caption = '';

			var text = plugin.options.pinterestText || document.title;
			if (!plugin.options.pinterestText && $caption.length == 1 && $caption.text().length > 0)
				text = $.trim($caption.text());

			var url = "http://pinterest.com/pin/create/button/?url=" + encodeURI(location.href) + "&description=" + encodeURI(text);

			if (image.length == 1) {
				var src = image.attr("src");
				url += ("&media=" + qualifyURL(src));
			}

			var w = window.open(url, "ftgw", "location=1,status=1,scrollbars=1,width=600,height=400");
			w.moveTo((screen.width / 2) - (300), (screen.height / 2) - (200));
			return false;
		});
	}

	var setupLinkedIN = function ($tiles, plugin) {
		$tiles.find(".modula-icon-linkedin").click(function (e) {
			e.preventDefault();

			var url = "//linkedin.com/shareArticle?mini=true&url=" + +encodeURI(location.href);

			var w = window.open(url, "ftgw", "location=1,status=1,scrollbars=1,width=600,height=400");
			w.moveTo((screen.width / 2) - (300), (screen.height / 2) - (200));
			return false;
		});
	}*/

	$.fn[pluginName] = function (options) {
		var args = arguments;

		if (options === undefined || typeof options === 'object') {
			return this.each(function () {
				if (!$.data(this, 'plugin_' + pluginName)) {
					$.data(this, 'plugin_' + pluginName, new Plugin(this, options));
				}
			});

		} else if (typeof options === 'string' && options[0] !== '_' && options !== 'init') {

			var returns;

			this.each(function () {
				var instance = $.data(this, 'plugin_' + pluginName);

				// Tests that there's already a plugin-instance
				// and checks that the requested public method exists
				if (instance instanceof Plugin && typeof instance[options] === 'function') {

					// Call the method of our plugin instance,
					// and pass it the supplied arguments.
					returns = instance[options].apply(instance, Array.prototype.slice.call(args, 1));
				}

				// Allow instances to be destroyed via the 'destroy' method
				if (options === 'destroy') {
					$.data(this, 'plugin_' + pluginName, null);
				}
			});

			return returns !== undefined ? returns : this;
		}
	};

}(jQuery, window, document));

jQuery(window).on( 'load', function () {

	var modulaAlbums = jQuery('.modula.modula-album');

	jQuery.each(modulaAlbums, function () {
		var modulaID = jQuery(this).attr('id'),
			modulaSettings = jQuery(this).data('config');

		jQuery(this).modulaAlbums(modulaSettings);

	});


});