<script type="text/html" id="tmpl-modula-albums-bulkedit">
    <div class="media-frame-title"><h1><?php esc_html_e('Edit gallery', 'modula-albums') ?></h1></div>
    <div class="media-frame-menu">
        <div class="media-menu">
            <a id="modula-select-all" href="javascript:void(0);"
               class="media-menu-item"><?php esc_html_e('Select All', 'modula-albums') ?></a>
            <a id="modula-deselect-all" href="javascript:void(0);"
               class="media-menu-item "><?php esc_html_e('Deselect All', 'modula-albums') ?></a>
            <a id="modula-toggle" href="javascript:void(0);"
               class="media-menu-item"><?php esc_html_e('Toggle selection', 'modula-albums') ?></a>
        </div>
    </div>
    <div class="media-frame-content modula-albums-galleries" data-columns="7">
        <div class="attachments-browser">
            <div class="media-toolbar">
                <div class="media-toolbar-primary search-form">
                    <label for="media-search-input"
                           class="media-search-input-label"><?php esc_html_e('Search galleries', 'modula-albums') ?></label>
                    <input type="search" placeholder="<?php esc_html_e('Search modula galleries...', 'modula-albums') ?>"
                           id="modula-search-input" class="search">
                </div>
            </div>
            <ul tabindex="-1" class="attachments modula-albums-gallery-list"></ul>
        </div>
    </div>
    <div class="media-frame-toolbar">
        <div class="media-toolbar">
            <div class="media-toolbar-primary search-form">
                <button id="save-modula-albums-galleries" type="button"
                        class="button media-button button-primary button-large media-button-gallery">
                    <?php esc_html_e('Insert galleries', 'modula-albums') ?>
                </button>
            </div>
        </div>
    </div>
</script>

<script type="text/html" id="tmpl-modula-gallery-item">
    <div class="attachment-preview js--select-attachment type-image {{data.thumb.orientation}}">
        <div class="thumbnail">
            <div class="centered">
                <img src="{{data.thumb.thumbnail}}" draggable="false" alt="">
            </div>
        </div>
    </div>
    <div><p>{{data.title}}</p></div>
    <button type="button" class="check" tabindex="-1"><span class="media-modal-icon"></span><span
                class="screen-reader-text"><?php esc_html_e('Deselect', 'modula-albums') ?></span></button>
</script>

<script type="text/html" id="tmpl-modula-gallery">
    <# var background = data.thumb.thumbnail, image = data.thumb.thumbnail;
    if ( ! _.isUndefined(data.coverURL) && '' != data.coverURL ) {
    background = data.coverURL;
    image = data.coverURL;
    }
    #>
    <div class="modula-single-image-content {{data.orientation}}" <# if ( data.full != '' ) { #> style="background-image:url({{ background }})" <# } #> >
        <div class="cover-badge <# if ( '1' == data.shuffleCover ) { #> shuffle-images-preview <# } #>">
            <# if ( ! _.isUndefined(data.coverURL) && '' != data.coverURL && '1' != data.shuffleCover ) { #>
                <?php esc_attr_e('Custom Cover Image', 'modula-albums') ?>
            <# } else if( '1' == data.shuffleCover ) { #>
                <?php esc_attr_e('Shuffle images', 'modula-albums') ?><br />
		        <# if(data.title && ''!= data.title ){ #>
		          <?php esc_html_e('Gallery title:','modula-albums'); ?> {{data.title}}
		        <# } #>
            <# } else { #>
	        <?php esc_attr_e('First Gallery Image', 'modula-albums') ?>
	        <# } #>
        </div>
        <img src="{{ image }}">
        <div class="actions">
            <a href="#" class="modula-edit-gallery" title="<?php esc_attr_e('Edit Image', 'modula-albums') ?>"><span class="dashicons dashicons-edit"></span></a>
            <a href="#" class="modula-delete-gallery" title="<?php esc_attr_e('Delete Image', 'modula-albums') ?>"><span class="dashicons dashicons-trash"></span></a>
        </div>
        <div class="segrip ui-resizable-handle ui-resizable-se"></div>
    </div>
    <input type="hidden" name="modula-gallery[]" value="{{data.json}}">
</script>

<script type="text/html" id="tmpl-modula-gallery-editor">
    <div class="edit-media-header">
        <button class="left dashicons"><span
                    class="screen-reader-text"><?php esc_html_e('Edit previous media item', 'modula-albums'); ?></span>
        </button>
        <button class="right dashicons"><span
                    class="screen-reader-text"><?php esc_html_e('Edit next media item', 'modula-albums'); ?></span>
        </button>
    </div>
    <div class="media-frame-title">
        <h1><?php esc_html_e('Edit Metadata', 'modula-albums'); ?></h1>
    </div>
    <div class="media-frame-content">
        <div class="attachment-details save-ready">
            <!-- Left -->
            <div class="attachment-media-view portrait">
                <div class="thumbnail thumbnail-image">
                    <img class="details-image" src="{{ data.thumb.thumbnail }}" draggable="false"/>
                </div>
            </div>

            <!-- Right -->
            <div class="attachment-info">
                <!-- Settings -->
                <div class="settings">
                    <!-- Attachment ID -->
                    <input type="hidden" name="id" value="{{ data.id }}"/>

                    <!-- Image Title -->
                    <label class="setting">
                        <span class="name"><?php esc_html_e('Title', 'modula-albums'); ?></span>
                        <input type="text" name="title" value="{{ data.title }}"/>
                        <div class="description"><?php esc_html_e('Image titles can take any type of HTML.', 'modula-albums'); ?></div>
                    </label>

                    <!-- Caption Text -->
                    <label class="setting">
                        <span class="name"><?php esc_html_e('Caption Text', 'modula-albums'); ?></span>
                        <textarea name="caption">{{ data.caption }}</textarea>
                        <div class="description"><?php esc_html_e('This can be used to better explain what\'s the gallery for', 'modula-albums'); ?></div>
                    </label>

                    <!-- Alt Text -->
                    <label class="setting">
                        <span class="name"><?php esc_html_e('Alt Text', 'modula-albums'); ?></span>
                        <input type="text" name="alt" value="{{ data.alt }}"/>
                        <div class="description"><?php esc_html_e('Very important for SEO, the Alt Text describes the image.', 'modula-albums'); ?></div>
                    </label>

                    <!-- Cover Image -->
                    <div class="setting">
                        <span class="name"><?php esc_html_e('Cover Image ( please see description )', 'modula-albums'); ?></span>
                        <div style="display:flex;width:100%;flex-wrap:wrap;align-items: center;">
                            <div class="modula-album-cover-wrapper" style="width:150px;margin-right:10px;">
                                <# if ( ! _.isUndefined(data.coverThumb) && '' != data.coverThumb ) { #>
                                    <img src="{{data.coverThumb}}">
                                <# } #>
                            </div>
                            <# if ( _.isUndefined(data.coverURL) || '' == data.coverURL ) { #>
                            <button type="button" class="modula-album-edit-cover button-cover-image"><?php esc_html_e('Set cover image', 'modula-albums'); ?></button>
                            <# } #>
                            <# if ( ! _.isUndefined(data.coverURL) && '' != data.coverURL ) { #>
                                <div class="actions" style="width:150px;">
                                    <button class="button button-primary button-cover-image"><?php esc_html_e('Change cover image', 'modula-albums'); ?></button>
                                    <a href="#" class="delete-cover"><?php esc_html_e('Remove cover image', 'modula-albums'); ?></a>
                                </div>
                            <# } #>

                        </div>

                        <div class="description"><?php esc_html_e('This image will be used as your album cover. If you don\'t want to use one it will take the first image from your gallery', 'modula-albums'); ?></div>
                    </div>

	                <!-- Suffle cover Image -->
	                <div class="setting">
		                <span class="name"><?php esc_html_e('Shuffle cover on page load', 'modula-albums'); ?></span>
		                <div class="modula-toggle">
			                <input class="modula-toggle__input" type="checkbox" id="shuffleCover" name="shuffleCover" value="1" <# if ( '1' == data.shuffleCover ) { #>  checked="checked" <# } #>>
			                <div class="modula-toggle__items">
				                <span class="modula-toggle__track"></span>
				                <span class="modula-toggle__thumb"></span>
				                <svg class="modula-toggle__off" width="6" height="6" aria-hidden="true" role="img" focusable="false" viewBox="0 0 6 6"><path d="M3 1.5c.8 0 1.5.7 1.5 1.5S3.8 4.5 3 4.5 1.5 3.8 1.5 3 2.2 1.5 3 1.5M3 0C1.3 0 0 1.3 0 3s1.3 3 3 3 3-1.3 3-3-1.3-3-3-3z"></path></svg>
				                <svg class="modula-toggle__on" width="2" height="6" aria-hidden="true" role="img" focusable="false" viewBox="0 0 2 6"><path d="M0 0h2v6H0z"></path></svg>
				                </div>
			                </div>
		                <div class="description"><?php esc_html_e('Setting this on will shuffle the cover of the gallery in the album on each page load, getting a random image from the gallery each time.', 'modula-albums'); ?></div>
	                </div>

                    <!-- Custom URL -->
                    <label class="setting">
                        <span class="name"><?php esc_html_e('Custom URL ( please see description )', 'modula-albums'); ?></span>
                        <input type="text" name="customurl" value="{{ data.customurl }}"/>
                        <div class="description"><?php esc_html_e('If no lightboxes are active, when a user clicks on a gallery they will be redirected to this link', 'modula-albums'); ?></div>
                    </label>

                    <!-- Addons can populate the UI here -->
                    <div class="modula-addons"></div>
                </div>
                <!-- /.settings -->

                <!-- Actions -->
                <div class="actions">
                    <a href="#"
                       class="modula-gallery-meta-submit button media-button button-large button-primary media-button-insert"
                       title="<?php esc_attr_e('Save album', 'modula-albums'); ?>">
                        <?php esc_html_e('Save', 'modula-albums'); ?>
                    </a>
                    <a href="#"
                       class="modula-gallery-meta-submit-close button media-button button-large media-button-insert"
                       title="<?php esc_attr_e('Save & Close', 'modula-albums'); ?>">
                        <?php esc_html_e('Save & Close', 'modula-albums'); ?>
                    </a>

                    <!-- Save Spinner -->
                    <span class="settings-save-status">
                        <span class="spinner"></span>
                        <span class="saved"><?php esc_html_e('Saved.', 'modula-albums'); ?></span>
                    </span>
                </div>
                <!-- /.actions -->
            </div>
        </div>
    </div>
</script>