<?php

class Modula_Albums_Gutenberg {

    function __construct() {

        // Return early if this function does not exist.
        if ( ! function_exists( 'register_block_type' ) ) {
            return;
        }

        add_action( 'init', array( $this, 'register_block_type' ) );
        add_action( 'init', array( $this, 'generate_js_vars' ) );
        add_action( 'wp_ajax_modula_get_album_meta', array( $this, 'get_album_meta' ) );
    }

    public function register_block_type() {

        wp_register_script('albums-gutenberg', MODULA_ALBUMS_URL . 'assets/js/admin/wp-modula-albums-gutenberg.js', array(), MODULA_ALBUMS_VERSION, true);
        wp_register_style( 'albums-gutenberg', MODULA_ALBUMS_URL . 'assets/css/admin/modula-albums-gutenberg.css', array(), true );

        register_block_type(
            'modula/albums',
            array(
                'render_callback' => array( $this, 'render_modula_album' ),
                'editor_script'   => 'albums-gutenberg',
                'editor_style'    => 'albums-gutenberg',
            )
        );

    }

    public function generate_js_vars() {

        wp_localize_script(
            'albums-gutenberg',
            'modulaAlbumsVars',
            apply_filters( 'modula_albums_gutenberg_vars', array(
                'adminURL'             => admin_url(),
                'ajaxURL'              => admin_url( 'admin-ajax.php' ),
                'nonce'                => wp_create_nonce( 'modula_nonce' ),
                'gutenbergAlbumsTitle' => esc_html__( 'Modula Albums', 'modula-albums')
            ) )
        );
    }

    public function render_modula_album( $atts ) {
        if ( ! isset( $atts['id'] ) ) {
            return;
        }

        return do_shortcode( '[modula-album id="' . $atts['id'] . '"]' );
    }

    public function get_album_meta() {

        $id    = $_POST['id'];
        $nonce = $_POST['nonce'];

        if ( ! wp_verify_nonce( $nonce, 'modula_nonce' ) ) {
            wp_send_json_error();
            die();
        }

        $galleries = get_post_meta( $id, 'modula-album-galleries', true );

        if ( ! is_array( $galleries ) ) {
            wp_send_json_error();
            die();
        }

        foreach ($galleries as $key=>$gallery) :
            $gallery_id = $galleries[$key]['id'];
            $gal_images = get_post_meta($gallery_id, 'modula-images', true);
            $i          = 0;

	        if ( 0 != $galleries[ $key ]['cover'] && ! empty( $galleries[ $key ]['cover'] ) ) {
                $image_obj              = wp_get_attachment_image_src($galleries[$key]['cover'], 'large');
                $images[$key]['src']    = $image_obj[0];
                $images[$key]['width']  = $image_obj[1];
                $images[$key]['height'] = $image_obj[2];
            } else {

                foreach ($gal_images as $image) {
                    if ($i < 1) {
                        $image_obj              = wp_get_attachment_image_src($image['id'], 'large');
                        $images[$key]['src']    = $image_obj[0];
                        $images[$key]['width']  = $image_obj[1];
                        $images[$key]['height'] = $image_obj[2];
                    }
                    $i++;
                }
            }

        endforeach;

        echo json_encode( $images );

        die();

    }

}

new Modula_Albums_Gutenberg();


