<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
class Modula_Albums {
	/**
	 * Holds the class object.
	 *
	 * @since 1.0.0
	 *
	 * @var object
	 */
	public static $instance;
	/**
	 * The name of the plugin.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $plugin_name = 'Modula Albums';
	/**
	 * Unique plugin slug identifier.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $plugin_slug = 'modula-albums';
	/**
	 * Primary class constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		// // Load the plugin textdomain.
		add_action( 'init', array( $this, 'set_locale' ) );

		add_action( 'init', array( $this, 'init' ) );

        require_once MODULA_ALBUMS_PATH . 'includes/libraries/class-modula-albums-template-loader.php';

		// Include assets
		require_once MODULA_ALBUMS_PATH . 'includes/helpers/class-modula-album-fields-helper.php';
		require_once MODULA_ALBUMS_PATH . 'includes/helpers/class-modula-album-hover-effects.php';
        require_once MODULA_ALBUMS_PATH . 'includes/helpers/modula-album-helper-functions.php';
		require_once MODULA_ALBUMS_PATH . 'includes/admin/class-modula-albums-cpt.php';
		require_once MODULA_ALBUMS_PATH . 'includes/duplicator/class-modula-albums-duplicator.php' ;
		require_once MODULA_ALBUMS_PATH . 'includes/elementor/class-modula-albums-elementor-check.php';
		require_once MODULA_ALBUMS_PATH . 'includes/modula-albums-beaver-block/class-modula-albums-beaver.php';

		// Shortcode
		require_once MODULA_ALBUMS_PATH . 'includes/public/class-modula-albums-public.php';

		add_filter( 'modula_page_header', array( $this, 'modula_header' ) );

        add_filter('modula_uninstall_post_types',array($this,'uninstall_post_type_process'),15,1);

		// Gutenberg
		require_once MODULA_ALBUMS_PATH . 'includes/class-modula-albums-gutenberg.php';

	}

	/**
	 * Loads the plugin textdomain for translation.
	 *
	 * @since 1.0.0
	 */
	public function set_locale() {
		load_plugin_textdomain( $this->plugin_slug, false, dirname( plugin_basename( MODULA_ALBUMS_FILE ) ) . '/languages/' );
	}

	/**
	 * Loads the plugin into WordPress.
	 *
	 * @since 1.0.0
	 */
	public function init() {
		// Load admin only components.
		if ( is_admin() ) {
			add_action( 'modula_pro_updater', array( $this, 'addon_updater' ), 15, 2 );
		}

		// Shortcode class
		new Modula_Albums_Shortcode();

	}

	public function addon_updater( $license_key, $store_url ) {
		if ( class_exists( 'Modula_Pro_Base_Updater' ) ) {
			$modula_addon_updater = new Modula_Pro_Base_Updater( $store_url, MODULA_ALBUMS_FILE,
				array(
					'version' => MODULA_ALBUMS_VERSION,        // current version number
					'license' => $license_key,               // license key (used get_option above to retrieve from DB)
					'item_id' => 408922,                      // ID of the product
					'author'  => 'MachoThemes',            // author of this plugin
					'beta'    => false,
				)
			);
		}
	}

	/**
	 * Returns the singleton instance of the class.
	 *
	 * @since 1.0.0
	 *
	 * @return object The Modula_Albums object.
	 */
	public static function get_instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Modula_Albums ) ) {
			self::$instance = new Modula_Albums();
		}
		return self::$instance;
	}


	/**
	 * Uninstall modula custom post types process
	 *
	 * @param $modula_post_types
	 *
	 * @return mixed
	 *
	 * @since 1.0.3
	 */
	public function uninstall_post_type_process($modula_post_types){

		$modula_post_types[] = 'modula-album';

		return $modula_post_types;

	}

	/**
	 * Modula header places
	 *
	 * @param $return
	 *
	 * @return bool|mixed
	 * @since 1.1.0
	 */
	public function modula_header( $return ) {

		$current_screen = get_current_screen();

		if ( 'modula-album' === $current_screen->post_type ) {
			return true;
		}

		return $return;
	}
}