<?php 

class Modula_Albums_Duplicator {

    public function __construct() {

        $this->define_admin_hooks();
    }

    private function define_admin_hooks() {
        add_filter( 'post_row_actions', array( $this, 'duplicate_album_link'), 10, 2);
    }

    public function duplicate_album_link( $actions, $post ) {

        if( 'modula-album' != get_post_type( $post ) ) {
            return $actions;
        }

		$actions['duplicate_modula'] = '<a href="' . modula_duplicate_gallery_get_clone_post_link( $post->ID, 'display', false ) . '" title="' . esc_attr__( "Duplicate this album", 'modula-albums' ) . '">' . esc_html__( 'Duplicate album', 'modula-albums' ) . '</a>';

		return $actions;
    }
}

new Modula_Albums_Duplicator();