<?php

namespace ElementorModulaAlbums\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Modula_Albums_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'modula_albums_elementor';
	}

	public function get_title() {
		return apply_filters( 'modula_albums_elementor_name', esc_html__( 'Modula Albums', 'modula-albums' ));
	}

	public function get_icon() {
		return 'eicon-elementor-square';
	}

	public function get_categories() {
		return array( 'general' );

	}

	protected function _register_controls() {
		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'modula-albums' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
            'modula_albums_select',
            array(
                'label'   => esc_html__( 'Select/Search Album', 'modula-albums' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => \modula_get_albums(), // will be loaded through ajax
                'default' => 'none',
            )
        );


		$this->end_controls_section();
	}

	protected function render() {
		$settings   = $this->get_settings_for_display();
		$album_id = $settings['modula_albums_select'];
		if ( 'none' != $album_id ) {
			echo do_shortcode( '[modula-album id="' . esc_attr( $album_id ) . '"]' );
		}

	}

}