<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
class Modula_Album_Fields_Helper {

    /**
     * @return mixed|void
     *
     * Modula Albums CPT tabs
     */
    public static function get_tabs() {

        $general_description        = '<p>' . esc_html__('Choose to build your own grid by selecting Custom Grid or selecting the number of columns you want to have.', 'modula-albums') . '</p>';
        $caption_description        = '<p>' . esc_html__('The settings below adjust how the image title/description will appear on the front-end.', 'modula-albums') . '</p>';
        $social_description         = '<p>' . esc_html__('Here you can add social sharing buttons to your the images in your gallery.', 'modula-albums') . '</p>';
        $loadingeffects_description = '<p>' . esc_html__('The settings below adjust the effect applied to the images after the page is fully loaded.', 'modula-albums') . '</p>';
        $hover_description          = '<p>' . esc_html__('Select how your images will behave on hover. Hover styles for your images.', 'modula-albums') . '</p>';
        $customizations_description = '<p>' . esc_html__('Use this section to add custom CSS to your gallery for advanced modifications.', 'modula-albums') . '</p>';
        $lightbox_description        = '<p>' . esc_html__('Here you can set up your lightbox settings.', 'modula-albums') . '</p>';
        $caption_description = '<p>' . esc_html__('The settings below adjust how the image title/description will appear on the front-end.', 'modula-albums') . '</p>';

        return apply_filters('modula_album_tabs', array(
            'general'    => array(
                'label'       => esc_html__('General', 'modula-albums'),
                'title'       => esc_html__('General Settings', 'modula-albums'),
                'description' => $general_description,
                "icon"        => "dashicons dashicons-admin-generic",
                'priority'    => 10,
            ),
            'lightbox'   => array(
                'label'       => esc_html__('Lightbox', 'modula-albums'),
                'title'       => esc_html__('Lightbox Settings', 'modula-albums'),
                'description' => $lightbox_description,
                "icon"        => "dashicons dashicons-filter",
                'priority'    => 15,
            ),
            'captions'   => array(
	            'label'       => esc_html__('Captions', 'modula-albums'),
	            'title'       => esc_html__('Caption Settings', 'modula-albums'),
	            'description' => $caption_description,
	            "icon"        => "dashicons dashicons-text",
	            'priority'    => 15,
            ),
            'hover-effect'      => array(
                'label'       => esc_html__('Hover effects', 'modula-albums'),
                'title'       => esc_html__('Hover Effect Settings', 'modula-albums'),
                'description' => $hover_description,
                "icon"        => "dashicons dashicons-layout",
                'priority'    => 70,
            ),
            'responsive' => array(
                'label'       => esc_html__('Responsive', 'modula-albums'),
                'title'       => esc_html__('Responsive Settings', 'modula-albums'),
                'description' => '',
                "icon"        => "dashicons dashicons-smartphone",
                'priority'    => 90,
            ),
            'speedup'    => array(
                'label'      => esc_html__('Speed Up', 'modula-albums'),
                'title'      => esc_html__('Optimize your album', 'modula-albums'),
                'dscription' => '',
                "icon"       => "dashicons dashicons-dashboard",
                'priority'   => 80,
            ),
        ));

    }

    /**
     * @param $tab
     * @return array|mixed|void
     *
     * Modula Albums CTP fields
     */
    public static function get_fields($tab) {

	    $fields = apply_filters('modula_album_fields', array(
		    'general'    => array( 
				'album_type'           => array(
					"name"        => esc_html__( 'Album Type', 'modula-albums' ),
					"type"        => "icon-radio", 
					"description" => esc_html__( 'Choose the type of album you want to use.', 'modula-albums' ),
					'default'     => 'grid',
					"values"      => array(
						'grid'             => esc_html__( 'Grid', 'modula-albums' )
					),
					"disabled" => array(
						'title'  => esc_html__( 'Gallery types with PRO license', 'modula-albums' ),
						'values' => array(
							"slider"     => esc_html__( 'Slider', 'modula-albums' ),
						),
					),
					'priority' => 10,
				),
			    'type'                => array(
				    "name"        => esc_html__('Grid Type', 'modula-albums'),
				    "type"        => "select",
				    "description" => esc_html__('Choose the type of grid you want to use.', 'modula-albums'),
				    'default'     => '3',
				    "values"      => array(
					    '1'           => esc_html__('One column (1)', 'modula-albums'),
					    '2'           => esc_html__('Two columns (2)', 'modula-albums'),
					    '3'           => esc_html__('Three columns (3)', 'modula-albums'),
					    '4'           => esc_html__('Four columns (4)', 'modula-albums'),
					    '5'           => esc_html__('Five columns (5)', 'modula-albums'),
					    '6'           => esc_html__('Six columns (6)', 'modula-albums'),
					    'custom-grid' => esc_html__('Custom Grid', 'modula-albums'),
				    ),
				    'priority'    => 10,
			    ),
			    "gutter"              => array(
				    "name"        => esc_html__('Gutter', 'modula-albums'),
				    "type"        => "ui-slider",
				    "description" => esc_html__('Use this slider to adjust the spacing of images in your album.', 'modula-albums'),
				    "min"         => 0,
				    "max"         => 100,
				    "step"        => 1,
				    "default"     => 10,
				    'priority'    => 30,
			    ),
			    "width"               => array(
				    "name"        => esc_html__('Width', 'modula-albums'),
				    "type"        => "text",
				    "description" => esc_html__('Width of the album. Can be in % or pixels.', 'modula-albums'),
				    'default'     => '100%',
				    'priority'    => 30,
			    ),
			    "image_size" => array(
				    "name"        => esc_html__('Image size', 'modula-albums'),
				    "type"        => "dimensions-select",
				    "description" => esc_html__('Define the maximum image size for the album\'s cover from a selection of options. Select custom if you want to define your sizes.', 'modula-albums'),
				    'values'      => self::get_image_sizes(),
				    'default'     => 'medium',
				    'priority'    => 50,
			    ),
			    'image_dimensions'    => array(
				    "name"        => esc_html__('Image Dimensions', 'modula-albums'),
				    "type"        => "image-size",
				    "default"     => 0,
				    "description" => esc_html__('You should adjust these dimensions based on the number of columns in your album.', 'modula-albums'),
				    'priority'    => 60,
				    'is_child' => true,
			    ),
			    'crop_images'         => array(
				    "name"        => esc_html__('Crop Images', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('If enabled, forces images to exactly match the sizes defined above for Image Dimensions. If disabled, images will be resized to maintain their aspect ratio.', 'modula-albums'),
				    'priority'    => 70,
				    'is_child' => true,
			    ),
			    'shuffle_galleries'         => array(
				    "name"        => esc_html__('Shuffle galleries', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('Toggle this to ON to have the album shuffle galleries on each page load.', 'modula-albums'),
				    'priority'    => 75,
			    ),

		    ),
		    'lightbox'   => array(
			    'enable_lightbox'     => array(
				    "name"        => esc_html__('Enable Lightbox', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 1,
				    "description" => esc_html__('If checked, displays the Gallery in a lightbox when the album cover image is clicked. Else, if you want to link to gallery, uncheck and also please Enable Standalone from Modula Settings.', 'modula-albums'),
				    'priority'    => 10,
					"children"    => array( 'show_image_title', 'show_image_caption', 'animation_effect', 'transition_effect', 'enable_slideshow', 'enable_thumbs', 'enable_download', 'enable_share', 'enable_zoom', 'enable_play', 'enable_navigation' )
			    ),
			    'show_image_title'    => array(
				    "name"        => esc_html__( 'Show Image Title', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('Enable this to show the image title in Lightbox', 'modula-albums'),
				    'priority'    => 14,
			    ),
			    'show_image_caption'  => array(
				    "name"        => esc_html__('Show Image Caption', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 1,
				    "description" => esc_html__('Enable this to show image caption in Lightbox', 'modula-albums'),
				    'priority'    => 15,
			    ),
			    'animation_effect'    => array(
				    "name"        => esc_html__('Animation type', 'modula-albums'),
				    "type"        => "select",
				    "description" => esc_html__('Open/close animation type', 'modula-albums'),
				    'default'     => 'fade',
				    "values"      => array(
					    '0'           => esc_html__('None', 'modula-albums'),
					    'fade'        => esc_html__('Fade', 'modula-albums'),
					    'slide'       => esc_html__('Slide', 'modula-albums'),
					    'rotate'      => esc_html__('Rotate', 'modula-albums'),
					    'circular'    => esc_html__('Circular', 'modula-albums'),
					    'tube'        => esc_html__('Tube', 'modula-albums'),
					    'zoom-in-out' => esc_html__('Zoom in Out', 'modula-albums'),
				    ),
				    'priority'    => 20,
			    ),
			    'animation_duration' => array(
				    "name"        => esc_html__( 'Animation Duration', 'modula-albums' ),
				    "type"        => "text",
				    "description" => esc_html__( 'Duration in ms for open/close animation', 'modula-albums' ),
				    'default'     => '366',
				    'is_child'    => true,
				    'priority'    => 30,
			    ),
			    'transition_effect'   => array(
				    "name"        => esc_html__('Transition effect', 'modula-albums'),
				    "type"        => "select",
				    "description" => esc_html__('Transition effect between slides', 'modula-albums'),
				    'default'     => 'fade',
				    "values"      => array(
					    '0'           => esc_html__('None', 'modula-albums'),
					    'fade'        => esc_html__('Fade', 'modula-albums'),
					    'slide'       => esc_html__('Slide', 'modula-albums'),
					    'rotate'      => esc_html__('Rotate', 'modula-albums'),
					    'circular'    => esc_html__('Circular', 'modula-albums'),
					    'tube'        => esc_html__('Tube', 'modula-albums'),
					    'zoom-in-out' => esc_html__('Zoom in Out', 'modula-albums'),
				    ),
				    'priority'    => 40,
			    ),
			    'transition_duration' => array(
				    "name"        => esc_html__('Transition Duration', 'modula-albums'),
				    "type"        => "text",
				    "description" => esc_html__('Duration in ms for transition animation', 'modula-albums'),
				    'default'     => '366',
				    'is_child'    => true,
				    'priority'    => 50,
			    ),
			    'enable_slideshow'    => array(
				    "name"        => esc_html__('Autoplay', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('If this is enabled the images will slide automatically one after the other in the lightbox', 'modula-albums'),
				    'priority'    => 60,
					'children'    => array( 'slideshow_duration' ),
			    ),
			    'slideshow_duration'  => array(
				    "name"        => esc_html__('Slideshow Duration', 'modula-albums'),
				    "type"        => "text",
				    "description" => esc_html__('Duration in ms for slideshow autoplay', 'modula-albums'),
				    'default'     => '3000',
				    'is_child' => true,
				    'priority'    => 70,
			    ),
			    'enable_thumbs'       => array(
				    "name"        => esc_html__('Thumbnails', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('If checked, the right side of the lightbox will display thumbnails with all the gallery\'s images', 'modula-albums'),
				    'priority'    => 80,
					'children'    => array( 'autostart_thumbs' ),
			    ),
			    'autostart_thumbs'    => array(
				    "name"        => esc_html__('Auto start thumbnails', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 1,
				    "description" => esc_html__('Display thumbnails on lightbox opening.', 'modula-albums'),
				    'priority'    => 85,
					'is_child' => true,
			    ),
			    'enable_download'       => array(
				    "name"        => esc_html__('Download Button', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('If checked, in lightbox we will have a download button', 'modula-albums'),
				    'priority'    => 100,
			    ),
			    'enable_share'       => array(
				    "name"        => esc_html__('Share Button', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('If checked, in lightbox we will have a share button', 'modula-albums'),
				    'priority'    => 110,
					"children"    => array( 'lightbox_facebook', 'lightbox_twitter', 'lightbox_whatsapp', 'lightbox_linkedin', 'lightbox_pinterest', 'lightbox_email' ),
					'parent'	  => "enable_lightbox",
			    ),
			    'lightbox_facebook' => array(
				    "name"        => esc_html__( 'Facebook', 'modula-albums' ),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__( 'Enables Facebook social sharing in FancyBox lightbox.', 'modula-albums' ),
				    "is_child"    => true,
				    'priority'    => 111,
			    ),
			    'lightbox_twitter' => array(
				    "name"        => esc_html__( 'Twitter', 'modula-albums' ),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__( 'Enables Twitter social sharing in FancyBox lightbox.', 'modula-albums' ),
				    "is_child"    => true,
				    'priority'    => 111,
			    ),
			    'lightbox_whatsapp' => array(
				    "name"        => esc_html__( 'WhastApp', 'modula-albums' ),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__( 'Enables WhatsApp social sharing in FancyBox lightbox.', 'modula-albums' ),
				    "is_child"    => true,
				    'priority'    => 111,
			    ),
			    'lightbox_linkedin' => array(
				    "name"        => esc_html__( 'LinkedIn', 'modula-albums' ),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__( 'Enables LinkedIn social sharing in FancyBox lightbox.', 'modula-albums' ),
				    "is_child"    => true,
				    'priority'    => 111,
			    ),
			    'lightbox_pinterest' => array(
				    "name"        => esc_html__( 'Pinterest', 'modula-albums' ),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__( 'Enables Pinterest social sharing in FancyBox lightbox.', 'modula-albums' ),
				    "is_child"    => true,
				    'priority'    => 111,
				),
			    'lightbox_email' => array(
				    "name"        => esc_html__( 'Email', 'modula-albums' ),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__( 'Enables Email sharing in FancyBox lightbox.', 'modula-albums' ),
				    "is_child"    => true,
				    'priority'    => 112,
					"children"    => array( 'lightboxEmailSubject', 'lightboxEmailMessage' ),
					'parent'	  => "enable_share",
				),
				"lightboxEmailSubject"   => array(
					"name"        => esc_html__( 'Email subject', 'modula-albums' ),
					"type"        => "text",
					"default"     => esc_html__( 'Check out this awesome image !!','modula-albums' ),
					"description" => esc_html__( 'Email subject text, used in hover social sharing or Lightbox social sharing( PRO only )', 'modula-albums' ),
					'is_child'    => 'two',
					'priority'    => 113,
				),
				"lightboxEmailMessage"   => array(
					"name"        => esc_html__( 'Email message', 'modula-albums' ),
					"type"        => "textarea-placeholder",
					"values"      => array(
						'%%image_link%%'      => esc_html__( 'Image Link', 'modula-albums' ),
						'%%gallery_link%%'    => esc_html__( 'Album Link', 'modula-album' ),
					),
					"default"     => esc_html__( 'Here is the link to the image : %%image_link%% and this is the link to the gallery : %%gallery_link%% ','modula-albums'),
					"description" => esc_html__( 'Text that is placed before the link of the image you want to share,used in hover social sharing or Lightbox social sharing( PRO only )', 'modula-albums' ),
					'is_child'    => 'two',
					'priority'    => 114,
				),
			    'enable_zoom'       => array(
				    "name"        => esc_html__('Zoom Button', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('If checked, in lightbox we will have zoom button', 'modula-albums'),
				    'priority'    => 115,
			    ),
			    'enable_play'       => array(
				    "name"        => esc_html__('Play Button', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('If checked, in lightbox we will have slideshow button', 'modula-albums'),
				    'priority'    => 120,
			    ),
			    'enable_navigation'       => array(
				    "name"        => esc_html__('Navigation arrows', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 1,
				    "description" => esc_html__('If checked, in lightbox we will have navigation arrows', 'modula-albums'),
				    'priority'    => 125,
			    ),
			    'lightbox_info' => array(
				    'name' => esc_html__('Each gallery from an album will open a URL, and there are 2 options for that:', 'modula-albums'),
				    "type" => "album-lightbox-info",
			    )
		    ),
		    'captions' => array(
			    "hide_title"    => array(
				    "name"        => esc_html__( 'Hide Title', 'modula-albums' ),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__( 'Hide image titles from your gallery.', 'modula-albums' ),
				    'priority'    => 20,
					'children'	  => array("titleColor", "titleFontSize", "mobileTitleFontSize"),
			    ),
			    "titleColor"    => array(
				    "name"        => esc_html__( 'Title Color', 'modula-albums' ),
				    "type"        => "color",
				    "description" => esc_html__( 'Set the color of title.', 'modula-albums' ),
				    "default"     => "",
				    "is_child"    => true,
				    'priority'    => 20,
			    ),
			    "titleFontSize" => array(
				    "name"        => esc_html__( 'Title Font Size', 'modula-albums' ),
				    "type"        => "ui-slider",
				    "min"         => 0,
				    "max"         => 100,
				    "default"     => 0,
				    "is_child"    => true,
				    "description" => esc_html__( 'The title font size in pixels (set to 0 to use the theme defaults).', 'modula-albums' ),
				    'priority'    => 20,
			    ),
			    "mobileTitleFontSize"   => array(
				    "name"        => esc_html__('Mobile Title Font Size', 'modula-albums'),
				    "type"        => "ui-slider",
				    "min"         => 0,
				    "max"         => 100,
				    "default"     => 10,
				    "description" => esc_html__('The title font size in pixels (set to 0 to use the theme defaults).', 'modula-albums'),
				    "is_child"    => true,
				    'priority'    => 20,
			    ),
			    "hide_description" => array(
				    "name"        => esc_html__('Hide Caption', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('Hide image captions from your gallery.', 'modula-albums'),
				    'priority'    => 30,
					'children'	  => array("captionColor", "captionFontSize", "mobileCaptionFontSize"),
			    ),
			    "captionColor"     => array(
				    "name"        => esc_html__('Caption Color', 'modula-albums'),
				    "type"        => "color",
				    "description" => esc_html__('Set the color of captions.', 'modula-albums'),
				    "default"     => "#ffffff",
				    "is_child"    => true,
				    'priority'    => 30,
			    ),
			    "captionFontSize"  => array(
				    "name"        => esc_html__('Caption Font Size', 'modula-albums'),
				    "type"        => "ui-slider",
				    "min"         => 0,
				    "max"         => 100,
				    "default"     => 14,
				    "is_child"    => true,
				    "description" => esc_html__('The caption font size in pixels (set to 0 to use theme defaults).', 'modula-albums'),
				    'priority'    => 30,
			    ),
			    "mobileCaptionFontSize" => array(
				    "name"        => esc_html__('Mobile Caption Font Size', 'modula-albums'),
				    "type"        => "ui-slider",
				    "min"         => 0,
				    "max"         => 100,
				    "default"     => 12,
				    "description" => esc_html__('The caption font size in pixels (set to 0 to use theme defaults).', 'modula-albums'),
				    "is_child"    => true,
				    'priority'    => 30,
			    ),
		    ),
		    'hover-effect'      => array(
			    "cursor"       => array(
				    "name"         => esc_html__( 'Cursor Icon', 'modula-albums'),
				    "description"  => esc_html__( 'Select your favourite cursor', 'modula-albums'),
				    "type"         => "select",
				    "default"	   => "zoom-in",
				    "priority"     => 8,
				    'values'       => array(
					    'pointer'     => esc_html__( 'Pointer', 'modula-albums' ),
					    'zoom-in'     => esc_html__( 'Magnifying Glass', 'modula-albums' ),
					    'wait'        => esc_html__( 'Loading', 'modula-albums' ),
					    'cell'        => esc_html__( 'Cell', 'modula-albums' ),
					    'crosshair'   => esc_html__( 'Crosshair', 'modula-albums' ),
					    'nesw-resize' => esc_html__( 'Resize 1', 'modula-albums' ),
					    'nwse-resize' => esc_html__( 'Resize 2', 'modula-albums' ),
					    'custom'      => esc_html__( 'Custom', 'modula-albums' ),
				    ),
			    ),
			    "uploadCursor" => array(
				    "name"        => esc_html__( 'Upload your cursor', 'modula-albums' ),
				    "type"        => "cursor_upload",
				    "default"     => 0,
				    "description" => esc_html__( 'The cursor size has to be 32px x 32px or smaller , otherwise the cursor will not work .','modula-albums' ),
				    'class'       => 'button insert-media-url',
				    'button_text' => esc_html__( 'Upload Cursor', 'modula-albums' ),
				    "is_child"    => true,
				    "priority"    => 9,
			    ),
			    'display_image_count' => array(
				    "name"        => esc_html__('Display Image Count', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    "description" => esc_html__('Displays the number of images for each gallery next to each gallery image title.', 'modula-albums'),
				    'priority'    => 40,
			    ),
			    "imageCountColor"    => array(
				    "name"        => esc_html__( 'Image Count Color', 'modula-albums' ),
				    "type"        => "color",
				    "description" => esc_html__( 'Set the color of image count numbers.', 'modula-albums' ),
				    "default"     => "#ffffff",
				    'is_child'    => true,
				    'priority'    => 50,
			    ),
			    "imageCountFontSize" => array(
				    "name"        => esc_html__( 'Image Count Font Size', 'modula-albums' ),
				    "type"        => "ui-slider",
				    "min"         => 0,
				    "max"         => 100,
				    "default"     => 14,
				    "description" => esc_html__( 'The image count font size in pixels (set to 0 to use theme defaults).', 'modula-albums' ),
				    'is_child'    => true,
				    'priority'    => 70,
			    ),
			    'hoverColor' => array(
				    "name"        => esc_html__( 'Hover Color', 'modula-albums' ),
				    "type"        => "color",
				    "description" => '',
				    "default"     => "#ffffff",
				    'priority'    => 80,
			    ),
			    'backgroundColor' => array(
				    "name"        => esc_html__( 'Background Color', 'modula-albums' ),
				    "type"        => "color",
				    "description" => '',
				    "default"     => "#ffffff",
				    'priority'    => 90,
			    ),
			    'hoverOpacity' => array(
				    "name"        => esc_html__( 'Hover Opacity', 'modula-albums' ),
				    "description" => esc_html__( 'Adjust the transparency of your chosen hover effect. This setting affects the opacity of the image and not the overlay element.', 'modula-albums' ),
				    "type"        => "ui-slider",
				    "min"         => 0,
				    "max"         => 100,
				    "default"     => 50,
				    'priority'    => 100,
			    ),
			    'hoverPadding' => array(
				    "name"        => esc_html__( 'Hover Padding', 'modula-albums' ),
				    "description" => esc_html__( 'Adjust the padding of your chosen hover effect.', 'modula-albums' ),
				    "type"        => "ui-slider",
				    "min"         => 0,
				    "max"         => 100,
				    "default"     => 50,
				    'priority'    => 100,
			    ),
			    "effect"   => array(
				    "name"        => esc_html__( 'Hover effect', 'modula-albums' ),
				    "description" => esc_html__( 'Select your preferred hover effect', 'modula-albums' ),
				    "type"        => "hover-effect",
				    'default'     => 'pufrobo',
				    'priority'    => 110,
			    ),
		    ),
		    'speedup'    => array(
			    'lazy_load' => array(
				    "name"        => esc_html__('Lazy Load', 'modula-albums'),
				    "description" => esc_html__('Enable/Disable lazy load', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    'priority'    => 1,
			    ),
		    ),
		    'responsive' => array(
			    'enable_responsive'     => array(
				    "name"        => esc_html__('Custom responsiveness', 'modula-albums'),
				    "description" => esc_html__('Force the album to show a certain number of column on tablet/mobile devices', 'modula-albums'),
				    "type"        => "toggle",
				    "default"     => 0,
				    'priority'    => 10,
					"children"    => array( 'tablet_columns', 'mobile_columns' ),
			    ),
			    'tablet_columns'        => array(
				    "name"        => esc_html__('Tablet Columns', 'modula-albums'),
				    "type"        => "ui-slider",
				    "description" => esc_html__('Use this slider to adjust the number of columns for album on tablets.', 'modula-albums'),
				    "min"         => 1,
				    "max"         => 6,
				    "step"        => 1,
				    "default"     => 2,
				    "is_child"    => true,
				    'priority'    => 20,
			    ),
			    'mobile_columns'        => array(
				    "name"        => esc_html__('Mobile Columns', 'modula-albums'),
				    "type"        => "ui-slider",
				    "description" => esc_html__('Use this slider to adjust the number of columns for album on mobile devices.', 'modula-albums'),
				    "min"         => 1,
				    "max"         => 6,
				    "step"        => 1,
				    "default"     => 1,
				    "is_child"    => true,
				    'priority'    => 30,
			    ),
		    ),
	    ));

        if ('all' == $tab) {
            return $fields;
        }

        if (isset($fields[$tab])) {
            return $fields[$tab];
        } else {
            return array();
        }

    }

    /**
     * @return mixed|void
     *
     * Get the defaults of the Albums
     */
    public static function get_defaults() {
        return apply_filters('modula_album_default_settings', array(

	        // General
	        'album_type'            => 'grid',
	        'type'                  => '3',
	        "gutter"                => 10,
	        "width"                 => '100%',
	        'display_image_count'   => 0,
	        'image_dimensions'      => array(
		        'width'  => '',
		        'height' => ''
	        ),
	        'crop_images'           => 0,
	        'shuffle_galleries'     => 0,
	        'image_size'            => 'medium',

	        // Lightbox
	        'enable_lightbox'       => 1,
	        'show_image_title'      => 0,
	        'show_image_caption'    => 1,
	        'animation_effect'      => 'fade',
	        'animation_duration'    => '366',
	        'transition_effect'     => 'fade',
	        'transition_duration'   => '366',
	        'enable_slideshow'      => 0,
	        'slideshow_duration'    => '3000',
	        'enable_thumbs'         => 0,
	        'autostart_thumbs'      => 1,
	        'thumbs_axis'           => '2',
	        'enable_download'       => 0,
	        'enable_share'          => 0,
	        'lightbox_facebook'     => 0,
	        'lightbox_twitter'      => 0,
	        'lightbox_whatsapp'     => 0,
	        'lightbox_linkedin'     => 0,
			'lightbox_pinterest'    => 0,
			'lightbox_email'        => 0,
			'lightboxEmailSubject'  => esc_html__('Check out this awesome album !!','modula-albums'),
			'lightboxEmailMessage'  => esc_html__('Here is the link to the image : %%image_link%% and this is the link to the gallery : %%gallery_link%%','modula-albums'),
	        'enable_navigation'     => 1,

			// Style
			'cursor'                => 'pointer',
			'uploadCursor'          => 0,
	        'effect'                => 'pufrobo',
	        'titleColor'            => '#ffffff',
	        'captionColor'          => '#ffffff',
	        'hoverColor'            => '#000000',
	        'backgroundColor'       => '#000000',
	        'imageCountColor'       => '#ffffff',
	        'imageCountFontSize'    => 14,
	        'hide_title'            => 0,
	        'hide_description'      => 0,
	        'titleFontSize'         => 0,
	        'captionFontSize'       => 14,
	        'hoverOpacity'          => 50,
	        'hoverPadding'          => 0,

	        // Speed Up
	        'lazy_load'             => 0,

	        // Responsive
	        'enable_responsive'     => 0,
	        'tablet_columns'        => 2,
	        'mobile_columns'        => 1,
	        'mobileTitleFontSize'   => 10,
	        'mobileCaptionFontSize' => 12
        ));
    }

    public static function get_image_sizes() {

        global $_wp_additional_image_sizes;

        $sizes                        = array();
        $get_intermediate_image_sizes = self::get_image_sizes_arr();

        // Create the full array with sizes
        // print_r( $get_intermediate_image_sizes );
        foreach ( $get_intermediate_image_sizes as $_size => $args ) {

            $image_size_txt = ucfirst(strtolower(str_replace('_', ' ', $_size)));
            $image_size_txt = str_replace('-', ' ', $image_size_txt);
            if ( ! in_array( $_size, $sizes ) ) {
                $sizes[ $_size ] = array(
                    'dimensions' => array(
                        'width'  => $args['width'],
                        'height' => $args['height']
                    ),
                    'label' => $image_size_txt,
                    'crop'  => $args['crop']
                );
            }

        }

        foreach ( $_wp_additional_image_sizes as $_size => $args ) {
            $image_size_txt  = ucfirst(strtolower(str_replace('_', ' ', $_size)));
            $image_size_txt = str_replace('-', ' ', $image_size_txt);
            if ( ! in_array( $_size, $sizes ) ) {
                $sizes[ $_size ] = array(
                    'dimensions' => array(
                        'width'  => $args['width'],
                        'height' => $args['height']
                    ),
                    'label' => $image_size_txt,
                    'crop'  => $args['crop']
                );
            }
        }

        return $sizes;

    }

    /**
     * Get information about available image sizes
     */
    public static function get_image_sizes_arr( $size = '' ) {
     
        global $_wp_additional_image_sizes;
     
        $sizes = array();
        $get_intermediate_image_sizes = get_intermediate_image_sizes();
     
        // Create the full array with sizes and crop info
        foreach( $get_intermediate_image_sizes as $_size ) {
            if ( in_array( $_size, array( 'thumbnail', 'medium', 'large' ) ) ) {
                $sizes[ $_size ]['width'] = get_option( $_size . '_size_w' );
                $sizes[ $_size ]['height'] = get_option( $_size . '_size_h' );
                $sizes[ $_size ]['crop'] = (bool) get_option( $_size . '_crop' );
            } elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
                $sizes[ $_size ] = array( 
                    'width' => $_wp_additional_image_sizes[ $_size ]['width'],
                    'height' => $_wp_additional_image_sizes[ $_size ]['height'],
                    'crop' =>  $_wp_additional_image_sizes[ $_size ]['crop']
                );
            }
        }
     
        // Get only 1 size if found
        if ( $size ) {
            if( isset( $sizes[ $size ] ) ) {
                return $sizes[ $size ];
            } else {
                return false;
            }
        }
        return $sizes;
    }

}