<?php

/**
 * 
 */
class Modula_Albums_Hover_Effects {
	
	public static function get_hover_effects(){
		return apply_filters( 'modula_albums_hover_effects', array(
			'none'      => esc_html__( '1. None', 'modula-albums' ),
			'under'     => esc_html__( '2. Under Image', 'modula-albums' ),
			'pufrobo'   => esc_html__( '3. Pufrobo', 'modula-albums' ),
			'fluid-up'  => esc_html__( '4. Fluid Up', 'modula-albums' ),
			'hide'      => esc_html__( '5. Hide', 'modula-albums' ),
			'quiet'     => esc_html__( '6. Quiet', 'modula-albums' ),
			'reflex'    => esc_html__( '7. Reflex', 'modula-albums' ),
			'lens'      => esc_html__( '8. Lens', 'modula-albums' ),
			'appear'    => esc_html__( '9. Appear', 'modula-albums' ),
			'crafty'    => esc_html__( '10. Crafty', 'modula-albums' ),
			'seemo'     => esc_html__( '11. Seemo', 'modula-albums' ),
			'comodo'    => esc_html__( '12. Comodo', 'modula-albums' ),
			'lily'      => esc_html__( '13. Lily', 'modula-albums' ),
			'sadie'     => esc_html__( '14. Sadie', 'modula-albums' ),
			'honey'     => esc_html__( '15. Honey', 'modula-albums' ),
			'layla'     => esc_html__( '16. Layla', 'modula-albums' ),
			'zoe'       => esc_html__( '17. Zoe', 'modula-albums' ),
			'oscar'     => esc_html__( '18. Oscar', 'modula-albums' ),
			'marley'    => esc_html__( '19. Marley', 'modula-albums' ),
			'ruby'      => esc_html__( '20. Ruby', 'modula-albums' ),
			'roxy'      => esc_html__( '21. Roxy', 'modula-albums' ),
			'bubba'     => esc_html__( '22. Bubba', 'modula-albums' ),
			'dexter'    => esc_html__( '23. Dexter', 'modula-albums' ),
			'sarah'     => esc_html__( '24. Sarah', 'modula-albums' ),
			'chico'     => esc_html__( '25. Chico', 'modula-albums' ),
			'milo'      => esc_html__( '26. Milo', 'modula-albums' ),
			'julia'     => esc_html__( '27. Julia', 'modula-albums' ),
			'selena'    => esc_html__( '28. Selena', 'modula-albums' ),
			'phoebe'    => esc_html__( '29. Phoebe', 'modula-albums' ),
			'apollo'    => esc_html__( '30. Apollo', 'modula-albums' ),
			'steve'     => esc_html__( '31. Steve', 'modula-albums' ),
			'jazz'      => esc_html__( '32. Jazz', 'modula-albums' ),
			'ming'      => esc_html__( '33. Ming', 'modula-albums' ),
			'lexi'      => esc_html__( '34. Lexi', 'modula-albums' ),
			'duke'      => esc_html__( '35. Duke', 'modula-albums' ),
			'tilt_1'    => esc_html__( '36. Tilt Effect 1', 'modula-albums' ),
			'tilt_3'    => esc_html__( '37. Tilt Effect 2', 'modula-albums' ),
			'tilt_7'    => esc_html__( '38. Tilt Effect 3', 'modula-albums' ),
		) );
	}

	public static function get_hover_effects_keys(){

		$hover_effects = self::get_hover_effects();
		return array_keys( $hover_effects );

	}

	public static function hover_effects_elements( $effect ) {

		$effects_with_title       = apply_filters( 'modula_effects_with_title', array( 'under', 'fluid-up', 'hide', 'quiet', 'reflex', 'curtain', 'lens', 'appear', 'crafty', 'seemo', 'comodo', 'pufrobo','lily','sadie','honey','layla','zoe','oscar','marley','ruby','roxy','bubba','dexter','sarah','chico','milo','julia','hera','winston','selena','terry','phoebe','apollo','steve','jazz','ming','lexi','duke','tilt_1' ,'tilt_3' ,'tilt_7' ) );
		$effects_with_description = apply_filters( 'modula_effects_with_description', array( 'under', 'fluid-up', 'hide', 'reflex', 'lens', 'crafty', 'pufrobo','lily','sadie','layla','zoe','oscar','marley','ruby','roxy','bubba','dexter','sarah','chico','milo','julia','selena','apollo','steve','jazz','ming','lexi','duke','tilt_1' ,'tilt_3' ,'tilt_7' ) );
		$effects_with_extra_scripts = apply_filters( 'modula_effects_with_scripts', array( 'tilt_1' ,'tilt_3' ,'tilt_7' ) );
		return array(
			'title'       => in_array( $effect, $effects_with_title ),
			'description' => in_array( $effect, $effects_with_description ),
			'scripts'     => in_array( $effect, $effects_with_extra_scripts )
		);
	}

	public static function get_hover_effect_html( $key ){

	
		$class = array( 'modula-item' );
		$class[] = 'effect-' . $key;

		$effect_elements = Modula_Helper::hover_effects_elements( $key );
		$effect          = '';
		$effect          .= '<div class="clearfix panel-pro-preview modula-hover-effect-item modula-items">';


			$effect .= '<input type="radio" name="modula-settings[effect]" value="' . esc_attr( $key ) . '" ' . checked( $key, $value, false ) . '>';
		

		$effect .= '<div class="modula-preview-item-container">';
		$effect .= '<div class="' . esc_attr( implode( ' ', $class ) ) . '">';

		if ( 'under' == $key ) {
			$effect .= '<div class="modula-item-image-continer"><img src="' . esc_url( MODULA_URL . '/assets/images/effect.jpg' ) . '" class="pic"></div>';
		} else {
			$effect .= '<img src="' . esc_url( MODULA_URL . '/assets/images/effect.jpg' ) . '" class="pic">';
		}

		if ( in_array( $key, $effect_array ) ) {
			$effect .= '<div class="tilter__deco tilter__deco--shine"><div></div></div>';
			if ( in_array( $key, $overlay_array ) ) {
				$effect .= '<div class="tilter__deco tilter__deco--overlay"></div>';
			}
			if ( in_array( $key, $svg_array ) ) {
				$effect .= '<div class="tilter__deco tilter__deco--lines"></div>';
			}

		}

		if ( 'none' != $key ) {

			$effect .= '<div class="figc"><div class="figc-inner">';

			if ( $effect_elements[ 'title' ] ) {
				$effect .= '<div class="jtg-title">Lorem ipsum</div>';
			}

			if ( in_array( $key, $jtg_body ) ) {
				$effect .= '<div class="jtg-body">';
			}

			if ( $effect_elements[ 'description' ] ) {
				$effect .= '<p class="description">Quisque diam erat, mollisvitae enim eget</p>';
			} else {
				$effect .= '<p class="description"></p>';
			}

			if ( $effect_elements[ 'social' ] ) {
				$effect .= '<div class="jtg-social">';
				$effect .= '<a href="#">' . Modula_Helper::get_icon( 'twitter' ) . '</a>';
				$effect .= '<a href="#">' . Modula_Helper::get_icon( 'facebook' ) . '</a>';
				$effect .= '<a href="#">' . Modula_Helper::get_icon( 'pinterest' ) . '</a>';
				$effect .= '<a href="#">' . Modula_Helper::get_icon( 'linkedin' ) . '</a>';
				$effect .= '</div>';
			}

			if ( in_array( $key, $jtg_body ) ) {
				$effect .= '</div>';
			}

			$effect .= '</div></div>';
		}

		$effect .= '</div>';
		$effect .= '<div class="modula-preview-item-content">';
		$effect .= '<h4>' . $name . '</h4>';
		if ( $effect_elements[ 'title' ] || $effect_elements[ 'description' ] || $effect_elements[ 'social' ] || $effect_elements[ 'scripts' ] ) {
			
			$effect .= '<div class="effect-compatibility">';
			$effect .= '<p class="description">' . esc_html__( 'This effect is compatible with:', 'modula-pro' );

			if ( $effect_elements[ 'title' ] ) {
				$effect .= '<span><strong> ' . esc_html__( 'Title', 'modula-pro' ) . '</strong></span>,';
			}

			if ( $effect_elements[ 'description' ] ) {
				$effect .= '<span><strong> ' . esc_html__( 'Description', 'modula-pro' ) . '</strong></span>,';
			}

			if ( $effect_elements[ 'social' ] ) {
				$effect .= '<span><strong> ' . esc_html__( 'Social Icons', 'modula-pro' ) . '</strong></span>';
			}
			$effect .= '</p>';

			if ( $effect_elements[ 'scripts' ] ) {
				$effect .= '<p class="description">' . esc_html__( 'This effect will add an extra js script to your gallery', 'modula-pro' ) . '</p>';
			} else {
				$effect .= '<p class="description">&nbsp;</p>';
			}

			$effect .= '</div>';

		}
		
		$effect .= '</div>';
		$effect .= '</div>';
		$effect .= '</div>';

		$html .= $effect;
		return $html;

	}

	// None Hover Effect
	public static function get_none_hover_effect_html(){
		return '<div class="panel panel-none modula-items clearfix"></div>';
	}

	// Pufbro Hover Effect
	public static function get_pufbro_hover_effect_html(){
		$effect = '<div class="panel panel-pufrobo modula-items clearfix">';
		$effect .= '<div class="modula-item effect-pufrobo"><img src="' . MODULA_URL . '/assets/images/effect.jpg" class="pic"><div class="figc"><div class="figc-inner"><h2 class="jtg-title">Lorem ipsum<span class="image_count">( 4 Images )</span></h2><p class="description">Quisque diam erat, mollisvitae enim eget</p></div></div></div>';
		$effect .= '<div class="effect-compatibility">';
		$effect .= '<p class="description">' . esc_html__( 'This effect is compatible with:', 'modula-albums' );
		$effect .= '<span><strong> ' . esc_html__( 'Title', 'modula-albums' ) . '</strong></span>,';
		$effect .= '</div>';
		$effect .= '</div>';
		return $effect;
	}

	// None Hover Effect
	public static function get_under_hover_effect_html(){
		return '<div class="panel panel-none modula-items clearfix"></div>';
	}

}