<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * @param $gallery_settings
 * @param $album_settings
 * @param $gallery
 * @return mixed
 *
 * Manipulate the gallery settings
 */
function gallery_album_settings_manipulation($gallery_settings, $album_settings, $gallery) {

	$gallery_settings['gallery_id'] = $gallery['id'];
	// $gallery_settings['effect']     = $album_settings['effect'];
	// $gallery_settings['lazy_load']  = $album_settings['lazy_load'];
	//@todo: commented in version 1.0.8. Above lines commented before. Delete lines if versions > 1.0.9
	// $gallery_settings['img_size']   = $album_settings['image_dimensions']['width'];

	return $gallery_settings;
}

/**
 * @param $item_data
 * @param $item
 * @param $settings
 * @param $album_settings
 * @return mixed
 *
 * Generate image
 */
function modula_album_generate_image_links($item_data, $item, $settings, $album_settings) {

    // If the image is not resized we will try to resize it now
    // This is safe to call every time, as resize_image() will check if the image already exists, preventing thumbnails from being generated every single time.
    $resizer = new Modula_Image();

	$gallery_type = (isset( $album_settings['type'] ) && 'custom' == $album_settings['type']) ? 'custom-grid' : 'grid';

	if ( 'custom' == $album_settings['image_size'] ){
		$grid_sizes = array(
			'width'  => $album_settings['image_dimensions']['width'],
			'height' => $album_settings['image_dimensions']['height']
		);
	} else {
		$grid_sizes = $album_settings['image_size'];
	}

	$crop = false;

	if ( 'custom' == $album_settings['image_size'] ){
		$crop = boolval(  $album_settings['crop_images'] );
	}

	$sizes   = $resizer->get_image_size( $item['id'], $gallery_type, $grid_sizes, $crop );
	$resized = $resizer->resize_image( $sizes['url'], $sizes['width'], $sizes['height'], $crop );

	$image_info = false;
	// If we couldn't resize the image we will return the full image.
	if ( is_wp_error( $resized ) ){
		$resized = $sizes['url'];
	}
	// Let's check if resize gives us both URL and image info
	// Also, if resized_url is available, image_info should be available
	if ( isset( $resized['resized_url'] ) ){
		$image_url  = $resized['resized_url'];
		$image_info = $resized['image_info'];
	} else {
		$image_url = $resized;
	}

	$item_data['img_attributes']['width']  = $sizes['width'];
	$item_data['img_attributes']['height'] = $sizes['height'];
	$item_data['image_full']               = $sizes['url'];
	$item_data['image_url']                = ( isset( $sizes['thumb_url'] ) ) ? $sizes['thumb_url'] : $image_url;
	// If thumb_url exists it means we are in predefined sizes
	$item_data['img_attributes']['src']           = ( isset( $sizes['thumb_url'] ) ) ? $sizes['thumb_url'] : $image_url;
	$item_data['img_attributes']['data-src']      = ( isset( $sizes['thumb_url'] ) ) ? $sizes['thumb_url'] : $image_url;
	$item_data['img_attributes']['data-image-id'] = $item['id'];
	$item_data['image_info']                      = $image_info;

    return $item_data;
}


function modula_album_check_lightboxes_and_links( $item_data, $item, $gallery_settings,$settings ) {

	// Create link attributes like : title/rel
	$caption = isset( $item['description'] ) ? $item['description'] : '';

	$item_data['link_attributes']['title']      = strip_tags( $caption );
	$item_data['link_attributes']['data-title'] = $caption;


	$item_data['link_attributes']['rel'] = $gallery_settings['gallery_id'];

	if (!isset($settings['enable_lightbox']) || 1 != $settings['enable_lightbox']) {
		$item_data['link_attributes']['class'][] = 'simple-link';
	}

	return $item_data;
}

function modula_album_check_hover_effect( $item_data, $item, $gallery_settings, $settings ){

    $hover_effect_elements = Modula_Helper::hover_effects_elements( $settings['effect'] );

    if ( ! $hover_effect_elements['title'] ) {
        $item_data['hide_title'] = true;
    }

    if ( ! $hover_effect_elements['description'] ) {
        $item_data['hide_description'] = true;
    }

    if ( ! $hover_effect_elements['social'] ) {
        $item_data['hide_socials'] = true;
    }

    if ( 'none' != $settings['effect'] ) {
        $item_data['item_attributes']['class'][] = 'effect-' . $settings['effect'];
    }

    if('under' == $settings['effect']){
    	$item_data['item_attributes']['class'][] = 'modula-caption-effect-item';
    }

    return $item_data;
}

function modula_album_check_custom_grid( $item_data) {

    if ( isset($item_data['album_type']) && 'custom-grid' == $item_data['album_type'] ) {
        return $item_data;
    }

    $item_data['item_attributes']['data-width'] = 2;
    $item_data['item_attributes']['data-height'] = 2;

    return $item_data;

}

function modula_album_enable_lazy_load( $item_data, $item, $gallery_settings, $settings ){

    if ( '1' != $settings['lazy_load'] ) {
        return $item_data;
    }

    if ( isset( $item_data['img_attributes']['class'] ) && is_array( $item_data['img_attributes']['class'] ) ) {
        $item_data['img_attributes']['class'][] = 'lazyload';
    }

    if ( isset( $item_data['img_attributes']['src'] ) ) {
        unset( $item_data['img_attributes']['src'] );
    }

    $item_data['img_attributes']['data-source'] = 'modula-album';

    return $item_data;
}

function modula_get_albums() {

    $albums      = get_posts( array( 'post_type' => 'modula-album', 'posts_per_page' => -1 ) );
    $album_array = array( 'none' => esc_html__( 'None', 'modula-albums' ) );
    foreach ( $albums as $album ) {
        $album_array[$album->ID] = esc_html( $album->post_title );
    }

    return $album_array;
}
