<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

class Modula_Albums_Beaver_Block extends FLBuilderModule {

    public function __construct() {
        parent::__construct ( apply_filters( 'modula_albums_beaver_construct', array(
            'name'            => esc_html__( 'Modula Albums', 'modula-albums' ),
            'description'     => esc_html__( 'A block for Modula Albums', 'modula-albums' ),
            'category'        => esc_html__( 'Modula', 'modula-albums' ),
            'icon'            => 'format-image.svg',
            'dir'             => MODULA_ALBUMS_PATH . 'includes/modula-albums-beaver-block/',
            'url'             => MODULA_ALBUMS_URL . 'includes/modula-albums-beaver-block/',
            'partial_refresh' => true,
        )));
    }
}

FLBuilder::register_module('Modula_Albums_Beaver_Block', apply_filters( 'modula_albums_beaver_module', array(
    'modula_album' => array(
        'title'    => esc_html__( 'Modula Albums', 'modula-albums' ),
        'sections' => array(
            'modula_album_section' => array(
                'title'  => esc_html__( 'Select the Modula Album you want', 'modula-albums' ),
                'fields' => array(
                    'modula_album_select' => array(
                        'type'    => 'select',
                        'label'   => esc_html__( 'Select Modula Album', 'modula-albums' ),
                        'default' => 'none',
                        'options' => modula_get_albums(),
                    )
                )
            )
        )
    )
)));

