<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

class Modula_Albums_Shortcode {

    private $loader;

    /**
     * Modula_Albums_Shortcode constructor.
     */
    function __construct() {

        $this->loader = new Modula_Albums_Template_Loader();

        add_shortcode('modula-album', array($this, 'album_shortcode_handler'));
        add_action('wp_enqueue_scripts', array($this, 'add_gallery_scripts'));

        // Add shortcode related hooks
        add_filter('modula_album_shortcode_item_data', 'modula_album_generate_image_links', 10, 4);
        add_filter('modula_album_shortcode_item_data', 'modula_album_check_lightboxes_and_links', 15, 4);
        add_filter('modula_album_shortcode_item_data', 'modula_album_check_hover_effect', 20, 4);
        add_filter('modula_album_shortcode_item_data', 'modula_album_check_custom_grid', 25, 1);
        add_filter('modula_album_shortcode_item_data', 'modula_album_enable_lazy_load', 30, 4);
        // Manipulate the gallery settings
        add_filter('modula_album_shortcode_gallery_setting', 'gallery_album_settings_manipulation', 15, 3);

    }

    /**
     * Add required scripts
     */
    public function add_gallery_scripts() {

        wp_register_style( 'modula-album-grid-system', MODULA_ALBUMS_URL . 'assets/css/front/modula-album-grid-system.css', null, MODULA_ALBUMS_VERSION );
        wp_register_script( 'modula-albums', MODULA_ALBUMS_URL . 'assets/js/front/modula-albums.js', array('jquery'), MODULA_ALBUMS_VERSION, true );

        // Modula scripts used for Tilt Hover Effects
	    wp_register_script('modula-pro-tilt', MODULA_PRO_URL . 'assets/js/modula-pro-tilt.min.js', array('jquery'), MODULA_ALBUMS_VERSION, true );

    }

    public function album_shortcode_handler($atts) {
        $default_atts = array(
            'id'    => false,
            'align' => '',
        );

        $atts = wp_parse_args($atts, $default_atts);


        if (!$atts['id'] || 'modula-album' != get_post_type($atts['id'])) {
            return esc_html__('Album not found.', 'modula-albums');
        }

        /* Generate uniq id for this album */
        $gallery_id = 'jtg-album-' . $atts['id'];

        /* Get album settings */
        $settings = get_post_meta($atts['id'], 'modula-album-settings', true);

        $pre_gallery_html = apply_filters( 'modula_albums_pre_output_filter_check', false, $settings, $atts['id'] );

        if ( false !== $pre_gallery_html ) {

            // If there is HTML, then we stop trying to display the gallery and return THAT HTML.
            $pre_output =  apply_filters( 'modula_albums_pre_output_filter','', $settings, $atts['id'] );
            return $pre_output;

        }

        $type = $settings['type'];

        $default           = Modula_Album_Fields_Helper::get_defaults();
        $settings          = wp_parse_args($settings, $default);
        $galleries         = get_post_meta($atts['id'], 'modula-album-galleries', true);
        $script_manager    = Modula_Script_Manager::get_instance();
        $necessary_scripts = array();

	    /* Get gallery images */
	    $galleries = apply_filters( 'modula_album_before_shuffle_galleries', $galleries, $settings );

	    $shuffle_permitted = apply_filters('modula_album_shuffle_grid_types',array('1','2','3','4','5','6'),$settings);

	    if ( isset( $settings['shuffle_galleries'] ) && '1' == $settings['shuffle_galleries'] && in_array($type,$shuffle_permitted) ) {
		    shuffle( $galleries );
	    }

        if ( '1' == $settings['lazy_load'] ) {
            $necessary_scripts[] = 'modula-lazysizes';
        }

        if ( in_array( $settings['effect'], array( 'tilt_1', 'tilt_3', 'tilt_7' ) ) ) {
            $necessary_scripts[] = 'modula-pro-tilt';
        }

        $necessary_scripts[] = 'modula-fancybox';
        $necessary_scripts[] = 'modula-isotope';
        $necessary_scripts[] = 'modula-isotope-packery';
        $necessary_scripts[] = 'modula-albums';

        /* Enqueue lightbox related scripts & styles */
        do_action('modula_album_extra_scripts', $settings);

        // Main CSS & JS
        $necessary_scripts = apply_filters('modula_album_necessary_scripts', $necessary_scripts, $settings);

        $necessary_styles = apply_filters('modula_album_necessary_styles', array( 'modula-album-grid-system', 'modula-fancybox', 'modula' ), $settings);

        if ( ! empty($necessary_scripts) ) {
            foreach ($necessary_scripts as $script) {
                $script_manager->add_scripts( $necessary_scripts );
            }
        }

        if (!empty($necessary_styles)) {
            foreach ($necessary_styles as $style) {
                wp_enqueue_style($style);
            }
        }

        $settings['gallery_id'] = $gallery_id;
	    $settings['align'] = (isset( $atts['align'] ) && '' != $atts['align']) ? 'align' . $atts['align'] : '';

        $template_data = array(
            'album_id'  => $atts['id'],
            'settings'  => $settings,
            'galleries' => $galleries,
            'loader'    => $this->loader,
            // Gallery container attributes
            'album_container' => array(
	            'id'    => $gallery_id,
	            'class' => ('custom-grid' == $type) ? array( 'modula', 'modula-album', 'modula-custom-grid', $settings['align'] ) : array( 'modula', 'modula-album', 'modula-grid', $settings['align'] )
            ),

            // Items container attributes
            'items_container' => array(
	            'class' => array( 'modula-items' ),
            ),
        );

        ob_start();

        /* Config for gallery script */
        $js_config = array(
            'type'                => $type,
            'columns'             => 12,
            'gutter'              => isset($settings['gutter']) ? absint($settings['gutter']) : 10,
            'enableResponsive'    => isset($settings['enable_responsive']) ? $settings['enable_responsive'] : 0,
            'tabletColumns'       => isset($settings['tablet_columns']) ? $settings['tablet_columns'] : 2,
            'mobileColumns'       => isset($settings['mobile_columns']) ? $settings['mobile_columns'] : 1,
            'lazyLoad'            => isset($settings['lazy_load']) ? $settings['lazy_load'] : 1,
            'lightbox'            => isset($settings['enable_lightbox']) ? boolval($settings['enable_lightbox']) : false,
            'lightbox_settings'   => array(
                'buttons'            => array( ),
                'animationEffect'    => isset($settings['animation_effect']) ? $settings['animation_effect'] : 'fade',
                'animationDuration'  => (isset( $settings['animation_effect']) && '0' == $settings['animation_effect'])  ? 0 : ((isset( $settings['animation_duration'])) ? absint( $settings['animation_duration'] ) : 366) ,
                'transitionEffect'   => isset($settings['transition_effect']) ? $settings['transition_effect'] : 'zoom',
                'transitionDuration' => (isset( $settings['transition_effect']) && '0' == $settings['transition_effect'] ) ? 0 : ((isset( $settings['transition_duration'])) ? absint( $settings['transition_duration'] ) : 366),
                'arrows'             => isset($settings['enable_navigation']) ? boolval($settings['enable_navigation']) : false,
                'slideShow' => array(
                    'autoStart' => isset($settings['enable_slideshow']) ? boolval($settings['enable_slideshow']) : false,
                    'speed'     => isset($settings['slideshow_duration']) ? absint($settings['slideshow_duration']) : 3000
                ),
            ),
        );

        if ( isset( $settings['enable_thumbs'] ) && '1' == $settings['enable_thumbs'] ) {
           $js_config['lightbox_settings']['buttons'][] = 'thumbs';
           $js_config['lightbox_settings']['thumbs'] = array(
                'hideOnClose' => true, // Hide thumbnail grid when closing animation starts
                'parentEl' => ".modula-fancybox-container", // Container is injected into this element
                // 'axis' => isset($settings['thumbs_axis']) ? $settings['thumbs_axis'] : 'x'
                'axis' => 'y'
            );
        }
        
        // Display thumbnails on opening
        if ( isset( $settings['autostart_thumbs'] ) && '1' == $settings['autostart_thumbs'] ) {
            $js_config['lightbox_settings']['thumbs']['autoStart'] = true;
        }

        if ( isset( $settings['enable_download'] ) && '1' == $settings['enable_download'] ) {
            $js_config['lightbox_settings']['buttons'][] = 'download';
        }

        if ( isset( $settings['enable_share'] ) && '1' == $settings['enable_share'] ) {
            $js_config['lightbox_settings']['buttons'][] = 'share';

            if(isset($settings['lightbox_facebook']) && '1' == $settings['lightbox_facebook']){
	            $js_config['lightbox_settings']['modulaShare'][] = 'facebook';
            }

	        if(isset($settings['lightbox_twitter']) && '1' == $settings['lightbox_twitter']){
		        $js_config['lightbox_settings']['modulaShare'][] = 'twitter';
	        }

	        if(isset($settings['lightbox_whatsapp']) && '1' == $settings['lightbox_whatsapp']){
		        $js_config['lightbox_settings']['modulaShare'][] = 'whatsapp';
	        }

	        if(isset($settings['lightbox_linkedin']) && '1' == $settings['lightbox_linkedin']){
		        $js_config['lightbox_settings']['modulaShare'][] = 'linkedin';
	        }

	        if(isset($settings['lightbox_pinterest']) && '1' == $settings['lightbox_pinterest']){
		        $js_config['lightbox_settings']['modulaShare'][] = 'pinterest';
            }
            
	        if ( isset( $settings['lightbox_email'] ) && '1' == $settings['lightbox_email'] ) {
		        $js_config['lightbox_settings']['modulaShare'][] = 'email';
	        }

	        if ( isset( $settings['lightboxEmailSubject'] ) ) {
		        $js_config['lightbox_settings']['lightboxEmailSubject'] = esc_html($settings['lightboxEmailSubject']);
	        } else {
		        $js_config['lightbox_settings']['lightboxEmailSubject'] = esc_html__( 'Check out this awesome album !!', 'modula-albums' );
	        }

	        if ( isset( $settings['lightboxEmailMessage'] ) ) {
		        $js_config['lightbox_settings']['lightboxEmailMessage'] = esc_html($settings['lightboxEmailMessage']);
	        } else {
		        $js_config['lightbox_settings']['lightboxEmailMessage'] = esc_html__( 'Here is the link to the image : %%image_link%% and this is the link to the gallery : %%gallery_link%% ', 'modula-albums' );
	        }
        }

	    if ( isset( $settings['enable_zoom'] ) && '1' == $settings['enable_zoom'] ) {
		    $js_config['lightbox_settings']['buttons'][] = 'zoom';
	    }

	    if ( isset( $settings['enable_play'] ) && '1' == $settings['enable_play'] ) {
		    $js_config['lightbox_settings']['buttons'][] = 'slideShow';
	    }

        $js_config['lightbox_settings']['buttons'][] = 'close';

        $template_data['js_config'] = apply_filters('modula_album_js_config', $js_config, $settings);
        $template_data['album_container']['data-config'] = json_encode($js_config);

        $template_data              = apply_filters('modula_album_template_data', $template_data);

        echo $this->generate_album_css($gallery_id, $settings);

        $this->loader->set_template_data($template_data);
        $this->loader->get_template_part('modula', 'albums');

        $html = ob_get_clean();
        return $html;

    }

    /**
     * @param $gallery_id
     * @param $settings
     * @return mixed|string|void
     *
     * Generate CSS for each Gallery
     */
    private function generate_album_css($gallery_id, $settings) {

        $no_height = array('zoe','fluid-up');
        $css = "<style>";

        if ('custom-grid' != $settings['type']) {
            $css .= "#{$gallery_id}, #{$gallery_id} .modula-items { width:" . esc_attr($settings['width']) . ";}";
        } else {
            $css .= "#{$gallery_id}, #{$gallery_id} .modula-items { width:100%; max-width:100%;}";
        }

        if ( '' != $settings['captionColor'] || '' != $settings['captionFontSize'] ) {
            $css .= "#{$gallery_id} .modula-items .figc p.description {";

            if ( '' != $settings['captionColor'] ) {
                $css .= 'color:' . sanitize_hex_color($settings['captionColor']) . ';';
            }

            if ( '0' != $settings['captionFontSize'] ) {
                $css .= 'font-size:' . absint($settings['captionFontSize']) . 'px;';
            }else{
                $css .= 'font-size:inherit;';
            }
            $css .= '}';
        }

        if ( '' != $settings['titleColor'] || '' != $settings['titleFontSize'] ) {
            $css .= "#{$gallery_id} .modula-items .figc .jtg-title {";

            if ( '' != $settings['titleColor'] ) {
                $css .= 'color:' . sanitize_hex_color($settings['titleColor']) . ';';
            }

            if ( '0' != $settings['titleFontSize'] ) {
                $css .= 'font-size:' . absint($settings['titleFontSize']) . 'px;';
            }else{
                $css .= 'font-size:inherit;';
            }
            $css .= '}';
        }

        $css .= '#' . $gallery_id . '.modula-album .modula-items .modula-item{ background-color: ' . sanitize_hex_color($settings['hoverColor']) . '; }';
        $css .= '#' . $gallery_id . '.modula-album .modula-items .modula-item.effect-under .figc{ background-color: ' . sanitize_hex_color($settings['backgroundColor']) . '; }';
        $css .= '#' . $gallery_id . '.modula-album .modula-items .modula-item:hover img.pic { opacity:' . round( absint( $settings['hoverOpacity'] )/100, 1 ) . ';}';

        if ( '0' != $settings['imageCountFontSize'] ) {
            $css .= "#{$gallery_id} .modula-items .figc .jtg-title .image_count { font-size:" . absint($settings['imageCountFontSize']) . "px }";
        }else{
            $css .= "#{$gallery_id} .modula-items .figc .jtg-title .image_count { font-size:inherit; }";
        }

        if ( '' != $settings['imageCountColor'] ) {
            $css .= "#{$gallery_id} .modula-items .figc .jtg-title .image_count { color:" . sanitize_hex_color($settings['imageCountColor']) . "; }";
        }

        // Responsive fixes
        $css .= '@media screen and (max-width:480px){';

        if ('' != $settings['mobileTitleFontSize'] && 0 != $settings['mobileTitleFontSize']) {

            $css .= "#{$gallery_id} .modula-item .figc .jtg-title {  font-size: " . absint($settings['mobileTitleFontSize']) . "px; }";
        }

        $css .= "#{$gallery_id} .modula-items .figc p.description { color:" . sanitize_hex_color($settings['captionColor']) . ";font-size:" . absint($settings['mobileCaptionFontSize']) . "px; }";

        $css .= '}';

	    // Cursor
	    if ( 'custom' != $settings['cursor'] ) {

		    $css .= "#{$gallery_id} .modula-item> .modula-item-content > a { cursor:" . esc_attr($settings['cursor'])."; } ";
	    }else {
		    if( $settings['uploadCursor'] != 0 ){
			    $image_src = wp_get_attachment_image_src( $settings['uploadCursor'] );
			    $css .= "#{$gallery_id} .modula-item> .modula-item-content > a { cursor:url(" . esc_url( $image_src[0])."),auto ; } ";
		    }
	    }
	    if ( 'custom-grid' != $settings['type'] && 'slider' != $settings['type'] ) {

		    $css .= "#{$gallery_id}.modula-album .modula-item { width: calc(" . 100 / absint( $settings['type'] ) . '% - ' . ( absint( $settings['gutter'] ) - absint( $settings['gutter'] ) / absint( $settings['type'] ) ) . "px) !important ; } ";
		    $css .= "#{$gallery_id} .modula-items{position:relative;}";

	    }

	    $css .= "#{$gallery_id} .modula-items > .modula-item > .modula-item-content > .figc>.figc-inner { padding:" . absint($settings['hoverPadding'])."px; } ";

        $css = apply_filters('modula_album_shortcode_css', $css, $gallery_id, $settings);

	    $css .= "#{$gallery_id}  .modula-item.effect-oscar { background: -webkit-linear-gradient(45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#9b4a1b 40%,".modula_pro_sanitize_color($settings['hoverColor'])." 100%);background: linear-gradient(45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#9b4a1b 40%,".modula_pro_sanitize_color($settings['hoverColor'])." 100%);}";

	    $css .= "#{$gallery_id}  .modula-item.effect-roxy {background: -webkit-linear-gradient(45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#05abe0 100%);background: linear-gradient(45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#05abe0 100%);}";

	    $css .= "#{$gallery_id} .modula-item.effect-dexter {background: -webkit-linear-gradient(top,".modula_pro_sanitize_color($settings['hoverColor'])." 0,rgba(104,60,19,1) 100%); background: linear-gradient(to bottom,".modula_pro_sanitize_color($settings['hoverColor'])." 0,rgba(104,60,19,1) 100%);}";

	    $css .= "#{$gallery_id}  .modula-item.effect-jazz {background: -webkit-linear-gradient(-45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#f33f58 100%);background: linear-gradient(-45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#f33f58 100%);}";

	    $css .= "#{$gallery_id} .modula-item.effect-lexi {background: -webkit-linear-gradient(-45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#fff 100%);background: linear-gradient(-45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#fff 100%);}";

	    $css .= "#{$gallery_id} .modula-item.effect-duke {background: -webkit-linear-gradient(-45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#cc6055 100%);background: linear-gradient(-45deg,".modula_pro_sanitize_color($settings['hoverColor'])." 0,#cc6055 100%);}";

	    if ( '1' === $settings['enable_responsive'] ) {

		    $css .= "@media (min-width: 768px) and (max-width: 992px) { #{$gallery_id}.modula-album .modula-item, .modula-album .modula-grid-sizer { width: calc(" . 100 / $settings['tablet_columns'] . "% - " . ( absint( $settings['gutter'] ) - absint( $settings['gutter'] ) / absint( $settings['tablet_columns'] ) ) . "px) !important ; }  }";

		    $css .= "@media (max-width: 768px) { #{$gallery_id}.modula-album .modula-item, .modula-album .modula-grid-sizer { width: calc(" . 100 / $settings['mobile_columns'] . "% - " . ( absint( $settings['gutter'] ) - absint( $settings['gutter'] ) / absint( $settings['mobile_columns'] ) ) . "px) !important ; }  }";
	    }

        $css .= "</style>\n";

        return $css;

    }
}