<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

?>

<div <?php echo Modula_Helper::generate_attributes( $data->album_container ) ?> >

    <?php do_action('modula_album_shortcode_before_items', $data->settings) ?>

    <div <?php echo Modula_Helper::generate_attributes( $data->items_container ) ?>>
        <?php
        $troubleshooting_options = get_option( 'modula_troubleshooting_option', array() );
		$albums_srcset = isset( $troubleshooting_options['remove_srcset'] ) ? $troubleshooting_options['remove_srcset'] : false;
		// Backwards compatibility for ex-albums setting remove_srcset.
        if ( $albums_srcset && '1' === $albums_srcset ) {
	        $troubleshooting_options['disable_srcset'] = '1';
        }

        // go through every gallery in the album
        foreach ( $data->galleries as $gallery ) {

            // get gallery album settings
            $gallery_width  = ('custom-grid' == $data->settings['type']) ? $gallery['width'] : '';
            $gallery_height = ('custom-grid' == $data->settings['type']) ? $gallery['height'] : '';

            // get gallery settings and images
            $images           = get_post_meta( $gallery['id'], 'modula-images', true );

            $gallery_settings = get_post_meta( $gallery['id'], 'modula-settings', true );
	        $gallery_settings = wp_parse_args( $gallery_settings, Modula_Album_Fields_Helper::get_defaults() );

            $image_count = (isset($data->settings['display_image_count']) && '1' == $data->settings['display_image_count']) ? count($images) : false;

            // Prepare array for images configuration
            $images_config = array();

            // only display gallery images data if lightbox enabled in album
            if ( isset($data->settings['enable_lightbox']) && '1' == $data->settings['enable_lightbox'] ) {

                if( !empty( $images ) ){

                    foreach ( $images as $image ) {

                        $caption = '';
                        if( 1 == $data->settings['show_image_title'] ) {
                            $caption .= "<p> {$image['title']} </p> ";
                        }
                        if(  1 == $data->settings['show_image_caption'] ) {
                            $caption .= "<p> {$image['description']} </p> ";
                        }

                        $image_config = array(
	                        'src'  => esc_attr( wp_get_attachment_image_url($image['id'], 'full') ),
                            'opts' => array(
                            		// seems like it was doing a double escape, adding multiple "
	                            'caption' => $caption,
	                            'thumb'   => esc_attr( wp_get_attachment_image_url( $image['id'] ) ),
                            )
                        );

                        $images_config[] = apply_filters( 'modula_album_lightbox_item', $image_config, $image, $gallery_settings, $gallery,$data->settings );
                    }
                }

                $gallery_link = '#';


            } else {

                if ( '' != $gallery['customurl'] ) {
                    $gallery_link = esc_url( $gallery['customurl'] );
                }else{
                    $gallery_link = get_the_permalink($gallery['id']);
                }
            }

            if(!isset($gallery['shuffleCover']) || '1' != $gallery['shuffleCover']) {

				if ( isset( $gallery['cover'] ) && 0 != $gallery['cover'] && ! empty( $gallery['cover'] ) ) {

		            $image = array(
			            'id' => $gallery['cover'],
		            );
	            }
	            else {
		            $image = $images[0];
	            }
            } else {
            	$i = rand(0,count($images) -1);
            	$image = $images[$i];
            }

            $image_object = get_post( $image['id'] );

            if (is_wp_error($image_object) || get_post_type($image_object) != 'attachment') {
                continue;
            }


            // Create array with data in order to send it to image template
            $item_data = array(
				/* Gallery settings */
				'gallery_id'       => $gallery['id'],
				'gallery_images'   => $images_config,
				'album_type'       => $data->settings['type'],

				/* Item Elements */
				'title'            => $gallery['title'],
				'description'      => $gallery['caption'],
				'image_count'      => $image_count,
				'display_image_count' => boolval($data->settings['display_image_count']),

				/* What to show from elements */
				'hide_title'       => boolval( $data->settings['hide_title']),
				'hide_description' => boolval( $data->settings['hide_description']),
				'hide_socials'     => true,
                'remove_srcset'    => isset( $troubleshooting_options['disable_srcset'] ) ? $troubleshooting_options['disable_srcset'] : false,

				/* Item container attributes & classes */
				'columns'          => 12,
				'item_attributes' => array(
	                'data-width'  => $gallery_width,
	                'data-height' => $gallery_height,
	                'class' => array( 'modula-item', 'tg-loaded' ),
                ),

				/* Item link attributes & classes */
				'link_attributes'  => array(
            		'class' => array('gallery-link'),
	                'href' => $gallery_link,
	                'data-gallery-id' => $gallery['id'],
	                'data-gallery-images' => $images_config
                ),

				/* Item img attributes & classes */
				'img_attributes' => array(
	                'alt'   => $gallery['alt'],
	                'class' => array( 'pic' ),
                ),
            );


            $gallery_settings = apply_filters('modula_album_shortcode_gallery_setting', $gallery_settings, $data->settings, $gallery);

            $image = apply_filters('modula_album_shortcode_image_data', $image, $gallery_settings);


            /**
             * Hook: modula_album_shortcode_item_data.
             *
             * @hooked modula_album_generate_image_links - 10
             * @hooked modula_album_check_lightboxes_and_links - 15
             * @hooked modula_album_check_hover_effect - 20
             * @hooked modula_album_check_custom_grid - 25
             * @hooked modula_album_enable_lazy_load - 30
             */
            $item_data = apply_filters('modula_album_shortcode_item_data', $item_data, $image, $gallery_settings, $data->settings, $images);

            do_action('modula_album_shortcode_before_item', $gallery_settings, $item_data);

            $data->loader->set_template_data($item_data);
            $data->loader->get_template_part('items/item', $data->settings['effect']);

            do_action('modula_album_shortcode_after_item', $gallery_settings, $item_data);

        }

        ?>
    </div>

    <?php do_action('modula_album_shortcode_after_items', $data->settings) ?>

</div>