<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
$defaults = apply_filters('modula_standalone_default_settings', array(
    'gallery' => array(
        'enable_rewrite' => 'disabled',
        'slug'           => 'modula-gallery',
    ),
    'album'   => array(
        'enable_rewrite' => 'disabled',
        'slug'           => 'modula-album',
    )));
$settings = get_option( 'modula_standalone', array() );
$settings = wp_parse_args( $settings, $defaults );


?>
<style type="text/css">
	/* Toggles */
	.modula-toggle {
	    position: relative;
	    position: relative;
	    user-select: none;
	    display: inline-block;
	}

	.modula-toggle__items {
	  box-sizing: border-box;
	  display: inline-block;
	    position: relative;
	}
	.modula-toggle__items > * {
	  box-sizing: inherit;
	}

	.modula-toggle__input[type=checkbox] {
	  border-radius: 2px;
	  border: 2px solid #6c7781;
	  margin-right: 12px;
	  transition: none;
	  height: 100%;
	  left: 0;
	  top: 0;
	  margin: 0;
	  padding: 0;
	  opacity: 0;
	  position: absolute;
	  width: 100%;
	  z-index: 1; }

	.modula-toggle__track {
	  background-color: #fff;
	  border: 2px solid #6c7781;
	  border-radius: 9px;
	  display: inline-block;
	  height: 18px;
	  width: 36px;
	  vertical-align: top;
	  transition: background .2s ease; }

	.modula-toggle__thumb {
	  background-color: #6c7781;
	  border: 5px solid #6c7781;
	  border-radius: 50%;
	  display: block;
	  height: 10px;
	  width: 10px;
	  position: absolute;
	  left: 4px;
	  top: 4px;
	  transition: transform .2s ease; }

	.modula-toggle__off {
	  position: absolute;
	  right: 6px;
	  top: 6px;
	  color: #6c7781;
	  fill: currentColor; }

	.modula-toggle__on {
	  position: absolute;
	  top: 6px;
	  left: 8px;
	  border: 1px solid #fff;
	  outline: 1px solid transparent;
	  outline-offset: -1px;
	  display: none; }

	.modula-toggle__input[type=checkbox]:checked + .modula-toggle__items .modula-toggle__track {
	  background-color: #11a0d2;
	  border: 9px solid transparent; }

	.modula-toggle__input[type=checkbox]:checked + .modula-toggle__items .modula-toggle__thumb {
	  background-color: #fff;
	  border-width: 0;
	  transform: translateX(18px); }

	.modula-toggle__input[type=checkbox]:checked + .modula-toggle__items .modula-toggle__off {
	  display: none; }

	.modula-toggle__input[type=checkbox]:checked + .modula-toggle__items .modula-toggle__on {
	  display: inline-block; }
</style>
<div class="row">
	<form method="post" action="options.php">

		<?php settings_fields('modula_standalone'); ?>

		<table class="form-table">
			<tbody>
				<tr valign="top" data-settings="enable_rewrite_gallery">
					<th scope="row" valign="top">
						<?php _e('Enable Galleries Link', 'modula-albums'); ?>
                        <div class="tab-header-tooltip-container modula-tooltip"><span>[?]</span>
                            <div class="tab-header-description modula-tooltip-content">
                                <?php esc_html_e( 'This option allows you to access galleries created through the post type with unique URLs. Now your galleries can have dedicated gallery pages!', 'modula-albums' ) ?>
                            </div>
                        </div>
					</th>
					<td>
						<div class="modula-toggle">
							<input class="modula-toggle__input" type="checkbox" <?php checked( 'enabled', $settings['gallery']['enable_rewrite'], true ); ?> name="modula_standalone[gallery][enable_rewrite]" value="enabled">
							<div class="modula-toggle__items">
								<span class="modula-toggle__track"></span>
								<span class="modula-toggle__thumb"></span>
								<svg class="modula-toggle__off" width="6" height="6" aria-hidden="true" role="img" focusable="false" viewBox="0 0 6 6"><path d="M3 1.5c.8 0 1.5.7 1.5 1.5S3.8 4.5 3 4.5 1.5 3.8 1.5 3 2.2 1.5 3 1.5M3 0C1.3 0 0 1.3 0 3s1.3 3 3 3 3-1.3 3-3-1.3-3-3-3z"></path></svg>
								<svg class="modula-toggle__on" width="2" height="6" aria-hidden="true" role="img" focusable="false" viewBox="0 0 2 6"><path d="M0 0h2v6H0z"></path></svg>
							</div>
						</div>
					</td>
				</tr>
				<tr valign="top" data-settings="gallery_slug">
					<th scope="row" valign="top">
						<?php _e('Gallery Slug', 'modula-albums'); ?>
                        <div class="tab-header-tooltip-container modula-tooltip"><span>[?]</span>
                            <div class="tab-header-description modula-tooltip-content">
                                <?php esc_html_e( 'The slug to prefix to all Modula Galleries( default: modula-gallery ).', 'modula-albums' ) ?>
                                <?php esc_html_e( 'After modification, please flush permalinks ( save permalinks ) so that the effect may take over.', 'modula-albums' ) ?>
                            </div>
                        </div>
					</th>
					<td>
						<input type="text" name="modula_standalone[gallery][slug]" value="<?php echo $settings['gallery']['slug'] ?>" class="wide-text">
					</td>
				</tr>
				<tr valign="top" data-settings="enable_rewrite_album">
					<th scope="row" valign="top">
						<?php _e('Enable Albums Link', 'modula-albums'); ?>
                        <div class="tab-header-tooltip-container modula-tooltip"><span>[?]</span>
                            <div class="tab-header-description modula-tooltip-content">
                                <?php esc_html_e( 'This option allows you to access albums created through the post type with unique URLs. Now your albums can have dedicated pages!', 'modula-albums' ) ?>
                            </div>
                        </div>
					</th>
					<td>
						<div class="modula-toggle">
							<input class="modula-toggle__input" type="checkbox" <?php checked( 'enabled', $settings['album']['enable_rewrite'], true ); ?> name="modula_standalone[album][enable_rewrite]" value="enabled">
							<div class="modula-toggle__items">
								<span class="modula-toggle__track"></span>
								<span class="modula-toggle__thumb"></span>
								<svg class="modula-toggle__off" width="6" height="6" aria-hidden="true" role="img" focusable="false" viewBox="0 0 6 6"><path d="M3 1.5c.8 0 1.5.7 1.5 1.5S3.8 4.5 3 4.5 1.5 3.8 1.5 3 2.2 1.5 3 1.5M3 0C1.3 0 0 1.3 0 3s1.3 3 3 3 3-1.3 3-3-1.3-3-3-3z"></path></svg>
								<svg class="modula-toggle__on" width="2" height="6" aria-hidden="true" role="img" focusable="false" viewBox="0 0 2 6"><path d="M0 0h2v6H0z"></path></svg>
							</div>
						</div>
					</td>
				</tr>
				<tr valign="top" data-settings="album_slug">
					<th scope="row" valign="top">
						<?php _e('Album Slug', 'modula-albums'); ?>
                        <div class="tab-header-tooltip-container modula-tooltip"><span>[?]</span>
                            <div class="tab-header-description modula-tooltip-content">
                                <?php esc_html_e( 'The slug to prefix to all Modula Albums( default: modula-album ).', 'modula-albums' ) ?>
                                <?php esc_html_e( 'After modification, please flush permalinks ( save permalinks ) so that the effect may take over.', 'modula-albums' ) ?>
                            </div>
                        </div>
					</th>
					<td>
						<input type="text" name="modula_standalone[album][slug]" value="<?php echo $settings['album']['slug'] ?>" class="wide-text">
					</td>
				</tr>
				<?php do_action( 'modula_standalone_settings_tab', $settings ) ?>
			</tbody>
		</table>
		<?php submit_button(); ?>
	</form>
</div>