<?php
/**
 * Plugin Name: Modula Albums
 * Plugin URI: https://wp-modula.com/
 * Description: Give your galleries a place to call home with the Albums addon. Create albums, add galleries, manage cover photos, show gallery titles and even image counts in this superb add-on!
 * Author: WPChill
 * Author URI: https://www.wpchill.com/
 * Version: 1.1.6
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
define( 'MODULA_ALBUMS_VERSION', '1.1.6' );
define( 'MODULA_ALBUMS_PATH', plugin_dir_path( __FILE__ ) );
define( 'MODULA_ALBUMS_URL', plugin_dir_url( __FILE__ ) );
define( 'MODULA_ALBUMS_FILE', __FILE__ );

require_once MODULA_ALBUMS_PATH . 'includes/class-modula-standalone.php';
require_once MODULA_ALBUMS_PATH . 'includes/class-modula-albums.php';
require_once MODULA_ALBUMS_PATH . 'includes/admin/class-modula-albums-builder.php';

// Load the main plugin class.
add_action('plugins_loaded','run_modula_albums', 55 );

function run_modula_albums() {
    if ( class_exists( 'Modula_PRO' ) ) {
        $modula_standalone = Modula_Standalone::get_instance();
        $modula_albums     = Modula_Albums::get_instance();
    }
}

add_action( 'admin_init', 'modula_addons_missing_pro_notice' );

if( ! function_exists( 'modula_addons_missing_pro_notice' ) ){
    function modula_addons_missing_pro_notice() {

        if ( class_exists( 'Modula_PRO' ) ) {
            return;
        }
        ?>
        <div id="modula-missing-pro-notice" class="notice notice-success is-dismissible" style="margin-top:30px;">
            <p><?php esc_html_e( 'In order for Modula addons to work Modula PRO addon must be installed and activated.', 'modula-roles' ); ?></p>
    
        </div>
        <?php
    }
}