;(function ($, window, document) {

    var modulaGalleryTemp = null;

    $(document).on('modula_api_after_init', function (event, data) {
        var modula_gallery = data;
        if (modula_gallery.options.modula_deeplink == 1) {
            modula_open_deeplink( modula_gallery, modula_gallery.options.customLinkName );
        }
    });

    /**
     * Fired when a hash is detected in the URL bar
     */
    function modula_open_deeplink( modula_gallery, customLinkName ) {

        if ( modula_gallery ) {
            var gallery_static_id = modula_gallery.$element.attr('id');

            // Get hash
            var hash = window.location.hash.substr(1);
            // Check if a hash exists, and it's an modula Gallery Hash
            if (!hash || hash.length == 0 || hash.indexOf(`${customLinkName}`) == -1) {
                return;
            }

            var params = hash.split('-'), //break up other url params
                gallery_id = params[1],
                image_id = params[2];

            // If here, hash is valid.
            var current_item = modula_gallery.$element.find('a[data-image-id="' + image_id + '"]');
            if ( current_item.length > 1 ) {
                current_item = current_item[0]
            }

            setTimeout(function(){current_item.click()},400);


        }
    }

    function modula_change_hash( gallery_id, image_id ){
        let customLinkName = ( '' ==  $('.modula-gallery').data('config')['customLinkName']) ? 'modulagallery' : $('.modula-gallery').data('config')['customLinkName'] ;
        
        /* Should be executed BEFORE any hash change has occurred. */
        (function (namespace) {
            /* Closure to protect local variable "var hash" */
            if ('replaceState' in history) {
                /* Yay, supported! */
                namespace.replaceHash = function (newhash) {
                    if (('' + newhash).charAt(0) !== '#') newhash = '#' + newhash;
                    history.replaceState('', '', newhash);
                };
            } else {
                var hash = location.hash;
                namespace.replaceHash = function (newhash) {
                    if (location.hash !== hash) history.back();
                    location.hash = newhash;
                };
            }
        })(window);

        window.replaceHash(`!${customLinkName}-` + gallery_id + "-" + image_id);

    }


    /**
     * Bind the modula_make_deeplink function when the window hash changes
     */
    jQuery(window).on('hashchange', function () {
        modula_open_deeplink(modula_galleries_temp);
    });

    // Handle Lightbox2 
    $(document).on( 'modula_lightbox2_lightbox_open modula_lightbox2_lightbox_prev modula_lightbox2_lightbox_next', function( e, lightbox ){

        var currentSRC = lightbox.$image.attr( 'src' );
        var $gallery_image = jQuery('a.tile-inner[href="' + currentSRC + '"]');
        var modula_gallery_id = $gallery_image.parents('.modula.modula-gallery').attr('id');
        var gallery_id = modula_gallery_id.replace( 'jtg-', '' );

        modula_change_hash( gallery_id, $gallery_image.data( 'image-id' ) );

    });

    // Handle Magnific Popup
    $(document).on( 'modula_magnific_lightbox_open modula_magnific_lightbox_change', function( e, event, data, popup ){

        var $gallery_image = popup.currItem.el;
        var modula_gallery_id = $gallery_image.parents('.modula.modula-gallery').attr('id');
        var gallery_id = modula_gallery_id.replace( 'jtg-', '' );
        modula_change_hash( gallery_id, $gallery_image.data( 'image-id' ) );

    });

    // Handle PrettyPhoto
    $(document).on( 'modula_prettyphoto_lightbox_change', function( e, data, popup ){

        if ( 'undefined' == typeof pp_images || 'undefined' == typeof rel_index ) { return; }

        var currentSRC = pp_images[ rel_index ];
        var $gallery_image = data.$element.find('a.tile-inner[href="' + currentSRC + '"]');
        var modula_gallery_id = $gallery_image.parents('.modula.modula-gallery').attr('id');
        var gallery_id = modula_gallery_id.replace( 'jtg-', '' );

        modula_change_hash( gallery_id, $gallery_image.data( 'image-id' ) );

    });


    $(document).on('modula_swipebox_lightbox_after_open modula_swipebox_lightbox_next_slide modula_swipebox_lightbox_prev_slide ', function ( event, data, swipebox ) {

        var currentSwipeItem = jQuery('#swipebox-slider .slide.current img').attr('src');
        if ( ! currentSwipeItem ) {
            modula_gallery_item_id = $(event.currentTarget.activeElement).data('image-id');
        }else{
            modula_gallery_item_id = data.$element.find('a.tile-inner[href="' + currentSwipeItem + '"]').data('image-id');
        }
        
        modula_change_hash( data.options.galleryID, modula_gallery_item_id );

    });


    $(document).on('modula_magnific_lightbox_close modula_swipebox_lightbox_after_close modula_lightbox2_lightbox_close modula_prettyphoto_lightbox_close', function (e, event, data, popup) {

        if ('pushState' in history) {
            history.pushState(null, null, window.location.pathname + window.location.search);
        }

    });

})(jQuery, window, document);