( function ( Modula ) {
	"use strict";

	var modulaDownloadAlbumGalleryConditions = Backbone.Model.extend( {

		initialize: function ( args ) {

			var rows = jQuery( '.modula-settings-container tr[data-container]' );
			var tabs = jQuery( '.modula-tabs .modula-tab' );
			this.set( 'rows', rows );
			this.set( 'tabs', tabs );

			this.initEvents();
			this.initValues();

		},

		initEvents: function () {
			this.listenTo( wp.Modula.Settings, 'change:enable_download_albums', this.changeEnableDownload );
			this.listenTo( wp.Modula.Settings, 'change:download_gallery_button_albums', this.changeDownloadButton );
			this.listenTo( wp.Modula.Settings, 'change:download_all_gallery_button_albums', this.changeDownloadAllButton );

			this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_download_albums', this.toggleDownloadAllButton);

			this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_download_albums', this.toggleDownloadButton);
		},

		initValues: function () {
			this.changeEnableDownload( false, wp.Modula.Settings.get( 'enable_download_albums' ) );
			this.changeDownloadButton( false, wp.Modula.Settings.get( 'download_gallery_button_albums' ) );
			this.changeDownloadAllButton( false, wp.Modula.Settings.get( 'download_all_gallery_button_albums' ) );
		},

		changeEnableDownload: function ( settings, value ) {
			var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_download_albums"]'),
            children  = currentRow.data( 'children' );

       		jQuery.each(children, function(index, item) {

				var child = jQuery('[data-container="'+item+'"]');

				if ( 0 == value && currentRow.hasClass( 'modula_accordion_open' )) {
					child.setting_state( this, 'off');
					child.show();
				}else if( 0 == value ){
					child.hide();

				}else{
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
				}
      		});

		if ( '1' == value ) {
			currentRow.addClass( 'modula_accordion_open' );
		}
			this.changeDownloadButton(false, wp.Modula.Settings.get('download_gallery_button_albums'));
			this.changeDownloadAllButton(false, wp.Modula.Settings.get('download_all_gallery_button_albums'));
		},

		changeDownloadButton: function( settings, value){

			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_gallery_button_albums"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
	
				if ( (0 == value || 0 == wp.Modula.Settings.get( 'enable_download_albums')) && currentRow.hasClass( 'modula_accordion_open' )) {
					child.setting_state( this, 'off');
					child.show();
				}else if( 0 == value || 0 == wp.Modula.Settings.get( 'enable_download_albums')){
					child.hide();
				}else{
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
				}
			});
	
	
			if ( 1 == value && 1 == wp.Modula.Settings.get( 'enable_download_albums') ) {
				currentRow.addClass( 'modula_accordion_open' );
			}
	
		},
	
		toggleDownloadButton: function(){
			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_gallery_button_albums"]'),
				parentRow = rows.filter('[data-container="enable_download_albums"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
				if ( 1 == wp.Modula.Settings.get( 'download_gallery_button_albums' ) && parentRow.hasClass( 'modula_accordion_open' ) && 1 == wp.Modula.Settings.get( 'enable_download_albums' ) && currentRow.hasClass( 'modula_accordion_open' ) ) {
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
					
				}else if( ( 0 == wp.Modula.Settings.get( 'download_gallery_button_albums' ) || 0 == wp.Modula.Settings.get( 'enable_download_albums' ) ) && parentRow.hasClass( 'modula_accordion_open' ) && currentRow.hasClass( 'modula_accordion_open' ) ){
					child.setting_state( this, 'off');
					child.show();
				}else{
					child.hide();
				}
	
			});
	
			if ( 1 == wp.Modula.Settings.get( 'download_gallery_button_albums' ) && parentRow.hasClass( 'modula_accordion_open' ) ) {
				currentRow.addClass( 'modula_accordion_open' );
	
			}
	
		},

		changeDownloadAllButton: function( settings, value){

			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_all_gallery_button_albums"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
	
				if ( (0 == value || 0 == wp.Modula.Settings.get( 'enable_download_albums')) && currentRow.hasClass( 'modula_accordion_open' )) {
					child.setting_state( this, 'off');
					child.show();
				}else if( 0 == value || 0 == wp.Modula.Settings.get( 'enable_download_albums')){
					child.hide();
				}else{
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
				}
			});
	
	
			if ( 1 == value && 1 == wp.Modula.Settings.get( 'enable_download_albums') ) {
				currentRow.addClass( 'modula_accordion_open' );
			}
	
		},
	
		toggleDownloadAllButton: function(){
			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_all_gallery_button_albums"]'),
				parentRow = rows.filter('[data-container="enable_download_albums"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
				if ( 1 == wp.Modula.Settings.get( 'download_all_gallery_button_albums' ) && parentRow.hasClass( 'modula_accordion_open' ) && 1 == wp.Modula.Settings.get( 'enable_download_albums' ) && currentRow.hasClass( 'modula_accordion_open' ) ) {
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
					
				}else if( ( 0 == wp.Modula.Settings.get( 'download_all_gallery_button_albums' ) || 0 == wp.Modula.Settings.get( 'enable_download_albums' ) ) && parentRow.hasClass( 'modula_accordion_open' ) && currentRow.hasClass( 'modula_accordion_open' ) ){
					child.setting_state( this, 'off');
					child.show();
				}else{
					child.hide();
				}
	
			});
	
			if ( 1 == wp.Modula.Settings.get( 'download_all_gallery_button_albums' ) && parentRow.hasClass( 'modula_accordion_open' ) ) {
				currentRow.addClass( 'modula_accordion_open' );
	
			}
	
		},
	} );
	jQuery( document ).ready( function () {
		new modulaDownloadAlbumGalleryConditions();
		
		let input = jQuery( '.modula-placeholder-input');

		jQuery( '.modula-placeholders' ).on('click', 'span', function(){
			let placeholder = jQuery(this).attr('data-placeholder') ;
			input.val( function( index, value ){
				value += placeholder;
				return value;
			})
		})
	} );
} )( jQuery, wp.Modula );
