(function ( Modula ) {
	"use strict";

	var modulaDownloadGalleryConditions = Backbone.Model.extend( {

		initialize: function ( args ) {

			var rows = jQuery( '.modula-settings-container tr[data-container]' );
			var tabs = jQuery( '.modula-tabs .modula-tab' );
			this.set( 'rows', rows );
			this.set( 'tabs', tabs );

			this.initEvents();
			this.initValues();
			this.defaults();
		},

		initEvents: function () {
			this.listenTo( wp.Modula.Settings, 'change:enable_download', this.changeEnableDownload );
			this.listenTo( wp.Modula.Settings, 'change:download_gallery_button', this.changeDownloadButton );
			this.listenTo( wp.Modula.Settings, 'change:download_all_gallery_button', this.changeDownloadAllButton );
			this.listenTo( wp.Modula.Settings, 'change:download_all_gallery_button_icon', this.changeDownloadAllIcon );
			this.listenTo( wp.Modula.Settings, 'change:lightbox', this.changedLightbox );

			this.listenTo( wp.Modula.Settings, 'toggleAccordeon:enable_download', this.toggleDownloadAllButton );
			this.listenTo( wp.Modula.Settings, 'toggleAccordeon:enable_download', this.toggleDownloadButton );
			this.listenTo( wp.Modula.Settings, 'change:enableSocial', this.changeEnableSocial );
		},

		initValues: function () {
			this.changeEnableDownload( false, wp.Modula.Settings.get( 'enable_download' ) );
			this.changeDownloadButton( false, wp.Modula.Settings.get( 'download_gallery_button' ) );
			this.changeDownloadAllButton( false, wp.Modula.Settings.get( 'download_all_gallery_button' ) );
			this.changeDownloadAllIcon( false, wp.Modula.Settings.get( 'download_all_gallery_button_icon' ) );
			this.changedLightbox( false,wp.Modula.Settings.get( 'lightbox' ) );
		},

		changeEnableDownload: function ( settings, value ) {
			var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_download"]'),
            children  = currentRow.data( 'children' );

       		jQuery.each(children, function(index, item) {

				var child = jQuery('[data-container="'+item+'"]');

				if ( 0 == value && currentRow.hasClass( 'modula_accordion_open' )) {
					child.setting_state( this, 'off');
					child.show();
				}else if( 0 == value ){
					child.hide();
				}else{
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
				}
      		});

		if ( '1' == value ) {
			currentRow.addClass( 'modula_accordion_open' );
		}
			this.changeDownloadButton(false, wp.Modula.Settings.get('download_gallery_button'));
			this.changeDownloadAllButton(false, wp.Modula.Settings.get('download_all_gallery_button'));
			this.changeDownloadAllIcon(false, wp.Modula.Settings.get('download_all_gallery_button_icon'));
			this.changeDownloadAllIcon(false, wp.Modula.Settings.get('download_all_gallery_button_icon'));
		},

		changeDownloadButton: function( settings, value){

			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_gallery_button"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
	
				if ( (0 == value || 0 == wp.Modula.Settings.get( 'enable_download')) && currentRow.hasClass( 'modula_accordion_open' )) {
					child.setting_state( this, 'off');
					child.show();
				}else if( 0 == value || 0 == wp.Modula.Settings.get( 'enable_download')){
					child.hide();
				}else{
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
				}
			});
	
	
			if ( 1 == value && 1 == wp.Modula.Settings.get( 'enable_download') ) {
				currentRow.addClass( 'modula_accordion_open' );
			}
	
		},
	
		toggleDownloadButton: function(){
			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_gallery_button"]'),
				parentRow = rows.filter('[data-container="enable_download"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
				if ( 1 == wp.Modula.Settings.get( 'download_gallery_button' ) && parentRow.hasClass( 'modula_accordion_open' ) && 1 == wp.Modula.Settings.get( 'enable_download' ) && currentRow.hasClass( 'modula_accordion_open' ) ) {
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
					
				}else if( ( 0 == wp.Modula.Settings.get( 'download_gallery_button' ) || 0 == wp.Modula.Settings.get( 'enable_download' ) ) && parentRow.hasClass( 'modula_accordion_open' ) && currentRow.hasClass( 'modula_accordion_open' ) ){
					child.setting_state( this, 'off');
					child.show();
				}else{
					child.hide();
				}
	
			});
	
			if ( 1 == wp.Modula.Settings.get( 'download_gallery_button' ) && parentRow.hasClass( 'modula_accordion_open' ) ) {
				currentRow.addClass( 'modula_accordion_open' );
	
			}
	
		},

		changeDownloadAllButton: function( settings, value){

			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_all_gallery_button"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
	
				if ( (0 == value || 0 == wp.Modula.Settings.get( 'enable_download')) && currentRow.hasClass( 'modula_accordion_open' )) {
					child.setting_state( this, 'off');
					child.show();
				}else if( 0 == value || 0 == wp.Modula.Settings.get( 'enable_download')){
					child.hide();
				}else{
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
				}
			});
	
	
			if ( 1 == value && 1 == wp.Modula.Settings.get( 'enable_download') ) {
				currentRow.addClass( 'modula_accordion_open' );
			}
	
		},
	
		toggleDownloadAllButton: function(){
			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_all_gallery_button"]'),
				parentRow = rows.filter('[data-container="enable_download"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
				if ( 1 == wp.Modula.Settings.get( 'download_all_gallery_button' ) && parentRow.hasClass( 'modula_accordion_open' ) && 1 == wp.Modula.Settings.get( 'enable_download' ) && currentRow.hasClass( 'modula_accordion_open' ) ) {
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
					
				}else if( ( 0 == wp.Modula.Settings.get( 'download_all_gallery_button' ) || 0 == wp.Modula.Settings.get( 'enable_download' ) ) && parentRow.hasClass( 'modula_accordion_open' ) && currentRow.hasClass( 'modula_accordion_open' ) ){
					child.setting_state( this, 'off');
					child.show();
				}else{
					child.hide();
				}
	
			});
	
			if ( 1 == wp.Modula.Settings.get( 'download_all_gallery_button' ) && parentRow.hasClass( 'modula_accordion_open' ) ) {
				currentRow.addClass( 'modula_accordion_open' );
	
			}
	
		},

		changeDownloadAllIcon: function( settings, value){

			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_all_gallery_button_icon"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
	
				if ( (0 == value || 0 == wp.Modula.Settings.get( 'enable_download')) && currentRow.hasClass( 'modula_accordion_open' )) {
					child.setting_state( this, 'off');
					child.show();
				}else if( 0 == value || 0 == wp.Modula.Settings.get( 'enable_download')){
					child.hide();
				}else{
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
				}
			});
	
	
			if ( 1 == value && 1 == wp.Modula.Settings.get( 'enable_download') ) {
				currentRow.addClass( 'modula_accordion_open' );
			}
	
		},
	
		toggleDownloadAllIcon: function(){
			var rows = this.get( 'rows' ),
				currentRow = rows.filter('[data-container="download_all_gallery_button_icon"]'),
				parentRow = rows.filter('[data-container="enable_download"]'),
				children  = currentRow.data( 'children' );
	
			jQuery.each(children, function(index, item) {
	
				var child = jQuery('[data-container="'+item+'"]');
	
				if ( 1 == wp.Modula.Settings.get( 'download_all_gallery_button_icon' ) && parentRow.hasClass( 'modula_accordion_open' ) && 1 == wp.Modula.Settings.get( 'enable_download' ) && currentRow.hasClass( 'modula_accordion_open' ) ) {
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
					
				}else if( ( 0 == wp.Modula.Settings.get( 'download_all_gallery_button_icon' ) || 0 == wp.Modula.Settings.get( 'enable_download' ) ) && parentRow.hasClass( 'modula_accordion_open' ) && currentRow.hasClass( 'modula_accordion_open' ) ){
					child.setting_state( this, 'off');
					child.show();
				}else{
					child.hide();
				}
	
			});
	
			if ( 1 == wp.Modula.Settings.get( 'download_all_gallery_button_icon' ) && parentRow.hasClass( 'modula_accordion_open' ) ) {
				currentRow.addClass( 'modula_accordion_open' );
	
			}
	
		},

		changedLightbox: function( settings, value ){
			var rows = this.get( 'rows' ),
				tabs = this.get( 'tabs' ),
				link_options = ['no-link', 'direct', 'attachment-page'];
	
			if ( 'fancybox' == value ) {
				rows.filter( '[data-container="download_all_lightbox_button"]').show();
			}else{
				rows.filter( '[data-container="download_all_lightbox_button"]').hide();
			}
	
		},
		defaults: function(settings, value){
			var rows = this.get( 'rows' );

			if ( '1' == value ) {
				rows.filter( '[data-container="download_gallery_button"]').show();
			}
		}
	} );

	jQuery( document ).ready( function () {
		new modulaDownloadGalleryConditions();

		let input = jQuery( 'input[data-setting="custom_zip_name"]' );

		jQuery( 'tr[data-container="custom_zip_name"] .modula-placeholders' ).on( 'click', 'span', function () {
			let placeholder = jQuery( this ).attr( 'data-placeholder' );
			input.val( function ( index, value ) {
				value += placeholder;
				return value;
			} )
		} )
	} );
})( jQuery, wp.Modula );
