<?php

class Modula_Download_Settings {

	/**
	 * Holds the admin class object
	 *
	 * @since 1.0.0
	 *
	 * @var object
	 */
	public static $instance;

	/**
	 * Constructor for Modula_Download_Settings class
	 *
	 * @return void
	 * @since 1.0.0
	 *
	 */
	public function __construct() {
		//Filter Modula Fields
		add_filter( 'modula_gallery_fields', array( $this, 'modula_download_field' ) );

		//Filter Modula Tab
		add_filter( 'modula_gallery_tabs', array( $this, 'modula_download_tab' ),99 );

		add_action( 'modula_scripts_after_wp_modula', array( $this, 'modula_download_admin_scripts' ) );

		add_action( 'modula_defaults_scripts_after_wp_modula', array( $this, 'modula_download_admin_scripts' ) );
	}

	/**
	 * Returns the singleton instance of the class
	 *
	 * @return object Modula Download Settings object
	 * @since 1.0.0
	 *
	 */
	public static function get_instance() {
		if ( !isset( self::$instance ) && !(self::$instance instanceof Modula_Download_Settings) ) {
			self::$instance = new Modula_Download_Settings();
		}

		return self::$instance;
	}

	/**
	 * Enqueue admin conditions
	 *
	 * @since 1.0.0
	 */
	public function modula_download_admin_scripts() {
		wp_enqueue_script( 'modula-download-conditions', MODULA_DOWNLOAD_URL . 'assets/js/modula-download-conditions.js', array( 'jquery' ), MODULA_DOWNLOAD_VERSION, true );
		wp_enqueue_style( 'modula-download-admin-css', MODULA_DOWNLOAD_URL . 'assets/css/modula-download-admin.css', MODULA_DOWNLOAD_VERSION);
	}

	/**
	 * Download Tab
	 *
	 * @param $tabs
	 *
	 * @return array $tabs
	 * @since 1.0.0
	 */
	public function modula_download_tab( $tabs ) {

		$tabs['download'] = array(
			'label'       => esc_html__( "Download", "modula-download" ),
			'title'       => esc_html__( "Download Settings", "modula-download" ),
			'description' => esc_html__( "The settings bellow adjust the download options .", "modula-download" ),
			'icon'        => "dashicons dashicons-download",
			'priority'    => 85
		);

		if ( isset( $tabs['download']['badge'] ) ) {
			unset( $tabs['download']['badge'] );
		}

		return $tabs;
	}

	/**
	 * Add download fields in settings
	 *
	 * @param array $fields
	 *
	 * @return array $fields
	 * @since 1.0.0
	 *
	 */
	public function modula_download_field( $fields ) {
		$fields['download'] = array(
			'enable_download'                  => array(
				"name"        => esc_html__( 'Enable Download', 'modula-download' ),
				"type"        => "toggle",
				"default"     => 0,
				"description" => esc_html__( 'Enable this option to display a download button on gallery hover or add a download all button.', 'modula-download' ),
				"priority"    => 1,
				"children"    => array( 'download_image_sizes', 'download_all_gallery_button', 'custom_zip_name' ),
			),
			'download_image_sizes'             => array(
				"name"        => esc_html__( 'Download Image size', 'modula-download' ),
				"type"        => "select",
				"description" => esc_html__( 'Select the image size to download from a selection of options.', 'modula-download' ),
				'values'      => array(
					'thumbnail' => esc_html__( 'Thumbnail', 'modula-download' ),
					'medium'    => esc_html__( 'Medium', 'modula-download' ),
					'large'     => esc_html__( 'Large', 'modula-download' ),
					'full'      => esc_html__( 'Full', 'modula-download' ),
				),
				'default'     => 'thumbnail',
				'priority'    => 10,
				'is_child'    => true,
			),
			'download_all_gallery_button'      => array(
				"name"        => esc_html__( 'Download All Button', 'modula-download' ),
				"type"        => "toggle",
				"default"     => 1,
				"description" => esc_html__( 'Enable this option to display the download all label above or bellow the gallery. On by default', 'modula-download' ),
				"priority"    => 20,
				'is_child'    => true,
				"children"    => array( "download_all_color", 'download_all_size', 'download_all_hposition', 'download_all_position', 'download_all_label','download_all_gallery_button_icon','download_all_gallery_icon_color', 'custom_zip_name', 'download_all_background_color' ),
				'parent'	  => "enable_download",
			),
			"download_all_color"     => array(
				"name"        => esc_html__( 'Text Color', 'modula-best-grid-gallery' ),
				"type"        => "color",
				"description" => esc_html__( 'Set the color of download all button.', 'modula-download' ),
				"default"     => "",
				'is_child'    => 'two',
				'priority'    => 30,
			),
			"download_all_background_color"     => array(
				"name"        => esc_html__( 'Background Color', 'modula-best-grid-gallery' ),
				"type"        => "color",
				"description" => esc_html__( 'Set the color of download all button.', 'modula-download' ),
				"default"     => "",
				'is_child'    => 'two',
				'priority'    => 40,
			),
			'download_all_gallery_button_icon' => array(
				"name"        => esc_html__( 'Enable Icon', 'modula-download' ),
				"type"        => "toggle",
				"default"     => 1,
				"description" => esc_html__( 'Enable this option to display an icon near the "Download All" text. Applied to both the shortcode and the label. On by default', 'modula-download' ),
				"priority"    => 50,
				'is_child'    => 'two',
				"children"    => array( "download_all_gallery_icon_color" ),
				'parent'	  => "enable_download",
			),
			'download_all_gallery_icon_color' => array(
				"name"        => esc_html__( 'Icon Color', 'modula-download' ),
				"type"        => "color",
				"default"     => '',
				"description" => esc_html__( 'Choose the download all icon color. If left empty it will get the social icons color.  Applied to both the shortcode and the label.', 'modula-download' ),
				"priority"    => 60,
				'is_child'    => 'three',
			),
			'download_all_size'            => array(
				"name"        => esc_html__( 'Size', 'modula-download' ),
				"type"        => "select",
				"values"      => array(
					"small"   => esc_html__( 'Small', 'modula-download' ),
					"medium"  => esc_html__( 'Medium', 'modula-download' ),
					"large"   => esc_html__( 'Large', 'modula-download' ),
					"x-large" => esc_html__( 'X-Large', 'modula-download' ),
				),
				"default"     => "medium",
				"description" => esc_html__( 'Select the size of your "Download All" button.', 'modula-download' ),
				"priority"    => 70,
				"is_child"    => 'two',
			),
			'download_all_hposition'            => array(
				"name"        => esc_html__( 'Alignment', 'modula-download' ),
				"type"        => "select",
				"values"      => array(
					"left"    => esc_html__( 'Left', 'modula-download' ),
					"right"   => esc_html__( 'Right', 'modula-download' ),
					"center"  => esc_html__( 'Center', 'modula-download' ),
				),
				"default"     => "center",
				"description" => esc_html__( 'Select the horizontal alignment of the "Download All Button"', 'modula-download' ),
				"priority"    => 80,
				"is_child"    => 'two',
			),
			'download_all_position'            => array(
				"name"        => esc_html__( 'Position', 'modula-download' ),
				"type"        => "select",
				"values"      => array(
					"above_gallery"       => esc_html__( 'Above Gallery', 'modula-download' ),
					"below_gallery"       => esc_html__( 'Below Gallery', 'modula-download' ),
					"above_below_gallery" => esc_html__( 'Above & Below Gallery', 'modula-download' ),
				),
				"default"     => "below_gallery",
				"description" => esc_html__( 'Select where you want to display the "Download All" text.', 'modula-download' ),
				"priority"    => 90,
				"is_child"    => 'two',
			),
			'download_all_label'               => array(
				"name"        => esc_html__( 'All Text', 'modula-download' ),
				"type"        => "text",
				"default"     => esc_html__( 'Download All Images', 'modula-download' ),
				"description" => esc_html__( 'Enter a custom label for the Download All button', 'modula-download' ),
				"priority"    => 100,
				'is_child'    => 'two',
			),
			'custom_zip_name'                  => array(
				"name"        => esc_html__( 'Custom Zip Name', 'modula-download' ),
				"type"        => "placeholder",
				"values"      => Modula_Helper::modula_gallery_placeholders(),
				"default"     => '%%gallery_title%%',
				"description" => esc_html__( 'Enter a custom zip name. If left empty the zip name will be under the format of : modula-gallery-id. Applied to both the shortcode and the label.', 'modula-download' ),
				"priority"    => 110,
				'afterrow'    => esc_html__( 'Each placeholder will automatically have space between them or you can manually insert a separator.', 'modula-download' ),
				'is_child'    => "two",
			),

		);

		if ( !extension_loaded('zip') ) {
			$fields['download']['helper-message'] = array(
				"name"     => ' ',
				"type"     => "content",
				"content"  => esc_html__( 'In order for the "Download All" functionality to work you need to enable the ZIP PHP extension. Ask your hosting provider to enable it.', 'modula-download' ),
				'priority' => 111,
			);
		}
		
		// Add download button to socials
		$fields['social']['download_gallery_button'] = array(
			"name"        => esc_html__( 'Download Button', 'modula-download' ),
			"type"        => "toggle",
			"default"     => 1,
			"description" => esc_html__( 'Enable this option to display the download button hovering over an image. On by default', 'modula-download' ),
			"priority"    => 45,
			'is_child'    => true,
		);

		if( isset( $fields['social']['enableSocial']['children'] ) ){
			$fields['social']['enableSocial']['children'] = array_merge( $fields['social']['enableSocial']['children'] , array( 'download_gallery_button' ) );
		}

		// Add download all button to lightbox
		$fields['lightboxes']['download_all_lightbox_button'] = array(
			"name"        => esc_html__( 'Download All Button', 'modula-download' ),
			"type"        => "toggle",
			"default"     => 1,
			"description" => esc_html__( 'Enable this option to display the download all button inside the lightbox. On by default', 'modula-download' ),
			"priority"    => 65,
		);

		return $fields;
	}


}

$modula_download_settings = Modula_Download_Settings::get_instance();