wp.Modula = "undefined" === typeof wp.Modula ? {} : wp.Modula;
wp.Modula.models =
    "undefined" === typeof wp.Modula.models ? {} : wp.Modula.models;
wp.Modula.views = "undefined" === typeof wp.Modula.views ? {} : wp.Modula.views;
wp.Modula.modalChildViews =
    "undefined" === typeof wp.Modula.modalChildViews
        ? []
        : wp.Modula.modalChildViews;

var ModulaExifModalView = Backbone.View.extend({
    /**
     * The Tag Name and Tag's Class(es)
     */
    tagName: "div",
    className: "setting modula-exif",

    /**
     * Template
     * - The template to load inside the above tagName element
     */
    template: wp.template("modula-exif"),

    /**
     * Initialize
     */
    initialize: function (args) {
        var view = this;

        this.model = args.model;
        this.isSelectize = false;
    },

    render: function () {
        let item = this.model.get("item"),
            exifCamera = item.get("exif_camera"),
            exifLens = item.get("exif_lens"),
            exifFocalLength = item.get("exif_focal_length"),
            exifShutterSpeed = item.get("exif_shutter_speed"),
            exifAperture = item.get("exif_aperture"),
            exifIso = item.get("exif_iso"),
            exifDate = item.get("exif_date");

        data = {
            exif_camera: "",
            exif_lens: "",
            exif_focal_length: "",
            exif_shutter_speed: "",
            exif_aperture: "",
            exif_iso: "",
            exif_date: "",
        };

        if (exifCamera) {
            data["exif_camera"] = exifCamera;
        }
        if (exifLens) {
            data["exif_lens"] = exifLens;
        }
        if (exifFocalLength) {
            data["exif_focal_length"] = exifFocalLength;
        }
        if (exifShutterSpeed) {
            data["exif_shutter_speed"] = exifShutterSpeed;
        }
        if (exifAperture) {
            data["exif_aperture"] = exifAperture;
        }
        if (exifIso) {
            data["exif_iso"] = exifIso;
        }
        if (exifDate) {
            data["exif_date"] = exifDate;
        }
        this.$el.html(this.template(data));

        return this;
    },
});

wp.Modula.modalChildViews.push(ModulaExifModalView);
