<?php

/**
 * Format the meta and icon to display properly in lightbox
 *
 * @param string $meta
 *
 * @param string $icon
 *
 * @return string $html
 * @since 1.0.0
 *
 */
function modula_format_exif( $meta, $icon ) {
    $html = '<div class="modula-exif">';
    $html .= Modula_Exif::modula_exif_get_icons( $icon );
    $html .= "<span>".esc_html($meta)."</span>";
    $html .= '</div>';

    return $html;
}

/**
 * Format parameters for EXIF info
 *
 * @param string $type
 * @param string $param
 *
 * @return string
 * @since 1.0.0
 */
function modula_format_exif_data($type, $param){

	$html = '';
	if ( isset( $type ) ) {

		switch ( $type ) {
			case 'shutter_speed':
				if ( !empty( $param ) ) {
					if ( $param > 0 && (1 / $param ) > 1 ) {
						$html .= "1/";
						$html .= number_format( ( 1 / $param ), 0, '.', '' );
					} else {
						$html .= esc_attr( $param ) . ' sec';
					}
				} else {
					$html .= esc_attr( 'N/A' );
				}
				break;
			case 'focal_length' :
				$html = empty( $param ) ? esc_attr("N/A") : (round( $param, 0 ) . "mm");
				break;
			case 'aperture':
				$html = empty( $param ) ? esc_attr("N/A") : ("f/" . esc_attr( $param ));
				break;
			case 'iso' :
				$html = empty( $param ) ? esc_attr("N/A") : ("ISO " . esc_attr( $param ));
				break;
			case 'lens':
				if ( empty( $param ) ) {
					$html = esc_attr('N/A');
					break;
				}

				$lenses = array(
					// Generic
					"----"                               => "N/A",
					"0.0 mm f/0.0"                       => "N/A",
					"70.0-200.0 mm f/2.8"                => "70-200mm f/2.8",
					"85.0 mm f/1.4"                      => "85mm f/1.4",
					"24.0-70.0 mm f/2.8"                 => "24-70mm f/2.8",
					"14.0-24.0 mm f/2.8"                 => "14-24mm f/2.8",
					// Nikon
					"AF-S Zoom-Nikkor 14-24mm f/2.8G ED" => "14-24mm f/2.8",
					// Canon
					"EF-S17-55mm f/2.8 IS USM"           => "17-55mm f/2.8",
					"EF11-24mm f/4L USM"                 => "11-24mm f/4",
					"EF24-70mm f/2.8L II USM"            => "24-70mm f/2.8",
					// Rolleiflex
					"XCD 45"                             => "XCD 45mm"
				);

				if ( isset( $lenses[$param] ) ) {
					$html = esc_attr( $lenses[$param] );
				} else {
					$html = esc_attr( $param );
				}
				break;
			case 'camera':
				if ( empty( $param ) ) {
					$html = esc_attr( 'N/A' );
					break;
				}

				$cameras = array(
					"ILCE-6000"            => "SONY α6000",
					"ILCE-7RM2"            => "SONY α7R II",
					"ILCE-7RM3"            => "SONY α7R III",
					"X1D II 50C"           => "Rolleiflex X1D II",
					"X-T2"                 => "FUJIFILM X-T2",
					"Canon EOS 5D Mark IV" => "Canon 5D Mark IV",
				);
				if ( isset( $cameras[$param] ) ) {
					$html = esc_attr( $cameras[$param] );
				} else {
					$html = esc_attr( $param );
				}
				break;
			default:
				$html = esc_attr( $param );
		}
	}

	return $html;

}