wp.Modula = 'undefined' === typeof( wp.Modula ) ? {} : wp.Modula;

(function( $, modula ){

    var modulaAlbumsPasswordProtectConditions = Backbone.Model.extend({

        initialize: function( args ){

            var rows = jQuery('.modula-settings-container tr[data-container]');
            this.set( 'rows', rows );

            this.initEvents();
            this.initValues();

        },

        initEvents: function(){

            this.listenTo( wp.Modula.Settings, 'change:enable_password', this.changedPassword );

        },

        initValues: function(){

            this.changedPassword( false, wp.Modula.Settings.get( 'enable_password' ) );

        },


        changedPassword: function (settings, value) {

            var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_password"]'),
            children  = currentRow.data( 'children' );

            jQuery.each(children, function(index, item) {

                var child = jQuery('[data-container="'+item+'"]');

                if ( 0 == value || 'undefined' == typeof value ) {
                    child.hide();
                }else{
                    child.css('opacity', '1');
                    child.find('input, textarea, select, button').removeAttr('disabled');
                    child.show();
                }
                if ( ( 0 == value || 'undefined' == typeof value ) && currentRow.hasClass( 'modula_accordion_open' )) {
                    child.setting_state( this, 'off');
                    child.show();
                }else if( 0 == value || 'undefined' == typeof value ){
                    child.hide();
                }else{
                    child.css('opacity', '1');
                    child.find('input, textarea, select, button').removeAttr('disabled');
                    child.show();
                }
            });

            if ("1" == value) {
                currentRow.addClass( 'modula_accordion_open' );
            }
        },

    });

    $(document).ready(function(){
        new modulaAlbumsPasswordProtectConditions();
    })

}( jQuery, wp.Modula ))