wp.ModulaDefaultsAlbums = 'undefined' === typeof( wp.ModulaDefaultsAlbums ) ? {} : wp.ModulaDefaultsAlbums;

(function( $, modula ){

    var modulaDefaultsAlbumsPasswordProtectConditions = Backbone.Model.extend({

        initialize: function( args ){

            var rows = jQuery('.modula-settings-container tr[data-container]');
            this.set( 'rows', rows );

            this.initEvents();
            this.initValues();

        },

        initEvents: function(){

            this.listenTo( wp.ModulaDefaultsAlbums.Settings, 'change:enable_password', this.changedPassword );

        },

        initValues: function(){

            this.changedPassword( false, wp.ModulaDefaultsAlbums.Settings.get( 'enable_password' ) );

        },

        changedPassword: function( settings, value ){
            var rows = this.get( 'rows' ),
                tabs = this.get( 'tabs' );

            if ( '1' == value ) {
                rows.filter( '[data-container="password"], [data-container="password_protect_username"], [data-container="password_protect_text"]' ).show();
            }else{
                rows.filter( '[data-container="password"], [data-container="password_protect_username"], [data-container="password_protect_text"]' ).hide();
            }

        }

    });

    $(document).ready(function(){
        new modulaDefaultsAlbumsPasswordProtectConditions();
    })

}( jQuery, wp.ModulaDefaultsAlbums ))