<?php
/**
 * Plugin Name: Modula Password Protect
 * Plugin URI: https://wp-modula.com/
 * Description: Adds password protection to Modula Image Galleries
 * Author: WPChill
 * Version: 1.0.9
 * Author URI: https://wp-modula.com/
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'MODULA_PASSWORD_PROTECT_VERSION', '1.0.9' );
define( 'MODULA_PASSWORD_PROTECT_PATH', plugin_dir_path( __FILE__ ) );
define( 'MODULA_PASSWORD_PROTECT_URL', plugin_dir_url( __FILE__ ) );
define( 'MODULA_PASSWORD_PROTECT_FILE', __FILE__ );

require_once MODULA_PASSWORD_PROTECT_PATH . 'includes/class-modula-password-protect.php';
require_once MODULA_PASSWORD_PROTECT_PATH . 'includes/albums-password-protect/class-modula-albums-password-protect.php';

// Load the main plugin classes.
add_action('plugins_loaded','run_modula_password_protect', 70 );
function run_modula_password_protect(){
    // Load the main plugin class.
    $modula_protection = Modula_Password_Protect::get_instance();

    if( class_exists( 'Modula_Albums' ) ){
        // Load the class for Albums protection
        $modula_albums_protection = Modula_Albums_Password_Protect::get_instance();
    }

}

