jQuery(document).ready(function ($) {

	/**
	 * Prevent right click on Modula Images
	 */
	$(document).on('contextmenu dragstart', function () {
		var modula_gallery = jQuery('.modula-slider, .modula-slider img, .modula-slider img.pic,.modula-gallery, .modula-gallery img, .modula-gallery img.pic, .modula-link');
		if ( modula_gallery.length > 0 ) {
			return false;
		}

	});

	$('.modula-gallery img, .modula-slider img').on('dragstart', false);

	/**
	 * Monitor which keys are being pressed
	 */
	var modula_protection_keys = {
		'alt': false,
		'shift': false,
		'meta': false,
	};
	$(document).on('keydown', function (e) {

		// Alt Key Pressed
		if ( e.altKey ) {
			modula_protection_keys.alt = true;
		}

		// Shift Key Pressed
		if ( e.shiftKey ) {
			modula_protection_keys.shift = true;
		}

		// Meta Key Pressed (e.g. Mac Cmd)
		if ( e.metaKey ) {
			modula_protection_keys.meta = true;
		}

		if ( e.ctrlKey && '85' == e.keyCode ) {
			modula_protection_keys.ctrl = true;
		}


	});
	$(document).on('keyup', function (e) {

		// Alt Key Released
		if ( !e.altKey ) {
			modula_protection_keys.alt = false;
		}

		// Shift Key Released
		if ( e.shiftKey ) {
			modula_protection_keys.shift = false;
		}

		// Meta Key Released (e.g. Mac Cmd)
		if ( !e.metaKey ) {
			modula_protection_keys.meta = false;
		}

		if ( !e.ctrlKey ) {
			modula_protection_keys.ctrl = false;
		}

	});

	/**
	 * Prevent automatic download when Alt + left click
	 */
	jQuery(document).on('click', '.modula-slider .modula-item,.modula-slider .modula-item img, .modula-slider a, modula-slider img.pic,.modula-gallery img, .modula-gallery a, img.mfp-img, .modula-gallery img.pic, .pp_pic_holder img, img.mfp-img,   .fancybox-container img, img.fancybox-image, #swipebox-overlay img,  #swipebox-slider img, #lightbox img, #lightbox img.lb-image, img.lb-image, .lg-outer img, img.lg-image', function (e) {
		if ( modula_protection_keys.alt || modula_protection_keys.shift || modula_protection_keys.meta || modula_protection_keys.ctrl ) {
			// User is trying to download - stop!
			e.preventDefault();
			return false;
		}
	});

	jQuery(document).on('keydown click', function (e) {
		if ( modula_protection_keys.ctrl || modula_protection_keys.meta ) {
			// User is trying to view source
			e.preventDefault();
			return false;
		}
	});

});