<?php

/**
 *
 */
class Modula_Albums_Protection {

    /**
     * Holds the class object.
     *
     * @since 1.0.2
     *
     * @var object
     */
    public static $instance;

    /**
     * Primary class constructor.
     *
     * @since 1.0.2
     */
    public function __construct() {

        // Filter Modula Protection Tab for Albums
        add_filter('modula_album_tabs', array($this, 'modula_protection_tabs'));

        // Filter Modula Protection Fields for Albums
        add_filter('modula_album_fields', array($this, 'modula_protection_fields'));

        // Filter Modula protection Scripts & Styles for Albums
        add_filter('modula_album_necessary_scripts', array($this, 'modula_protection_scripts'), 15, 2);

        // Filter to output necessary css for protections for Albums
        add_filter('modula_album_shortcode_css', array($this, 'output_css'), 15, 3);

        // Add defaults for Albums
        add_filter('modula_album_default_settings', array($this, 'set_defaults'));

        // Register Protection Scripts for Albums
        add_action('wp_enqueue_scripts', array($this, 'register_protection_scripts'));

    }


    /**
     * Returns the singleton instance of the class.
     *
     * @return object The Modula_Albums_Protection object.
     * @since 1.0.2
     *
     */
    public static function get_instance() {

        if (!isset(self::$instance) && !(self::$instance instanceof Modula_Albums_Protection)) {
            self::$instance = new Modula_Albums_Protection();
        }

        return self::$instance;

    }

    /**
     * Register protection script and style
     */
    public function register_protection_scripts() {
        // Register Protection script for Albums
        wp_register_script('modula-albums-protection-script', MODULA_PROTECTION_URL . 'assets/js/modula-albums-protection.js', array('jquery'));
    }


    /**
     * @param $scripts
     * @param $settings
     *
     * @return array
     *
     * Enqueue protection script
     */
    public function modula_protection_scripts($scripts, $settings) {

        if (isset($settings['protection']) && '1' == $settings['protection']) {
            $scripts[] = 'modula-albums-protection-script';
        }

        return $scripts;
    }

    /**
     * @param $tabs
     * @return mixed
     *
     * Miscellaneous tab for Albums
     */
    public function modula_protection_tabs($tabs) {

        if (!isset($tabs['misc'])) {
            $tabs['misc'] = array(
                'label'    => esc_html__('Miscellaneous', 'modula-protection'),
                "icon"     => "dashicons dashicons-image-filter",
                'priority' => 100,
            );
        }

        return $tabs;
    }


    /**
     * @param $fields
     * @return mixed
     *
     * Protection Fields for Albums
     */
    public function modula_protection_fields($fields) {

        if (!isset($fields['misc']) || !is_array($fields['misc'])) {
            $fields['misc'] = array();
        }

        if (class_exists('Modula_Albums')) {
            // Add filters settings
            $fields['misc']['protection'] = array(
                "name"        => esc_html__('Enable protection', 'modula-protection'),
                "type"        => "toggle",
                "default"     => 0,
                'description' => __('Enable protection for modula albums, disabling right click and Alt+Click functionality for downloading images.', 'modula-protection'),
                'priority'    => 10,
            );
        }

        return $fields;
    }

    /**
     * @param $css
     * @param $gallery_id
     * @param $settings
     * @return string
     *
     * Output CSS required for protection for Albums
     */
    public function output_css($css, $gallery_id, $settings) {

        if ('1' == $settings['protection']) {
            $css .= '.modula-album a.tile-inner, .modula-album img.pic {-webkit-touch-callout: none;}';
        }

        return $css;

    }

    /*
     * Set protection default for Albums
     */
    public function set_defaults($defaults) {
        $defaults['protection'] = 0;

        return $defaults;
    }

}