<?php

/**
 *
 */
class Modula_Protection {

	/**
	 * Holds the class object.
	 *
	 * @since 1.0.0
	 *
	 * @var object
	 */
	public static $instance;

	/**
	 * The name of the plugin.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $plugin_name = 'Modula Protection';

	/**
	 * Unique plugin slug identifier.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $plugin_slug = 'modula-protection';

	/**
	 * Primary class constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {

		// Filter Modula Protection Tab
		add_filter( 'modula_gallery_tabs', array( $this, 'modula_protection_tabs_license' ) );

			// Filter Modula Protection Fields
			add_filter( 'modula_gallery_fields', array( $this, 'modula_protection_fields_license' ) );

		// Filter Modula Protection Tab
		add_filter( 'modula_gallery_tabs', array( $this, 'modula_protection_tabs' ) );

			// Filter Modula Protection Fields
			add_filter( 'modula_gallery_fields', array( $this, 'modula_protection_fields' ) );

			// Load the plugin textdomain.
			add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );

			// Filter Modula protection Scripts & Styles
			add_filter( 'modula_necessary_scripts', array( $this, 'modula_protection_scripts' ), 15, 2 );
			add_filter( 'modula_link_necessary_scripts', array( $this, 'modula_protection_scripts' ), 15, 2 );

			// Filter to output necessary css for protections
			add_filter( 'modula_shortcode_css', array( $this, 'output_css' ), 15, 3 );

			// Add defaults
			add_filter( 'modula_lite_default_settings', array( $this, 'set_defaults' ) );

			// Register Protection Scripts
			add_action( 'wp_enqueue_scripts', array( $this, 'register_protection_scripts' ) );

			// Add protection option to Fancybox
			add_filter( 'modula_fancybox_options', array( $this, 'protection_fancybox_options' ), 16, 2 );

		// register_activation_hook(MODULA_PROTECTION_FILE,array($this,'plugin_activation'));
		// Filter for Video
		add_filter( 'modula_fancybox_options', array( $this, 'disable_download_video'), 10, 2);

			// Load the plugin.
			$this->init();

		// register_activation_hook(MODULA_PROTECTION_FILE,array($this,'plugin_activation'));
	}

    /**
     * Prevent plugin activation if Modula Pro is not installed and activated
     *
     * @since 1.0.3
     */

	/**
	 * Loads the plugin textdomain for translation.
	 *
	 * @since 1.0.0
	 */
	public function load_plugin_textdomain() {
		load_plugin_textdomain( $this->plugin_slug, false, MODULA_PROTECTION_PATH . '/languages/' );
	}

	/**
	 * Loads the plugin into WordPress.
	 *
	 * @since 1.0.0
	 */
	public function init() {

		// Load admin only components.
		if ( is_admin() ) {
			add_action( 'modula_pro_updater', array( $this, 'addon_updater' ), 15, 2 );
		}

	}

	public function addon_updater( $license_key, $store_url ) {

		if ( class_exists( 'Modula_Pro_Base_Updater' ) ) {
			$modula_addon_updater = new Modula_Pro_Base_Updater( $store_url, MODULA_PROTECTION_FILE,
				array(
					'version' => MODULA_PROTECTION_VERSION,        // current version number
					'license' => $license_key,               // license key (used get_option above to retrieve from DB)
					'item_id' => 290481,                      // ID of the product
					'author'  => 'MachoThemes',            // author of this plugin
					'beta'    => false,
				)
			);
		}
	}


	/**
	 * Returns the singleton instance of the class.
	 *
	 * @since 1.0.0
	 *
	 * @return object The Modula_Protection object.
	 */
	public static function get_instance() {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Modula_Protection ) ) {
			self::$instance = new Modula_Protection();
		}

		return self::$instance;

	}

	/**
	 * Register protection script and style
	 */
	public function register_protection_scripts(){
		// Register Protection script
		wp_register_script( 'modula-protection-script', MODULA_PROTECTION_URL . 'assets/js/modula-protection.js', array( 'jquery' ) );
	}

	/**
	 * @param $scripts
	 * @param $settings
	 *
	 * @return array
	 *
	 * Enqueue protection script
	 */
	public function modula_protection_scripts( $scripts, $settings ) {

		if ( isset( $settings['protection'] ) && '1' == $settings['protection'] ) {
			$scripts[] = 'modula-protection-script';
		}

		return $scripts;
	}

	/**
	 * Add tabs if no license is found
	 *
	 * @param $tabs
	 *
	 * @return mixed $tabs
	 */
	public function modula_protection_tabs_license( $tabs ) {
		$tabs['misc']['badge'] = esc_html__( 'Not Activated', 'modula-protection' );
		return $tabs;
	}

	/**
	 * Add field if no license is found 
	 * @param $fields
	 * @return $fields
	 */
	public function modula_protection_fields_license( $fields ) {
		$fields['misc']['modula-misc-need-licenses'] = array(
			"name"     => ' ',
			"type"     => "content",
			"content"  => sprintf(esc_html__('In order to use Protection addon with your gallery you\'ll need to activate your license %shere%s.', 'modula-protection'), '<a href="' . admin_url('edit.php?post_type=modula-gallery&page=modula&modula-tab=licenses') . '">', '</a>'),
			'priority' => 1,
		);
		return $fields;
	}

	public function modula_protection_tabs( $tabs ) {

		if ( !isset( $tabs['misc'] ) ) {
			$tabs['misc'] = array(
				'label'    => esc_html__( 'Miscellaneous', 'modula-protection' ),
				"icon"     => "dashicons dashicons-image-filter",
				'priority' => 100,
			);
		}

		unset($tabs['misc']['badge']);

		return $tabs;

	}

	// Modula PRO Fields
	public function modula_protection_fields( $fields ) {

        if (!isset($fields['misc']) || !is_array($fields['misc'])) {
            $fields['misc'] = array();
        }

        // Add filters settings
        $fields['misc']['protection'] = array(
            "name"        => esc_html__('Enable protection', 'modula-protection'),
            "type"        => "toggle",
            "default"     => 0,
            'description' => __('Enable protection for modula gallery images, disabling right click and Alt+Click functionality for downloading images.', 'modula-protection'),
            'priority'    => 10,
        );

        return $fields;
	}

	public function output_css( $css, $gallery_id, $settings ){

		if ( '1' == $settings['protection'] ) {
			$css .= '.modula-gallery a.tile-inner, .modula-gallery img.pic {-webkit-touch-callout: none;}.pp_pic_holder img {-webkit-touch-callout: none;}';
		}

		return $css;

	}


	/**
	 * Add protection option to Fancybox
	 *
	 * @param $fancybox_options
	 * @param $settings
	 * @return array
	 *
	 * @since 1.0.3
	 */
	public function protection_fancybox_options($fancybox_options,$settings){

		if(isset($settings['protection']) && '1' == $settings['protection']){
			$fancybox_options['options']['protect'] = true;
		} else {
			$fancybox_options['options']['protect'] = false;
		}

		return $fancybox_options;
	}

	public function set_defaults( $defaults ){
		$defaults['protection'] = 0;

		return $defaults;
	}

	public function disable_download_video( $fancybox_options, $settings ) {
		
		if( isset( $settings['protection']) && 1 == $settings['protection'] ) {
			$fancybox_options['video']['tpl'] = '<video class="modula-fancybox-video" controls controlsList="nodownload" disablepictureinpicture poster="{{poster}}">' .
			'<source src="{{src}}" type="{{format}}" />' .
			'Sorry, your browser doesn\'t support embedded videos, <a href="{{src}}">download</a> and watch with your favorite video player!' .
			"</video>";
		}

		return $fancybox_options;
	}

	/**
	 * @param $modula_settings
	 * @param $guest_settings
	 * @param $source
	 *
	 * @return mixed
	 *
	 * @since 1.0.5
	 */
	public function right_click_protecton_migrator_data( $modula_settings, $guest_settings, $source ) {

		if ( $source ) {
			switch ( $source ) {
				case 'envira':

					if ( isset( $guest_settings['config']['protection'] ) && 1 == $guest_settings['config']['protection'] ) {
						$modula_settings['protection'] = 1;
					}

					break;
			}
		}

		return $modula_settings;
	}

}