<?php
/**
 * Plugin Name: Modula Protection
 * Plugin URI: https://wp-modula.com/
 * Description: Prevent visitors from downloading your images without permission.
 * Author: WP Modula
 * Version: 1.0.5
 * Author URI: https://wp-modula.com/
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'MODULA_PROTECTION_VERSION', '1.0.5' );
define( 'MODULA_PROTECTION_PATH', plugin_dir_path( __FILE__ ) );
define( 'MODULA_PROTECTION_URL', plugin_dir_url( __FILE__ ) );
define( 'MODULA_PROTECTION_FILE', __FILE__ );

require_once MODULA_PROTECTION_PATH . 'includes/class-modula-protection.php';
require_once MODULA_PROTECTION_PATH . 'includes/albums-protection/class-modula-albums-protection.php';

// Load the main plugin class.
$modula_protection = Modula_Protection::get_instance();

// Load Albums protection class
$modula_albums_protection = Modula_Albums_Protection::get_instance();
