(function ($) {
	"use strict"
	var modulaSliderConditions = Backbone.Model.extend({
		initialize: function (args) {

			var rows = jQuery('.modula-settings-container tr[data-container]');
			var tabs = jQuery('.modula-tabs .modula-tab');
			var imageSizesInfo = jQuery('.modula-settings-container tr[data-container="slider_image_size"] .modula-imagesizes-infos .modula-imagesize-info');

			this.set( 'imagesizes', imageSizesInfo );
			this.set('rows', rows);
			this.set('tabs', tabs);

			this.initEvents();
			this.initValues();

		},

		initEvents: function () {

			this.listenTo(wp.Modula.Settings, 'change:type', this.changedType);
			this.listenTo(wp.Modula.Settings, 'change:slider_image_size', this.changedImageSize);
			this.listenTo(wp.Modula.Settings, 'change:slider_autoplay', this.changedAutoPlay);
			this.listenTo(wp.Modula.Settings, 'change:slider_syncing', this.changedSliderNav);
			this.listenTo(wp.Modula.Settings, 'change:slider_syncing_nav_size', this.changedSliderNavImageSize);
			this.listenTo(wp.Modula.Settings, 'change:slider_centerMode', this.changedCenterMode);
			this.listenTo(wp.Modula.Settings, 'change:slider_slidesToShow', this.changedSlidesToShow);
            this.listenTo(wp.Modula.Settings, 'change:enable_responsive', this.changedCustomResponsive);
			this.listenTo(wp.Modula.Settings, 'change:slider_lightbox', this.changedSliderLightbox);



		},

		initValues: function () {

			this.changedType(false, wp.Modula.Settings.get('type'));
			this.changedImageSize(false, wp.Modula.Settings.get('slider_image_size'));
			this.changedAutoPlay(false, wp.Modula.Settings.get('slider_autoplay'));
			this.changedSlidesToShow(false, wp.Modula.Settings.get('slider_slidesToShow'));
			this.changedSliderNav(false, wp.Modula.Settings.get('slider_syncing'));
			this.changedSliderNavImageSize(false, wp.Modula.Settings.get('slider_syncing_nav_size'));
			this.changedCenterMode(false, wp.Modula.Settings.get('slider_centerMode'));
            this.changedCustomResponsive(false, wp.Modula.Settings.get('enable_responsive'));
			this.changedSliderLightbox(false, wp.Modula.Settings.get('slider_lightbox'));

        },

		changedType: function (settings, value) {

			this.changedSliderLightbox(false, wp.Modula.Settings.get('slider_lightbox'));

			var rows = this.get('rows'),
				tabs = this.get('tabs');

			if ( 'slider' == value ) {
				if ( '1' == wp.Modula.Settings.get('slider_autoplay') ) {
					rows.filter('[data-container="slider_autoplaySpeed"],[data-container="slider_pauseOnHover"]').show();
				}

				if ( 'custom' == wp.Modula.Settings.get('slider_syncing_nav_size') && 1 == wp.Modula.Settings.get('slider_syncing') ) {
					rows.filter('[data-container="slider_syncing_nav_image_dimensions"], [data-container="slider_syncing_nav_image_crop"]').show();

				} else {
					rows.filter('[data-container="slider_syncing_nav_image_dimensions"], [data-container="slider_syncing_nav_image_crop"]').hide();
				}

				rows.filter('[data-container="slider_adaptiveHeight"],[data-container="shuffle"],[data-container="slider_autoplay"],[data-container="slider_arrows"], [data-container="slider_centerMode"],[data-container="slider_dots"], [data-container="slider_draggable"],[data-container="slider_fade"], [data-container="slider_infinite"], [data-container="slider_slidesToShow"], [data-container="slider_slidesToScroll"],[data-container="slider_speed"], [data-container="slider_rtl"],[data-container="slider_waitForAnimate"], [data-container="slider_initialSlide"],[data-container="slider_mobileFirst"],[data-container="slider_image_size"],[data-container="slider_syncing"],[data-container="gutter"],[data-container="slider_tablet_slides"],[data-container="slider_tablet_scrolls"],[data-container="slider_mobile_slides"],[data-container="slider_mobile_scrolls"],[data-container="slider_image_info"],[data-container="slider_lightbox"]').show();

				tabs.filter('[data-tab="modula-filters"],[data-tab="modula-hover-effect"],[data-tab="modula-image-loaded-effects"],[data-tab="modula-slideshow"],[data-tab="modula-social"]').hide();

				tabs.filter('[data-tab="modula-responsive"],[data-tab="modula-captions"]').show();

				if ( '1' == wp.Modula.Settings.get('slider_syncing') ) {
					rows.filter('[data-container="slider_syncing_nav_size"],[data-container="slider_syncing_nav_thumbnails_number"],[data-container="slider_syncing_nav_thumbnails_gutter"],[data-container="slider_syncing_nav_thumbnails_border_color"]').show();
				}

				rows.filter('[data-container="height"], [data-container="margin"], [data-container="randomFactor"], [data-container="showAllOnLightbox"],[data-container="maxImagesCount"],[data-container="maxImagesCount_mobile"], [data-container="slider_image_dimensions"], [data-container="slider_syncing_nav_image_crop"], [data-container="slider_centerPadding"],[data-tab="grid_type"],[data-tab="grid_row_height"],[data-tab="grid_justify_last_row"],[data-container="tablet_columns"],[data-container="mobile_columns"],[data-container="lightbox"],[data-container="grid_image_size"],[data-container="grid_image_dimensions"],[data-container="grid_image_crop"]').hide();
				console.log( 'hide_grid_type' );
				this.changedImageSize(false, wp.Modula.Settings.get('slider_image_size'));

				if(wp.Modula.GalleryView){
					wp.Modula.GalleryView.container.removeClass('modula-custom-grid').addClass('modula-creative-gallery');
				}


			} else if ( 'custom-grid' == value ) {
				rows.filter('[data-container="slider_adaptiveHeight"],[data-container="slider_autoplay"], [data-container="slider_autoplaySpeed"],[data-container="slider_arrows"], [data-container="slider_centerMode"],[data-container="slider_dots"], [data-container="slider_draggable"],[data-container="slider_fade"], [data-container="slider_infinite"],[data-container="slider_pauseOnHover"], [data-container="slider_slidesToShow"], [data-container="slider_slidesToScroll"],[data-container="slider_speed"], [data-container="slider_rtl"],[data-container="slider_waitForAnimate"], [data-container="slider_initialSlide"],[data-container="slider_mobileFirst"],[data-container="slider_image_size"],[data-container="slider_syncing"],[data-container="slider_syncing_nav_size"],[data-container="slider_syncing_nav_thumbnails_number"],[data-container="slider_syncing_nav_thumbnails_gutter"],[data-container="slider_syncing_nav_thumbnails_border_color"], [data-container="slider_image_dimensions"], [data-container="slider_image_crop"], [data-container="slider_syncing_nav_image_dimensions"], [data-container="slider_syncing_nav_image_crop"], [data-container="slider_centerPadding"],[data-container="slider_tablet_slides"],[data-container="slider_tablet_scrolls"],[data-container="slider_mobile_slides"],[data-container="slider_mobile_scrolls"],[data-container="slider_image_info"],[data-container="slider_lightbox"]').hide();

				tabs.filter('[data-tab="modula-filters"],[data-tab="modula-hover-effect"],[data-tab="modula-image-loaded-effects"],[data-tab="modula-slideshow"],[data-tab="modula-captions"],[data-tab="modula-social"],[data-tab="modula-video"],[data-tab="modula-lightboxes"]').show();
				tabs.filter('[data-tab="modula-responsive"],[data-tab="modula-exif"],[data-tab="modula-zoom"]').show();

				rows.filter('[data-container="columns"], [data-container="gutter"],[data-container="maxImagesCount"],[data-container="maxImagesCount_mobile"],[data-container="lightbox"],[data-container="modula_deeplink"],[data-container="lightbox"],[data-container="grid_image_size"]').show();

				if('custom' == wp.Modula.Settings.get('grid_image_size')){
					rows.filter('[data-container="img_size"],[data-container="img_crop"]').show();
				}

				if('1' == wp.Modula.Settings.get('modula_deeplink')){
					rows.filter('[data-container="customLinkName"]').show();

				}
				rows.filter('[data-container="width"], [data-container="height"], [data-container="margin"], [data-container="randomFactor"], [data-container="shuffle"]').hide();


                if('1' == wp.Modula.Settings.get('enable_responsive')){
                    rows.filter(' [data-container="tablet_columns"],[data-container="mobile_columns"]').show();
                }

			} else if ( 'creative-gallery' == value ) {

				rows.filter('[data-container="slider_adaptiveHeight"],[data-container="slider_autoplay"], [data-container="slider_autoplaySpeed"],[data-container="slider_arrows"], [data-container="slider_centerMode"],[data-container="slider_dots"], [data-container="slider_draggable"],[data-container="slider_fade"], [data-container="slider_infinite"],[data-container="slider_pauseOnHover"], [data-container="slider_slidesToShow"], [data-container="slider_slidesToScroll"],[data-container="slider_speed"], [data-container="slider_rtl"],[data-container="slider_waitForAnimate"], [data-container="slider_initialSlide"],[data-container="slider_mobileFirst"],[data-container="slider_image_size"],[data-container="slider_syncing"], [data-container="slider_syncing_nav_size"],[data-container="slider_syncing_nav_thumbnails_number"],[data-container="slider_syncing_nav_thumbnails_gutter"],[data-container="slider_syncing_nav_thumbnails_border_color"],[data-container="slider_image_dimensions"], [data-container="slider_image_crop"], [data-container="slider_centerPadding"],[data-container="slider_syncing_nav_image_crop"], [data-container="slider_syncing_nav_image_dimensions"],[data-container="slider_tablet_slides"],[data-container="slider_tablet_scrolls"],[data-container="slider_mobile_slides"],[data-container="slider_mobile_scrolls"],[data-container="slider_image_info"],[data-container="slider_lightbox"]').hide();

				tabs.filter('[data-tab="modula-filters"],[data-tab="modula-hover-effect"],[data-tab="modula-image-loaded-effects"],[data-tab="modula-slideshow"],[data-tab="modula-captions"],[data-tab="modula-social"],[data-tab="modula-video"],[data-tab="modula-lightboxes"],[data-tab="modula-exif"],[data-tab="modula-zoom"]').show();
				tabs.filter('[data-tab="modula-responsive"]').hide();

				rows.filter('[data-container="columns"]').hide();
				rows.filter('[data-container="width"], [data-container="height"], [data-container="margin"], [data-container="randomFactor"], [data-container="shuffle"],[data-container="maxImagesCount"],[data-container="lightbox"],[data-container="modula_deeplink"],[data-container="lightbox"],[data-container="grid_image_size"]').show();

				if('custom' == wp.Modula.Settings.get('grid_image_size')){
					rows.filter('[data-container="grid_image_dimensions"],[data-container="grid_image_crop"]').show();
				}

				if('1' == wp.Modula.Settings.get('modula_deeplink')){
					rows.filter('[data-container="customLinkName"]').show();

				}

			} else if('grid' == value){
				rows.filter('[data-container="slider_adaptiveHeight"],[data-container="slider_autoplay"], [data-container="slider_autoplaySpeed"],[data-container="slider_arrows"], [data-container="slider_centerMode"],[data-container="slider_dots"], [data-container="slider_draggable"],[data-container="slider_fade"], [data-container="slider_infinite"],[data-container="slider_pauseOnHover"], [data-container="slider_slidesToShow"], [data-container="slider_slidesToScroll"],[data-container="slider_speed"], [data-container="slider_rtl"],[data-container="slider_waitForAnimate"], [data-container="slider_initialSlide"],[data-container="slider_mobileFirst"],[data-container="slider_image_size"],[data-container="slider_syncing"], [data-container="slider_syncing_nav_size"],[data-container="slider_syncing_nav_thumbnails_number"],[data-container="slider_syncing_nav_thumbnails_gutter"],[data-container="slider_syncing_nav_thumbnails_border_color"],[data-container="slider_image_dimensions"], [data-container="slider_image_crop"], [data-container="slider_centerPadding"],[data-container="slider_syncing_nav_image_crop"], [data-container="slider_syncing_nav_image_dimensions"],[data-container="slider_tablet_slides"],[data-container="slider_tablet_scrolls"],[data-container="slider_mobile_slides"],[data-container="slider_mobile_scrolls"],[data-container="slider_image_info"],[data-container="slider_lightbox"]').hide();

				tabs.filter('[data-tab="modula-filters"],[data-tab="modula-hover-effect"],[data-tab="modula-image-loaded-effects"],[data-tab="modula-slideshow"],[data-tab="modula-captions"],[data-tab="modula-social"],[data-tab="modula-video"],[data-tab="modula-lightboxes"]').show();
				tabs.filter('[data-tab="modula-responsive"]').show();

				rows.filter('[data-container="modula_deeplink"],[data-container="lightbox"],[data-container="grid_image_size"],[data-container="shuffle"]').show();

				if('custom' == wp.Modula.Settings.get('grid_image_size')){
					rows.filter('[data-container="grid_image_dimensions"],[data-container="grid_image_crop"]').show();
				}

				if('1' == wp.Modula.Settings.get('modula_deeplink')){
					rows.filter('[data-container="customLinkName"]').show();

				}
			}
		},

		changedImageSize: function (settings, value) {

			var rows = this.get('rows'),
				tabs = this.get('tabs'),
				imagesizes = this.get( 'imagesizes' );

			if ( wp.Modula.Settings.get('type') != 'slider' ) {
				return;
			}

			if ( 'custom' == value ) {
				rows.filter('[data-container="slider_image_dimensions"], [data-container="slider_image_crop"]').show();
			} else {
				rows.filter('[data-container="slider_image_dimensions"],[data-container="slider_image_crop"]').hide();
			}

			var currentInfo = imagesizes.filter( '[data-size="' + value + '"]' );
			imagesizes.hide();
			if ( currentInfo.length > 0 ) {
				currentInfo.show();
			}


		},

		changedAutoPlay: function (settings, value) {

			if ( wp.Modula.Settings.get('type') != 'slider' ) {
				return;
			}

			var rows = this.get('rows'),
				tabs = this.get('tabs');

			if ( '1' == value ) {
				rows.filter('[data-container="slider_autoplaySpeed"], [data-container="slider_pauseOnHover"]').show();
			} else {
				rows.filter('[data-container="slider_autoplaySpeed"], [data-container="slider_pauseOnHover"]').hide();
			}

		},

		changedSliderNav: function (settings, value) {

			if ( wp.Modula.Settings.get('type') != 'slider' ) {
				return;
			}

			var rows = this.get('rows'),
				tabs = this.get('tabs');


			if ( 1 == value ) {
				rows.filter('[data-container="slider_syncing_nav_thumbnails_gutter"], [data-container="slider_syncing_nav_size"],[data-container="slider_syncing_nav_thumbnails_number"], [data-container="slider_syncing_nav_thumbnails_border_color"]').show();
			} else {
				rows.filter('[data-container="slider_syncing_nav_thumbnails_gutter"], [data-container="slider_syncing_nav_size"],[data-container="slider_syncing_nav_thumbnails_number"], [data-container="slider_syncing_nav_thumbnails_border_color"]').hide();
			}

			if ( 'custom' == wp.Modula.Settings.get('slider_syncing_nav_size') && 1 == value && 'slider' == wp.Modula.Settings.get('type') ) {
				rows.filter('[data-container="slider_syncing_nav_image_dimensions"], [data-container="slider_syncing_nav_image_crop"]').show();
			} else {
				rows.filter('[data-container="slider_syncing_nav_image_dimensions"], [data-container="slider_syncing_nav_image_crop"]').hide();
			}
			this.changedSlidesToShow(false, wp.Modula.Settings.get('slider_slidesToShow'));
		},

		changedSliderNavImageSize: function (settings, value) {

			if ( wp.Modula.Settings.get('type') != 'slider' ) {
				return;
			}

			var rows = this.get('rows'),
				tabs = this.get('tabs');

			if ( 'custom' == value && 1 == wp.Modula.Settings.get('slider_syncing') && 'slider' == wp.Modula.Settings.get('type') ) {
				rows.filter('[data-container="slider_syncing_nav_image_dimensions"], [data-container="slider_syncing_nav_image_crop"]').show();
			} else {
				rows.filter('[data-container="slider_syncing_nav_image_dimensions"], [data-container="slider_syncing_nav_image_crop"]').hide();
			}

		},

		changedCenterMode: function (settings, value) {

			if ( wp.Modula.Settings.get('type') != 'slider' ) {
				return;
			}

			var rows = this.get('rows'),
				tabs = this.get('tabs');

			if ( '1' == value ) {
				rows.filter('[data-container="slider_centerPadding"]').show();
			} else {
				rows.filter('[data-container="slider_centerPadding"]').hide();
			}
		},

		changedSlidesToShow: function (settings, value) {

			if ( wp.Modula.Settings.get('type') != 'slider' ) {
				return;
			}

			var rows = this.get('rows'),
				tabs = this.get('tabs');

			if ( '1' == value ) {
				rows.filter('[data-container="slider_fade"],[data-container="slider_syncing"],[data-container="slider_adaptiveHeight"]').show();
				if ( '1' == wp.Modula.Settings.get('slider_syncing') ) {
					rows.filter('[data-container="slider_syncing_nav_thumbnails_gutter"], [data-container="slider_syncing_nav_size"],[data-container="slider_syncing_nav_thumbnails_number"], [data-container="slider_syncing_nav_thumbnails_border_color"],[data-container="slider_syncing_nav_image_crop"],[data-container="slider_fade"]').show();

					if('custom' == wp.Modula.Settings.get('slider_syncing_nav_size')){
						rows.filter(' [data-container="slider_syncing_nav_image_dimensions"]').show();
					}
				} else {
					rows.filter('[data-container="slider_syncing_nav_thumbnails_gutter"], [data-container="slider_syncing_nav_size"],[data-container="slider_syncing_nav_thumbnails_number"], [data-container="slider_syncing_nav_thumbnails_border_color"],[data-container="slider_syncing_nav_image_crop"], [data-container="slider_syncing_nav_image_dimensions"]').hide();
					rows.filter('[data-container="slider_fade"]').show();
				}
			} else {
				rows.filter('[data-container="slider_syncing_nav_thumbnails_gutter"], [data-container="slider_syncing_nav_size"],[data-container="slider_syncing_nav_thumbnails_number"], [data-container="slider_syncing_nav_thumbnails_border_color"],[data-container="slider_syncing_nav_image_crop"],[data-container="slider_fade"],[data-container="slider_syncing"], [data-container="slider_syncing_nav_image_dimensions"], [data-container="slider_adaptiveHeight"]').hide();
			}


		},

        changedCustomResponsive: function (settings, value) {

            var rows = this.get('rows'),
                tabs = this.get('tabs');


            if ( wp.Modula.Settings.get('type') != 'slider' ) {
                return;
            }

            rows.filter(' [data-container="tablet_columns"],[data-container="mobile_columns"]').hide();

            if ( '1' == value ) {
                rows.filter(' [data-container="slider_tablet_slides"],[data-container="slider_tablet_scrolls"],[data-container="slider_mobile_slides"],[data-container="slider_mobile_scrolls"]').show();


            } else {
                rows.filter(' [data-container="slider_tablet_slides"],[data-container="slider_tablet_scrolls"],[data-container="slider_mobile_slides"],[data-container="slider_mobile_scrolls"]').hide();

            }

        },

		changedSliderLightbox: function ( settings, value ) {

			var rows         = this.get( 'rows' ),
			    tabs         = this.get( 'tabs' );

			if ( wp.Modula.Settings.get( 'type' ) == 'slider' ) {
			
				if ( 'fancybox' == value ) {

					rows.filter( '[data-container="loop_lightbox"],[data-container="lightbox_keyboard"], [data-container="lightbox_wheel"],[data-container="lightbox_clickSlide"],[data-container="lightbox_animationEffect"],[data-container="lightbox_animationDuration"],[data-container="lightbox_transitionEffect"],[data-container="lightbox_transitionDuration"],[data-container="lightbox_toolbar"],[data-container="lightbox_infobar"],[data-container="lightbox_dblclickSlide"],[data-container="lightbox_touch"],[data-container="lightbox_thumbsAutoStart"],[data-container="lightbox_thumbsAxis"],[data-container="lightbox_bottomThumbs"],[data-container="showAllOnLightbox"],[data-container="lightbox_background_color"],[data-container="showTitleLightbox"],[data-container="showCaptionLightbox"],[data-container="captionPosition"],[data-container="show_navigation"],[data-container="doubleClick"],[data-container="caption_overlap"],[data-container="open_Lightbox_on"],[data-container="mobile_caption_overlap"],[data-container="mobile_caption_copy"],[data-container="lightbox_active_colors"]' ).show();

					tabs.filter( '[data-tab="modula-exif"],[data-tab="modula-zoom"]' ).show();

					if ( '1' == wp.Modula.Settings.get( 'lightbox_toolbar' ) && '1' == wp.Modula.Settings.get( 'lightbox_share' ) ) {
						rows.filter( '[data-container="lightbox_linkedin"],[data-container="lightbox_facebook"],[data-container="lightbox_whatsapp"],[data-container="lightbox_pinterest"],[data-container="lightbox_twitter"],[data-container="lightbox_email"]' ).show();
					} else {
						rows.filter( '[data-container="lightbox_linkedin"],[data-container="lightbox_facebook"],[data-container="lightbox_whatsapp"],[data-container="lightbox_pinterest"],[data-container="lightbox_twitter"],[data-container="lightbox_email"]' ).hide();
					}

					jQuery( '.lightbox-afterrow' ).show();

					if ( 1 == wp.Modula.Settings.get( 'lightbox_toolbar' ) ) {
						rows.filter( '[data-container="lightbox_close"],[data-container="lightbox_thumbs"],[data-container="lightbox_download"],[data-container="lightbox_zoom"],[data-container="lightbox_share"]' ).show();
					}

				} else {

					rows.filter( ' [data-container="loop_lightbox"],[data-container="lightbox_keyboard"], [data-container="lightbox_wheel"],[data-container="lightbox_clickSlide"],[data-container="lightbox_animationEffect"],[data-container="lightbox_animationDuration"],[data-container="lightbox_transitionEffect"],[data-container="lightbox_transitionDuration"],[data-container="lightbox_toolbar"],[data-container="lightbox_close"],[data-container="lightbox_thumbs"],[data-container="lightbox_download"],[data-container="lightbox_zoom"],[data-container="lightbox_share"],[data-container="lightbox_infobar"],[data-container="lightbox_dblclickSlide"],[data-container="lightbox_touch"],[data-container="lightbox_thumbsAutoStart"],[data-container="lightbox_thumbsAxis"],[data-container="lightbox_bottomThumbs"],[data-container="showAllOnLightbox"],[data-container="lightbox_background_color"],[data-container="showTitleLightbox"],[data-container="showCaptionLightbox"],[data-container="captionPosition"],[data-container="lightbox_linkedin"],[data-container="lightbox_facebook"],[data-container="lightbox_whatsapp"],[data-container="lightbox_pinterest"],[data-container="lightbox_twitter"],[data-container="lightbox_email"],[data-container="show_navigation"],[data-container="doubleClick"],[data-container="caption_overlap"],[data-container="open_Lightbox_on"],[data-container="mobile_caption_overlap"],[data-container="mobile_caption_copy"],[data-container="lightbox_active_colors"]' ).hide();

					tabs.filter( '[data-tab="modula-exif"],[data-tab="modula-zoom"]' ).hide();

					jQuery( '.lightbox-afterrow' ).hide();

				}
			}else{

				if ( 'fancybox' ==  wp.Modula.Settings.get( 'lightbox' ) ) {

					rows.filter( '[data-container="loop_lightbox"],[data-container="lightbox_keyboard"], [data-container="lightbox_wheel"],[data-container="lightbox_clickSlide"],[data-container="lightbox_animationEffect"],[data-container="lightbox_animationDuration"],[data-container="lightbox_transitionEffect"],[data-container="lightbox_transitionDuration"],[data-container="lightbox_toolbar"],[data-container="lightbox_infobar"],[data-container="lightbox_dblclickSlide"],[data-container="lightbox_touch"],[data-container="lightbox_thumbsAutoStart"],[data-container="lightbox_thumbsAxis"],[data-container="lightbox_bottomThumbs"],[data-container="showAllOnLightbox"],[data-container="lightbox_background_color"],[data-container="showTitleLightbox"],[data-container="showCaptionLightbox"],[data-container="captionPosition"],[data-container="show_navigation"],[data-container="doubleClick"],[data-container="caption_overlap"],[data-container="open_Lightbox_on"],[data-container="mobile_caption_overlap"],[data-container="mobile_caption_copy"],[data-container="lightbox_active_colors"]' ).show();

					tabs.filter( '[data-tab="modula-exif"],[data-tab="modula-zoom"]' ).show();

					if ( '1' == wp.Modula.Settings.get( 'lightbox_toolbar' ) && '1' == wp.Modula.Settings.get( 'lightbox_share' ) ) {
						rows.filter( '[data-container="lightbox_linkedin"],[data-container="lightbox_facebook"],[data-container="lightbox_whatsapp"],[data-container="lightbox_pinterest"],[data-container="lightbox_twitter"],[data-container="lightbox_email"]' ).show();
					} else {
						rows.filter( '[data-container="lightbox_linkedin"],[data-container="lightbox_facebook"],[data-container="lightbox_whatsapp"],[data-container="lightbox_pinterest"],[data-container="lightbox_twitter"],[data-container="lightbox_email"]' ).hide();
					}

					jQuery( '.lightbox-afterrow' ).show();

					if ( 1 == wp.Modula.Settings.get( 'lightbox_toolbar' ) ) {
						rows.filter( '[data-container="lightbox_close"],[data-container="lightbox_thumbs"],[data-container="lightbox_download"],[data-container="lightbox_zoom"],[data-container="lightbox_share"]' ).show();
					}

				} else {

					rows.filter( ' [data-container="loop_lightbox"],[data-container="lightbox_keyboard"], [data-container="lightbox_wheel"],[data-container="lightbox_clickSlide"],[data-container="lightbox_animationEffect"],[data-container="lightbox_animationDuration"],[data-container="lightbox_transitionEffect"],[data-container="lightbox_transitionDuration"],[data-container="lightbox_toolbar"],[data-container="lightbox_close"],[data-container="lightbox_thumbs"],[data-container="lightbox_download"],[data-container="lightbox_zoom"],[data-container="lightbox_share"],[data-container="lightbox_infobar"],[data-container="lightbox_dblclickSlide"],[data-container="lightbox_touch"],[data-container="lightbox_thumbsAutoStart"],[data-container="lightbox_thumbsAxis"],[data-container="lightbox_bottomThumbs"],[data-container="showAllOnLightbox"],[data-container="lightbox_background_color"],[data-container="showTitleLightbox"],[data-container="showCaptionLightbox"],[data-container="captionPosition"],[data-container="lightbox_linkedin"],[data-container="lightbox_facebook"],[data-container="lightbox_whatsapp"],[data-container="lightbox_pinterest"],[data-container="lightbox_twitter"],[data-container="lightbox_email"],[data-container="show_navigation"],[data-container="doubleClick"],[data-container="caption_overlap"],[data-container="open_Lightbox_on"],[data-container="mobile_caption_overlap"],[data-container="mobile_caption_copy"],[data-container="lightbox_active_colors"]' ).hide();

					tabs.filter( '[data-tab="modula-exif"],[data-tab="modula-zoom"]' ).hide();

					jQuery( '.lightbox-afterrow' ).hide();

				}	
			}
		}

	});


	$(document).ready(function () {
		new modulaSliderConditions();
	});

})(jQuery);