(function ($) {
	'use strict';

	$(document).ready(function () {
		init_modula_sliders($('.modula-slider'));
	});

    //Divi builder fix - init sliders after modula galery finised building the html.
    $(document).on('modula_api_after_init', () => {
        init_modula_sliders($('.modula-slider'));
    });

	$(document).on('elementor/popup/show', (event, id, instance) => {
		init_modula_sliders($('#elementor-popup-modal-' + id).find('.modula-slider'));
	});

	function init_modula_sliders(modulaSliders) {
		if (modulaSliders.length > 0) {
			$.each(modulaSliders, function () {
				var modulaID  = $(this).attr('id'),
					config    = $(this).data('config'),
					nav       = $(this).find('.modula-slider-nav'),
					main      = $(this).find('.modula-items'),
					img_count = main.find('.modula-item').length;

				main.options = config;
				main.slick(config.slider_settings);

				if (nav.length) {

					var navConfig    = nav.data('config'),
						currentSlide = main.slick('slickCurrentSlide');

					nav.on('init', function (event, slick) {
						nav.find('.slick-slide[data-slick-index="' + currentSlide + '"]').addClass('is-active');
					})

					nav.slick(navConfig);

					main.on('afterChange', function (event, slick, currentSlide) {
						nav.slick('slickGoTo', currentSlide);
						var currrentNavSlideElem = '.slick-slide[data-slick-index="' + currentSlide + '"]';
						nav.find('.slick-slide.is-active').removeClass('is-active');
						nav.find(currrentNavSlideElem).addClass('is-active');
					});

					nav.on('click', '.slick-slide', function (event) {
						event.preventDefault();
						var goToSingleSlide = $(this).data('slick-index');
						main.slick('slickGoTo', goToSingleSlide);
					});

				}

                // Status bar
				if( config.slider_settings.showCount ){
					var $status = $('<span class="modula-slider-slide-counter"></span>');
					main.find('.slick-list').prepend( $status ); 
					$status.text( ( config.slider_settings.initialSlide + 1 ) + '/' + Math.ceil( img_count / config.slider_settings.slidesToScroll ) );
					main.on( 'reInit afterChange', function( event, slick, currentSlide, nextSlide ){
						var i = ( currentSlide ? currentSlide : 0 ) + 1;
						$status.text( Math.floor( i / config.slider_settings.slidesToScroll + ( config.slider_settings.slidesToScroll - 1 ) ) + '/' + Math.ceil( slick.slideCount / config.slider_settings.slidesToScroll ) );
					});
				}

				
				// Lightbox functionality
				if ('fancybox' === config.lightbox) {

					main.on('click', '.modula-item-link:not( .modula-simple-link )', function (e) {
						e.preventDefault();

						var slides = main.find('.slick-slide').filter(':not( .slick-cloned )'),
							items  = slides.find('.modula-item').filter(':not( .modula-simple-link )'),
							links  = jQuery.map(items, function (o) {
								var link  = jQuery(o).find('.modula-item-link'),
									image = jQuery(o).find('.pic');

								var image_link = image.data('full');
								if (typeof image_link === "undefined") {
									var image_link = image.attr('src');
								}

								if (link.length > 0) {
									return {
										'src' : image_link,
										'opts': {
											'caption' : link.data('caption'),
											'alt'     : image.attr('alt'),
											'thumb'   : link.attr('data-thumb'),
											'$thumb'   : image.parents('.modula-item'),
											'image_id': link.attr('data-image-id')
										}
									}
								}
							});

						var index = items.index(jQuery(this).parents('.modula-item'));

						config.lightboxOpts['beforeLoad']   = function () {
							jQuery(document).trigger('modula_fancybox_lightbox_before_load', [main, this]);
						};
						config.lightboxOpts['afterLoad']    = function () {
							jQuery(document).trigger('modula_fancybox_lightbox_after_load', [main, this]);
						};
						config.lightboxOpts['beforeShow']   = function () {
							jQuery(document).trigger('modula_fancybox_lightbox_before_show', [main, this]);
						};
						config.lightboxOpts['afterShow']    = function () {
							jQuery(document).trigger('modula_fancybox_lightbox_after_show', [main, this]);
						};
						config.lightboxOpts['beforeClose']  = function () {
							jQuery(document).trigger('modula_fancybox_lightbox_before_close', [main, this]);
						};
						config.lightboxOpts['afterClose']   = function () {
							jQuery(document).trigger('modula_fancybox_lightbox_after_close', [main, this]);
						};
						config.lightboxOpts['onInit']       = function () {
							jQuery(document).trigger('modula_fancybox_lightbox_on_init', [main, this]);
						};
						config.lightboxOpts['onActivate']   = function () {
							jQuery(document).trigger('modula_fancybox_lightbox_on_activate', [main, this]);
						};
						config.lightboxOpts['onDeactivate'] = function () {
							jQuery(document).trigger('modula_fancybox_lightbox_on_deactivate', [main, this]);
						};

						if (modulacheckDevice(config)) {
							jQuery.modulaFancybox.open(links, config.lightboxOpts, index);
						}

					});

					main.on( 'click','.gallery-link:not(.simple-link)', function( evt ){
						evt.preventDefault();
						var images = $(this).data( 'gallery-images' );
						jQuery.modulaFancybox.open( images, config.lightboxOpts );
					});
				}
			});
		}
	}

})(jQuery);