jQuery( document ).on( 'modula_gallery_type_check', function ( event, backbone, location, type ) {

	if ( 'slider' == type ) {

		// If resizeble is enable we will destroy it
		if ( backbone.isResizeble ) {
			backbone.disableResizeble();
		}

		// If sortable is not enabled, we will initialize it.
		if ( ! backbone.isSortable ) {
			backbone.enableSortable();
		}

		backbone.helperGridContainer.addClass('modula-guidelines-display');
		backbone.helperGridContainer.find( '.modula-helper-guidelines-wrapper' ).hide();
		backbone.container.removeClass( 'modula-custom-grid' ).addClass( 'modula-creative-gallery' );
		backbone.helperGrid.hide();
		
		backbone.container.sortable( {
			items               : '.modula-single-image',
			cursor              : 'move',
			forcePlaceholderSize: true,
			placeholder         : 'modula-single-image-placeholder',
			stop                : function ( event, ui ) {
				var itemsIDs = backbone.container.sortable( 'toArray' );
				itemsIDs.forEach( function ( itemID, i ) {
					let id = "#" + itemID;
					jQuery( id ).trigger( 'modula:updateIndex', {'index': i} );
				} );
			}
		} );
		backbone.$el.removeClass( 'modula-resizer-enabled' );
	}

} );