<?php
/**
 * Plugin Name: Modula - Slider
 * Plugin URI: https://wp-modula.com/
 * Description: Create a Slider from Modula Images.
 * Author: WPChill
 * Author URI: https://www.wpchill.com/
 * Version: 1.1.4
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'MODULA_SLIDER_VERSION', '1.1.4' );
define( 'MODULA_SLIDER_PATH', plugin_dir_path( __FILE__ ) );
define( 'MODULA_SLIDER_URL', plugin_dir_url( __FILE__ ) );
define( 'MODULA_SLIDER_FILE', __FILE__ );
define( 'MODULA_SLIDER_TRANSLATE', dirname( plugin_basename( __FILE__ ) ) . '/languages' );

require_once MODULA_SLIDER_PATH . 'includes/class-modula-slider.php';
require_once MODULA_SLIDER_PATH . 'includes/class-modula-albums-slider.php';

// Load the main plugin class.
add_action('plugins_loaded','run_modula_slider', 105 );
function run_modula_slider(){
	if ( ! class_exists( 'Modula_PRO' ) ) {
		add_action( 'admin_notices', 'modula_addons_missing_pro_notice' );
		return;
	}

    $modula_slider = Modula_Slider::get_instance();
    $modula_albums_slider = Modula_Albums_Slider::get_instance();

}

if ( ! function_exists( 'modula_addons_missing_pro_notice' ) ) {
	function modula_addons_missing_pro_notice() {
		?>
		<div id="modula-missing-pro-notice" class="notice notice-success is-dismissible" style="margin-top:30px;">
			<p><?php esc_html_e( 'In order for Modula addons to work Modula PRO addon must be installed and activated.', 'modula-roles' ); ?></p>

		</div>
		<?php
	}
}