(function( $, modula ){
    "use strict"
	var modulaVideoConditions = Backbone.Model.extend({

		initialize: function( args ){

			var rows = jQuery('.modula-settings-container tr[data-container]');
			this.set( 'rows', rows );

			this.initEvents();
			this.initValues();

		},

		initValues: function(){
			this.changedType(false, wp.Modula.Settings.get('type'));
			this.changedShowVideoIcon(false, wp.Modula.Settings.get('show-video-icon'));
			this.changedCustomIcon(false, wp.Modula.Settings.get('use-custom-icon'));

		},

		initEvents: function(){
			this.listenTo(wp.Modula.Settings,'change:type', this.changedType);
			this.listenTo(wp.Modula.Settings, 'change:show-video-icon', this.changedShowVideoIcon);
			this.listenTo(wp.Modula.Settings, 'change:use-custom-icon', this.changedCustomIcon);

			this.listenTo(wp.Modula.Settings, 'toggleAccordeon:show-video-icon', this.toggleShowVideoIcon);

		},

		changedType: function( settings, value ) {
			let rows = this.get( 'rows' );

			if( 'slider' == value ) {
				rows.filter('[data-container="autoplay-videos"], [data-container="show-video-icon"]').hide();
				rows.filter('[data-container="enableVideosOnSlider"]').show();
			}else if( 'custom-grid' == value ) {
				rows.filter('[data-container="autoplay-videos"], [data-container="show-video-icon"]').show();
				rows.filter('[data-container="enableVideosOnSlider"]').hide();
			}else if ( 'creative-gallery' == value ) {
				rows.filter('[data-container="autoplay-videos"], [data-container="show-video-icon"]').show();
				rows.filter('[data-container="enableVideosOnSlider"]').hide();
			}else if ('grid' == value ) {
				rows.filter('[data-container="autoplay-videos"], [data-container="show-video-icon"]').show();
				rows.filter('[data-container="enableVideosOnSlider"]').hide();
			}
		},

		changedShowVideoIcon: function( settings, value ){
			var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="show-video-icon"]'),
            children  = currentRow.data( 'children' );

			jQuery.each(children, function(index, item) {

				var child = jQuery('[data-container="'+item+'"]');

				if ( 0 == value && currentRow.hasClass( 'modula_accordion_open' )) {
					child.setting_state( this, 'off');
					child.show();
				}else if( 0 == value ){
					child.hide();
				}else{
					child.css('opacity', '1');
					child.find('input, textarea, select, button').removeAttr('disabled');
					child.show();
				}

			});

			if( '1' == wp.Modula.Settings.get('use-custom-icon') ){
				rows.filter( '[data-container="custom-video-icon"]').show();
				rows.filter( '[data-container="video-icon-color"]').hide();
			}else{
				rows.filter( '[data-container="custom-video-icon"]').hide();
				rows.filter( '[data-container="video-icon-color"]').show();
			}

			if( 1 == value ) {
				currentRow.addClass( 'modula_accordion_open' );
			}
			this.changedCustomIcon(false, wp.Modula.Settings.get('use-custom-icon'));
		},

		changedCustomIcon: function( settings, value ) {
			let rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="show-video-icon"]');

			if( '1' == value ) {
				if( '0' == wp.Modula.Settings.get('show-video-icon') && currentRow.hasClass( 'modula_accordion_open' ) ) {

					rows.filter( '[data-container="custom-video-icon"]').setting_state( this, 'off');
					rows.filter( '[data-container="custom-video-icon"]').show();
				}else if( '0' == wp.Modula.Settings.get('show-video-icon') && !currentRow.hasClass( 'modula_accordion_open' ) ){

					rows.filter( '[data-container="custom-video-icon"]').hide();
				}else {

					rows.filter( '[data-container="custom-video-icon"]').show();
				}
				rows.filter( '[data-container="video-icon-color"]').hide();
			}else{

				rows.filter( '[data-container="custom-video-icon"]').hide();
				if( '0' == wp.Modula.Settings.get('show-video-icon') && currentRow.hasClass( 'modula_accordion_open' ) ) {
					
					rows.filter( '[data-container="video-icon-color"]').setting_state( this, 'off');
					rows.filter( '[data-container="video-icon-color"]').show();
				} else if( '0' == wp.Modula.Settings.get('show-video-icon') && !currentRow.hasClass( 'modula_accordion_open' ) ){

					rows.filter( '[data-container="video-icon-color"]').hide();
				} else{
					
					rows.filter( '[data-container="video-icon-color"]').show();
				}
			}
		},
		toggleShowVideoIcon: function( ){
			var rows = this.get( 'rows' );

			if( '1' == wp.Modula.Settings.get('use-custom-icon') ){

				rows.filter( '[data-container="video-icon-color"]').hide();
			}else{

				rows.filter( '[data-container="custom-video-icon"]').hide();
			}
		}

	});

	$(document).ready(function(){
		new modulaVideoConditions();

		

		var modulaVideoFrame = new wp.media({
            title: 'Select a image to upload',
            button: {
                text: 'Use this image',
            },
            multiple: false // Set to true to allow multiple files to be selected
        });

        modulaVideoFrame.on('select', function () {
            // We set multiple to false so only get one image from the uploader
            var attachment = modulaVideoFrame.state().get('selection').first().toJSON();

            var att_id = attachment.id,
                att_src = attachment.url;

            if ( 'undefined' != typeof attachment.sizes.thumbnail ) {
                att_src = attachment.sizes.thumbnail.url;
            }

            $('#custom-video-icon').val( att_id );
            $('.modula_custom_video_icon_preview').html( '<img src="' + att_src + '">' );

            $( '#upload_video_icon' ).hide();
            $( '#replace_video_icon' ).show();
			$( '#delete_video_icon' ).show();
			
		});

			$( '#upload_video_icon' ).click(function( event ){
				event.preventDefault();
				modulaVideoFrame.open();
			});
	
			$( '#replace_video_icon' ).click(function( event ){
				event.preventDefault();
				modulaVideoFrame.open();
			});
	
			$( '#delete_video_icon' ).click(function( event ){
				event.preventDefault();
	
				$('#custom-video-icon').val( 0 );
				$('.modula_custom_video_icon_preview').html( '' );
	
				$( '#upload_video_icon' ).show();
				$( '#replace_video_icon' ).hide();
				$( '#delete_video_icon' ).hide();
	
			});

    });


}( jQuery, wp.Modula ))