(function( $ ){
    "use strict";

    var modulaDefaultsWatermarkConditions = Backbone.Model.extend({

        initialize: function( args ){

            var rows = jQuery('.modula-settings-container #modula-watermark tr[data-container]'),
                modulaWatermark = jQuery( '[data-container="watermark_apply_to_existing_images"] .modula-watermark-container' );

            this.set( 'rows', rows );
            this.set( 'modula-watermark', modulaWatermark );
            this.set( 'needSave', false );

            this.initEvents();
            this.initValues();

        },

        initEvents: function(){

            var modulaWatermarkContainer = this.get( 'modula-watermark' ),
                modulaWatermark = this;

            this.listenTo( wp.ModulaDefaults.Settings, 'change:enable_watermark', this.enableWatermark );
            this.listenTo( wp.ModulaDefaults.Settings, 'change:custom_settings_watermark', this.showCustomSettings );
            this.listenTo( wp.ModulaDefaults.Settings, 'change', this.showSaveNotice );

            modulaWatermarkContainer.on( 'click', '.button', function( event ){

                var button = $(this);

                event.preventDefault();
                if ( modulaWatermark.get( 'needSave' ) ) {
                    var saveNotice = modulaWatermarkContainer.find( '.modula-watermark-error' ).data( 'msg' );

                    modulaWatermarkContainer.find( '.button' ).addClass( 'disabled' );
                    modulaWatermarkContainer.find( '.button' ).attr( 'disabled', 'disabled' );

                    modulaWatermarkContainer.find( '.modula-watermark-error' ).html( saveNotice );

                    return;
                }

                button.addClass( 'updating-message' );
                var post_id = $('form #post_ID').val(),
                    data = {
                        'action'  : 'modula_apply_watermark',
                        'gallery' : post_id,
                    };

                $.post(ajaxurl, data, function ( response ) {
                    modulaWatermarkContainer.find( '.modula-watermark-error' ).html( response );
                    button.removeClass( 'updating-message' );
                });

            });


        },

        showSaveNotice: function(){

            var modulaWatermark = this.get( 'modula-watermark' ),
                saveNotice = modulaWatermark.find( '.modula-watermark-error' ).data( 'msg' );
            this.set( 'needSave', true );

            modulaWatermark.find( '.button' ).addClass( 'disabled' );
            modulaWatermark.find( '.button' ).attr( 'disabled', 'disabled' );

            modulaWatermark.find( '.modula-watermark-error' ).html( saveNotice );

        },

        initValues: function(){

			this.enableWatermark(false, wp.ModulaDefaults.Settings.get('enable_watermark'));
			this.showCustomSettings(false, wp.ModulaDefaults.Settings.get('custom_settings_watermark'));

        },

        enableWatermark: function( settings, value ){
            var rows = this.get( 'rows' );

            if( '1' == value ) {
                rows.filter('[data-container="custom_settings_watermark"], [data-container="watermark_apply_to_existing_images"]').show();
                if( '1' == wp.ModulaDefaults.Settings.get('custom_settings_watermark') ) {
                    rows.filter( '[data-container="watermark_image"], [data-container="watermark_position"], [data-container="watermark_margin"], [data-container="watermark_image_dimension_width"], [data-container="watermark_image_dimension_height"]').show();
                }else {
                    rows.filter( '[data-container="watermark_image"], [data-container="watermark_position"], [data-container="watermark_margin"], [data-container="watermark_image_dimension_width"], [data-container="watermark_image_dimension_height"]').hide();
                }
            } else {
                rows.filter('[data-container="custom_settings_watermark"], [data-container="watermark_apply_to_existing_images"]').hide();
                rows.filter( '[data-container="watermark_image"], [data-container="watermark_position"], [data-container="watermark_margin"], [data-container="watermark_image_dimension_width"], [data-container="watermark_image_dimension_height"]').hide();
            }

        },

        showCustomSettings: function( settings, value ){
            var rows = this.get( 'rows' );

            if( '1' == value ) {
                if( '1' == wp.ModulaDefaults.Settings.get('enable_watermark') ) {
                    rows.filter( '[data-container="watermark_image"], [data-container="watermark_position"], [data-container="watermark_margin"], [data-container="watermark_image_dimension_width"], [data-container="watermark_image_dimension_height"]').show();
                }else {
                    rows.filter( '[data-container="watermark_image"], [data-container="watermark_position"], [data-container="watermark_margin"], [data-container="watermark_image_dimension_width"], [data-container="watermark_image_dimension_height"]').hide();
                }
            }else {
                rows.filter('[data-container="watermark_image"], [data-container="watermark_position"], [data-container="watermark_margin"], [data-container="watermark_image_dimension_width"], [data-container="watermark_image_dimension_height"]').hide();
            }
        },

    });

    $( document ).ready(function(){

        // Hide Settings
        new modulaDefaultsWatermarkConditions();

	    var modulaWatermarkFrame = new wp.media( {
		    title:    'Select a image to upload',
		    button:   {
			    text: 'Use this image',
		    },
		    multiple: false // Set to true to allow multiple files to be selected
	    } );

	    modulaWatermarkFrame.on( 'select', function () {
		    // We set multiple to false so only get one image from the uploader
		    var attachment = modulaWatermarkFrame.state().get( 'selection' ).first().toJSON();

		    var att_id  = attachment.id,
		        att_src = attachment.url;

		    $( '#watermark_image' ).val( att_id );
		    $( '.modula_watermark_image_preview' ).html( '<img src="' + att_src + '">' );

		    $( '#upload_watermark_file' ).hide();
		    $( '#replace_watermark_file' ).show();
		    $( '#delete_watermark_file' ).show();

	    } );

	    $( '#upload_watermark_file' ).click( function ( event ) {
		    event.preventDefault();
		    modulaWatermarkFrame.open();
	    } );

	    $( '#replace_watermark_file' ).click( function ( event ) {
		    event.preventDefault();
		    modulaWatermarkFrame.open();
	    } );

	    $( '#delete_watermark_file' ).click( function ( event ) {
		    event.preventDefault();

		    $( '#watermark_image' ).val( 0 );
		    $( '.modula_watermark_image_preview' ).html( '' );

		    $( '#upload_watermark_file' ).show();
		    $( '#replace_watermark_file' ).hide();
		    $( '#delete_watermark_file' ).hide();

	    } );

    });

})( jQuery );