(function( $ ){
	"use strict";

	
    $( document ).ready(function(){

    	var modulaWatermarkFrame = new wp.media({
	        title: 'Select a image to upload',
	        button: {
	            text: 'Use this image',
	        },
	        multiple: false	// Set to true to allow multiple files to be selected
	    });

	    modulaWatermarkFrame.on('select', function () {
	        // We set multiple to false so only get one image from the uploader
	        var attachment = modulaWatermarkFrame.state().get('selection').first().toJSON();

	        var att_id = attachment.id,
	        	att_src = attachment.url;

	        $('.modula-image-holder input[name="modula_watermark[watermark_image]"]').val( att_id );
	        $('.modula-image-holder .modula-image').html( '<img src="' + att_src + '">' );

	        $( '#modula-watermark-upload' ).hide();
	        $( '#modula-watermark-replace' ).show();
	        $( '#modula-watermark-delete' ).show();

	    });

    	$( '#modula-watermark-upload' ).click(function( event ){
			event.preventDefault();
			modulaWatermarkFrame.open();
		});

		$( '#modula-watermark-replace' ).click(function( event ){
			event.preventDefault();
			modulaWatermarkFrame.open();
		});

		$( '#modula-watermark-delete' ).click(function( event ){
			event.preventDefault();

			$('.modula-image-holder input[name="modula_watermark[watermark_image]"]').val( 0 );
	        $('.modula-image-holder .modula-image').html( '' );

	        $( '#modula-watermark-upload' ).show();
	        $( '#modula-watermark-replace' ).hide();
	        $( '#modula-watermark-delete' ).hide();

		});

		// Iinit slider
		var input = $('.modula-ui-slider-container input');
		jQuery( '#modula_watermark_slider' ).slider({
            value: input.val(),
            min: 0,
            max: 50,
            step: 1,
            range: 'min',
            slide: function( event, ui ) {
                input.val( ui.value ).trigger( 'change' );
            }
        });

    });
	

})( jQuery );