(function( $ ){
    "use strict";

    var modulaWatermarkConditions = Backbone.Model.extend({

        initialize: function( args ){

            var rows = jQuery('.modula-settings-container #modula-watermark tr[data-container]'),
                modulaWatermark = jQuery( '[data-container="watermark_apply_to_existing_images"] .modula-watermark-container.apply_watermark' ),
                modulaRemoveWatermark = jQuery( '[data-container="watermark_remove_watermark"] .modula-watermark-container.remove_watermark' );

            this.set( 'rows', rows );
            this.set( 'modula-watermark', modulaWatermark );
            this.set( 'modula-remove-watermark', modulaRemoveWatermark );
            this.set( 'needSave', false );

            this.initEvents();
            this.initValues();

        },

        initEvents: function(){

            var modulaWatermarkContainer = this.get( 'modula-watermark' ),
                modulaWatermark = this,
                modulaRemoveWatermarkContainer = this.get( 'modula-remove-watermark' ),
                instance = this;

            this.listenTo( wp.Modula.Settings, 'change:enable_watermark', this.enableWatermark );
            this.listenTo( wp.Modula.Settings, 'change:custom_settings_watermark', this.showCustomSettings );
            this.listenTo( wp.Modula.Settings, 'change', this.showSaveNotice );

            modulaWatermarkContainer.on( 'click', '.button', function( event ){

                var button = $(this);

                event.preventDefault();

                if(button.hasClass('disabled')){
                    return;
                }

                if ( modulaWatermark.get( 'needSave' ) ) {
                    var saveNotice = modulaWatermarkContainer.find( '.modula-watermark-error' ).data( 'msg' );

                    modulaWatermarkContainer.find( '.button' ).addClass( 'disabled' );
                    modulaWatermarkContainer.find( '.button' ).attr( 'disabled', 'disabled' );

                    button.next( '.modula-watermark-error' ).html( saveNotice );

                    return;
                }

                if( modulaHelper['items'] <= 0 ){
                    button.next( '.modula-watermark-error' ).html( modulaWmMessages.err_no_images );
                    return;
                }

                button.addClass( 'updating-message' );
                
                instance.ajax_watermark(0, button, instance);


            });

            modulaRemoveWatermarkContainer.on( 'click', '.button', function( event ){

                var button = $(this);

                event.preventDefault();

                if(button.hasClass('disabled')){
                    return;
                }

                if ( modulaWatermark.get( 'needSave' ) ) {
                    var saveNotice = modulaRemoveWatermarkContainer.find( '.modula-watermark-error' ).data( 'msg' );

                    modulaRemoveWatermarkContainer.find( '.button.remove_watermark' ).addClass( 'disabled' );
                    modulaRemoveWatermarkContainer.find( '.button.remove_watermark' ).attr( 'disabled', 'disabled' );

                    button.next( '.modula-watermark-error' ).html( saveNotice );

                    return;
                }

                button.addClass( 'updating-message' );

                instance.ajax_remove_watermark(0, button, instance);

            });

            this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_watermark', this.toggleWatermark);
        },

        ajax_watermark: function( key, button, instance ){

            button.next( '.modula-watermark-error' ).html( modulaWmMessages.upd_images.replace( '%s1', ( key + 1 ) ).replace( '%s2', modulaHelper['items'].length ) );
 
            var post_id = $('form #post_ID').val(),
                data = {
                    'action'         : 'modula_apply_single_watermark',
                    'gallery'        : post_id,
                    'modula_image_id': modulaHelper['items'][key]['id'],
                    'nonce'          : watermarkNonce
                };

            $.post(ajaxurl, data, function ( response ) {
                if( (key + 1) != modulaHelper['items'].length){
                    instance.ajax_watermark( (key + 1), button, instance );
                }else{
                    button.next( '.modula-watermark-error' ).html( modulaWmMessages.upd_done );
                    button.removeClass( 'updating-message' );
                }
            });
        },

        ajax_remove_watermark: function( key, button, instance ){

            button.next( '.modula-watermark-error' ).html( modulaWmMessages.restore_images.replace( '%s1', ( key + 1 ) ).replace( '%s2', modulaHelper['items'].length ) );
 
            var post_id = $('form #post_ID').val(),
                data = {
                    'action'         : 'modula_remove_watermark',
                    'gallery'        : post_id,
                    'modula_image_id': modulaHelper['items'][key]['id'],
                    'nonce'          : watermarkNonce
                };

            $.post(ajaxurl, data, function ( response ) {
                if( (key + 1) != modulaHelper['items'].length){
                    instance.ajax_remove_watermark( (key + 1), button, instance );
                }else{
                    button.next( '.modula-watermark-error' ).html( modulaWmMessages.restore_done );
                    button.removeClass( 'updating-message' );
                }
            });
        },
        showSaveNotice: function(){

            var modulaWatermark = this.get( 'modula-watermark' ),
                saveNotice = modulaWatermark.find( '.modula-watermark-error' ).data( 'msg' );
            this.set( 'needSave', true );

            modulaWatermark.find( '.button' ).addClass( 'disabled' );
            modulaWatermark.find( '.button' ).attr( 'disabled', 'disabled' );

            modulaWatermark.find( '.modula-watermark-error' ).html( saveNotice );

        },

        initValues: function(){

			this.enableWatermark(false, wp.Modula.Settings.get('enable_watermark'));
			this.showCustomSettings(false, wp.Modula.Settings.get('custom_settings_watermark'));

        },

        enableWatermark: function( settings, value){

            var rows = this.get( 'rows' ),
                currentRow = rows.filter('[data-container="enable_watermark"]'),
                children  = currentRow.data( 'children' );
    
            jQuery.each(children, function(index, item) {
    
                var child = jQuery('[data-container="'+item+'"]');
    
                if ( 0 == value && currentRow.hasClass( 'modula_accordion_open' )) {
                    child.setting_state( this, 'off');
                    child.show();
                }else if( 0 == value ){
                    child.hide();
                }else{
                    child.css('opacity', '1');
                    child.find('input, textarea, select, button').removeAttr('disabled');
                    child.show();
                }
    
            });
    
            if ( '1' == value ) {
    
                currentRow.addClass( 'modula_accordion_open' );
    
            }
    
            this.showCustomSettings(false, wp.Modula.Settings.get('custom_settings_watermark'));
        },
    
        toggleWatermark: function(){
           
            var rows = this.get( 'rows' ),
                currentRow = rows.filter('[data-container="enable_watermark"]'),
                emailRow = rows.filter('[data-container="custom_settings_watermark"]'),
                children  = emailRow.data( 'children' );
    
            if ( ! currentRow.hasClass( 'modula_accordion_open' ) ) {
                jQuery.each(children, function(index, item) {
                    var child = jQuery('[data-container="'+item+'"]');
                    child.hide();
                });
    
                if ( emailRow.hasClass( 'modula_accordion_open' ) ) {
                    emailRow.removeClass( 'modula_accordion_open' )
                }
    
            }
    
            if ( currentRow.hasClass( 'modula_accordion_open' ) && '1' == wp.Modula.Settings.get('custom_settings_watermark')) {
                jQuery.each(children, function(index, item) {
                    
                    var child = jQuery('[data-container="'+item+'"]');
                    if( '1' != wp.Modula.Settings.get('enable_watermark') ){
                        child.show();
                        child.setting_state( this, 'off');
                    }else{
                        child.show();
                    }

                });
    
            }
            
        },


        showCustomSettings: function( settings, value ) {
            var rows = this.get( 'rows' ),
                currentRow = rows.filter('[data-container="custom_settings_watermark"]'),
                children  = currentRow.data( 'children' );
    
            jQuery.each(children, function(index, item) {
    
                var child = jQuery('[data-container="'+item+'"]');
    
                if ( (0 == value || 0 == wp.Modula.Settings.get( 'enable_watermark')) && currentRow.hasClass( 'modula_accordion_open' )) {
                    child.setting_state( this, 'off');
                    child.show();
                }else if( 0 == value || 0 == wp.Modula.Settings.get( 'enable_watermark')){
                    child.hide();
                }else{
                    child.css('opacity', '1');
                    child.find('input, textarea, select, button').removeAttr('disabled');
                    child.show();
                }
            });
    
            if ( '1' == value && '1' == wp.Modula.Settings.get( 'enable_watermark') ) {
                currentRow.addClass( 'modula_accordion_open' );
            }
        },


    });

    $( document ).ready(function(){

        // Hide Settings
        new modulaWatermarkConditions();

        var modulaWatermarkFrame = new wp.media({
            title: 'Select a image to upload',
            button: {
                text: 'Use this image',
            },
            multiple: false // Set to true to allow multiple files to be selected
        });

        modulaWatermarkFrame.on('select', function () {
            // We set multiple to false so only get one image from the uploader
            var attachment = modulaWatermarkFrame.state().get('selection').first().toJSON();

            var att_id = attachment.id,
                att_src = attachment.url;

            $('#watermark_image').val( att_id );
            $('.modula_watermark_image_preview').html( '<img src="' + att_src + '">' );

            $( '#upload_watermark_file' ).hide();
            $( '#replace_watermark_file' ).show();
            $( '#delete_watermark_file' ).show();

        });

        $( '#upload_watermark_file' ).click(function( event ){
            event.preventDefault();
            modulaWatermarkFrame.open();
        });

        $( '#replace_watermark_file' ).click(function( event ){
            event.preventDefault();
            modulaWatermarkFrame.open();
        });

        $( '#delete_watermark_file' ).click(function( event ){
            event.preventDefault();

            $('#watermark_image').val( 0 );
            $('.modula_watermark_image_preview').html( '' );

            $( '#upload_watermark_file' ).show();
            $( '#replace_watermark_file' ).hide();
            $( '#delete_watermark_file' ).hide();

        });

    });

})( jQuery );