<?php

$settings = get_option( 'modula_watermark', array(
	'watermark_image' => 0,
	'watermark_position' => 'bottom_right',
	'watermark_margin'  => 10,
    'watermark_image_dimension_width'  => 0,
    'watermark_image_dimension_height'  => 0,
	'watermark_enable_backup' => 1
) );

$values = array(
	'top_left'     => esc_html__( 'Top left', 'modula-watermark' ),
	'top_right'    => esc_html__( 'Top right', 'modula-watermark' ),
	'bottom_right' => esc_html__( 'Bottom right', 'modula-watermark' ),
	'bottom_left'  => esc_html__( 'Bottom left', 'modula-watermark' ),
	'center'       => esc_html__( 'Center', 'modula-watermark' ),
);

$style = array(
	'upload'  => '',
	'replace' => 'display:none;',
	'delete'  => 'display:none;',
);

if ( 0 != absint( $settings['watermark_image'] ) ) {
	$style['upload'] = 'display:none;';
	$style['replace'] = '';
	$style['delete'] = '';
}



?>
<style type="text/css">
	/* Toggles */
	.modula-toggle {
	    position: relative;
	    position: relative;
	    user-select: none;
	    display: inline-block;
	}

	.modula-toggle__items {
	  box-sizing: border-box;
	  display: inline-block;
	    position: relative;
	}
	.modula-toggle__items > * {
	  box-sizing: inherit;
	}

	.modula-toggle__input[type=checkbox] {
	  border-radius: 2px;
	  border: 2px solid #6c7781;
	  margin-right: 12px;
	  transition: none;
	  height: 100%;
	  left: 0;
	  top: 0;
	  margin: 0;
	  padding: 0;
	  opacity: 0;
	  position: absolute;
	  width: 100%;
	  z-index: 1; }

	.modula-toggle__track {
	  background-color: #fff;
	  border: 2px solid #6c7781;
	  border-radius: 9px;
	  display: inline-block;
	  height: 18px;
	  width: 36px;
	  vertical-align: top;
	  transition: background .2s ease; }

	.modula-toggle__thumb {
	  background-color: #6c7781;
	  border: 5px solid #6c7781;
	  border-radius: 50%;
	  display: block;
	  height: 10px;
	  width: 10px;
	  position: absolute;
	  left: 4px;
	  top: 4px;
	  transition: transform .2s ease; }

	.modula-toggle__off {
	  position: absolute;
	  right: 6px;
	  top: 6px;
	  color: #6c7781;
	  fill: currentColor; }

	.modula-toggle__on {
	  position: absolute;
	  top: 6px;
	  left: 8px;
	  border: 1px solid #fff;
	  outline: 1px solid transparent;
	  outline-offset: -1px;
	  display: none; }

	.modula-toggle__input[type=checkbox]:checked + .modula-toggle__items .modula-toggle__track {
	  background-color: #11a0d2;
	  border: 9px solid transparent; }

	.modula-toggle__input[type=checkbox]:checked + .modula-toggle__items .modula-toggle__thumb {
	  background-color: #fff;
	  border-width: 0;
	  transform: translateX(18px); }

	.modula-toggle__input[type=checkbox]:checked + .modula-toggle__items .modula-toggle__off {
	  display: none; }

	.modula-toggle__input[type=checkbox]:checked + .modula-toggle__items .modula-toggle__on {
	  display: inline-block; }
	/* UI Slider */
	.slider-container {
		position: relative;
		height: 2px;
		padding: 10px 0;
		width: 25em;
		box-sizing: border-box;
	  margin-bottom: 10px;
	  display: flex;
	  display: flex;
	    justify-content: space-between;
	    align-items: center;
	}
	.slider-container input[type="text"] {
	    border: none;
	    text-align: center;
	    padding: 2px;
	    margin: 0 20px 0 0;
	    font-size: 12px;
	    color: #333;
	    border-radius: 10px;
	    background-color: #fff;
	    -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.16);
	    -moz-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.16);
	    box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.16);
	    width: 40px;
	    height: 22px;
	    cursor: default;
	}
    .slider-container input.watermark-input-text {
        border-radius:0px;
    }
    .slider-container .watermark-double-size {
        display:inline-block;
    }
	.slider-container .ui-slider {
	    position: relative;
	    text-align: left;
	    height: 2px;
	    border-radius: 3px;
	    border: none;
	    display: block;
	    width: 100%;
	    background: #d6d6d6;
	    -webkit-box-sizing: border-box;
	    -moz-box-sizing: border-box;
	    box-sizing: border-box;
	}
	.slider-container .ui-slider .ui-slider-handle {
		position: absolute;
		z-index: 2;
		top: -10px;
		cursor: default;
		-ms-touch-action: none;
		touch-action: none;
		width: 18px;
		height: 18px;
		-webkit-border-radius: 9px;
		-moz-border-radius: 9px;
		border-radius: 9px;
		background-color: #fff;
		-webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
		-moz-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
		box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
		border: solid 1px #d7d7d7;
		transform: translateX(-50%);
	}
	.slider-container .ui-slider .ui-slider-range {
		position: absolute;
		z-index: 1;
		font-size: 0.7em;
		display: block;
		border: 0;
		background-position: 0 0;
		background: #57a7c9;
		top: 0;
		bottom: 0;
	}
    .modula-watermark-table th {
        min-width:250px;
    }
    .modula-image-holder .modula-image img {
    	max-width: 100%;
    	max-height: 200px;
    }
</style>
<div class="row">
	<form method="post" action="options.php">

		<?php settings_fields('modula_watermark'); ?>

		<table class="form-table modula-watermark-table">
			<tbody>
				<tr valign="top">
					<th scope="row" valign="top">
						<?php _e('Watermark Image', 'modula-watermark'); ?>
                        <div class="tab-header-tooltip-container modula-tooltip"><span>[?]</span>
                            <div class="tab-header-description modula-tooltip-content">
                                <?php esc_html_e( 'The image to use as the watermark. This will be applied on images from your galleries', 'modula-watermark' ) ?>
                            </div>
                        </div>
					</th>
					<td>
						<div class="modula-image-holder">
							<input type="hidden" name="modula_watermark[watermark_image]" value="<?php echo absint( $settings['watermark_image'] ) ?>" id="modula-watermark-image">
							<div class="modula-image">
								<?php
								$image = wp_get_attachment_image_src( $settings['watermark_image'], 'full' );
								if ( $image ) {
									echo '<img src="' . $image[0] . '">';
								}
								?>
							</div>
							<div class="modula-image-actions">
								<button id="modula-watermark-upload" class="button button-primary" style="<?php echo $style['upload'] ?>"><?php esc_html_e( 'Upload Image', 'modula-watermark' ) ?></button>
								<button id="modula-watermark-replace" class="button button-primary" style="<?php echo $style['replace'] ?>"><?php esc_html_e( 'Replace Image', 'modula-watermark' ) ?></button>
								<button id="modula-watermark-delete" class="button" style="<?php echo $style['delete'] ?>"><?php esc_html_e( 'Delete Image', 'modula-watermark' ) ?></button>
							</div>
						</div>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row" valign="top">
						<?php _e('Watermark Position', 'modula-watermark'); ?>
                        <div class="tab-header-tooltip-container modula-tooltip"><span>[?]</span>
                            <div class="tab-header-description modula-tooltip-content">
                                <?php esc_html_e( 'Choose a position where the watermark will be applied.', 'modula-watermark' ) ?>
                            </div>
                        </div>
					</th>
					<td>
						<select name="modula_watermark[watermark_position]">
							<?php
							foreach ( $values as $value => $label ) {
								echo '<option value="' . $value . '" ' . selected( $value, $settings['watermark_position'], false ) . '>' . $label . '</option>';
							}
							?>
						</select>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row" valign="top">
						<?php _e('Watermark Margin', 'modula-watermark'); ?>
                        <div class="tab-header-tooltip-container modula-tooltip"><span>[?]</span>
                            <div class="tab-header-description modula-tooltip-content">
                                <?php esc_html_e( 'Set the space between the watermark and the margins of the image.', 'modula-watermark' ) ?>
                            </div>
                        </div>
					</th>
					<td>
						<div class="slider-container modula-ui-slider-container">
							<input readonly="readonly" name="modula_watermark[watermark_margin]" type="text" class="rl-slider modula-ui-slider-input" value="<?php echo absint( $settings['watermark_margin'] ) ?>"/>
							<div id="modula_watermark_slider" class="ss-slider modula-ui-slider"></div>
						</div>
					</td>
				</tr>
                <tr valign="top">
                    <th scope="row" valign="top">
                        <?php _e('Watermark Image Dimension', 'modula-watermark'); ?>
                        <div class="tab-header-tooltip-container modula-tooltip"><span>[?]</span>
                            <div class="tab-header-description modula-tooltip-content">
                                <?php esc_html_e( 'Specify the watermark image dimensions. If one of the sizes (width or height) is "0" or "" and the other is different than "0" or "" the watermark image will be scaled proportionally based on it\'s size. If both values are not empty or not "0" the watermark image will be morphed to the specified sizes.', 'modula-watermark' ) ?>
                            </div>
                        </div>
                    </th>
                    <td>
                        <div class="slider-container modula-ui-slider-container">
                            <label for="modula_watermark[watermark_image_dimension_width]" class="watermark-double-size">
                                <input name="modula_watermark[watermark_image_dimension_width]" class="watermark-input-text" type="text" value="<?php echo isset($settings['watermark_image_dimension_width']) ? esc_attr( $settings['watermark_image_dimension_width'] ) : '0' ?>"/> <span>Width</span>
                            </label>
                            <label for="modula_watermark[watermark_image_dimension_height]" class="watermark-double-size">
                                <input name="modula_watermark[watermark_image_dimension_height]" class="watermark-input-text" type="text" value="<?php echo isset($settings['watermark_image_dimension_height']) ?  esc_attr( $settings['watermark_image_dimension_height'] ) : '0'; ?>"/> <span>Height</span>
                            </label>
                        </div>
                    </td>
                </tr>
			<tr valign="top">
				<th scope="row" valign="top">
					<?php _e('Enable image backup', 'modula-watermark'); ?>
					<div class="tab-header-tooltip-container modula-tooltip"><span>[?]</span>
						<div class="tab-header-description modula-tooltip-content">
							<?php esc_html_e( 'Backup original images so that if you decide to delete the watermark you can restore the original image to your gallery/media library.', 'modula-watermark' ) ?>
						</div>
					</div>
				</th>
				<td>
					<div class="modula-toggle">
						<input class="modula-toggle__input" type="checkbox"
						       data-setting="modula_watermark[watermark_enable_backup]"
						       id=""
						       name="modula_watermark[watermark_enable_backup]"
						       value="1" <?php isset($settings['watermark_enable_backup']) ?  checked(1, $settings['watermark_enable_backup'], true ) : false; ?>>
						<div class="modula-toggle__items">
							<span class="modula-toggle__track"></span>
							<span class="modula-toggle__thumb"></span>
							<svg class="modula-toggle__off" width="6" height="6" aria-hidden="true"
							     role="img"
							     focusable="false"
							     viewBox="0 0 6 6">
								<path d="M3 1.5c.8 0 1.5.7 1.5 1.5S3.8 4.5 3 4.5 1.5 3.8 1.5 3 2.2 1.5 3 1.5M3 0C1.3 0 0 1.3 0 3s1.3 3 3 3 3-1.3 3-3-1.3-3-3-3z"></path>
							</svg>
							<svg class="modula-toggle__on" width="2" height="6" aria-hidden="true"
							     role="img"
							     focusable="false"
							     viewBox="0 0 2 6">
								<path d="M0 0h2v6H0z"></path>
							</svg>
						</div>
					</div>
				</td>
			</tr>
			</tbody>
		</table>
		<?php submit_button(); ?>
	</form>
</div>