jQuery( function () {

	jQuery( document ).on( "modula_fancybox_lightbox_after_show", function (  e, obj, instance, current  ) {

		// Return if we don't have image type
		if('undefined' == typeof instance.$image){
			return;
		}

		var settings      = obj.options.zoom,
		    modulaElevate = instance.$image.data();

		if ( 'undefined' == typeof settings ) {
			return;
		}

		if ( !settings.zoomOnHover ) {

			instance.$image.parents('.modula-fancybox-container').find( '.modula-fancybox-button--zoom' ).off().on( 'click', function ( e ) {

				jQuery( this ).removeAttr( 'data-fancybox-zoom', '' );

				if ( 'undefined' != typeof modulaElevate.ezPlus && jQuery( '.zoomContainer' ).length ) {

					modulaElevate.ezPlus.zoomContainer.remove();
				} else {

					instance.$image.ezPlus( settings );
				}

			} );

			instance.$image.parents('.modula-fancybox-container').find( ".modula-fancybox-button--arrow_right, .modula-fancybox-button--arrow_left" ).on( 'click', function ( e ) {

				if ( 'undefined' != typeof modulaElevate.ezPlus ) {
					modulaElevate.ezPlus.zoomContainer.remove();
				}

			} );

		} else {
			instance.$image.parents('.modula-fancybox-container').find( '.modula-fancybox-button--zoom' ).on( 'click', function ( e ) {

				jQuery( this ).removeAttr( 'data-fancybox-zoom', '' );

			} );

			instance.$image.ezPlus( settings );

			instance.$image.parents('.modula-fancybox-container').find( ".modula-fancybox-button--arrow_right, .modula-fancybox-button--arrow_left" ).on( 'click', function ( e ) {

				if ( 'undefined' != typeof modulaElevate.ezPlus ) {
					modulaElevate.ezPlus.zoomContainer.remove();
				}
			} );

			// Exit elevateZoom when mouse leaving
			jQuery( document ).on( 'mouseleave', '.zoomContainer', function ( e ) {
				e.stopPropagation();
				if('undefined' != typeof instance.$image.data().ezPlus){
					clearTimeout( setTimeout( function() { 
						instance.$image.data().ezPlus.zoomContainer.remove() 
					}, 650) );
				}
			} );

			jQuery( document ).on( 'mouseenter', instance.$image, function ( e ) {
				e.stopPropagation();
				if('undefined' != typeof instance.$image.data().ezPlus.zoomContainer){

					instance.$image.data().ezPlus.zoomContainer.remove() 

				}
			} );

		}

		// Because of zoom window beeing extra large we need to manipulate the width, height and translate of the slide
		if('window' === settings.zoomType && jQuery(window).width() > 1330){

			var $modulaFancybox = jQuery.modulaFancybox.getInstance();
			var window_w = jQuery(window).width();
			var image_w = $modulaFancybox.current.$image.width();
			var image_h = $modulaFancybox.current.$image.height();
			var zoom_w = settings.zoomWindowWidth;
			var diff_w = ( window_w - image_w ) / 2;
			var ratio = image_w / image_h;

			if ( ( window_w - image_w ) / 2 < zoom_w ) {

				$modulaFancybox.current.$content.css( {
					'width':     image_w - ( zoom_w - diff_w ),
					'height':    ( image_w - ( zoom_w - diff_w ) ) / ratio,
					'transform': 'translate(' + zoom_w + 'px,44px)'
				} );
			}
		}

		instance.$content.parents('.modula-fancybox-inner').find('.modula-fancybox-toolbar a, .modula-fancybox-toolbar button').not('.modula-fancybox-button--zoom,.download-all,.modula-fancybox-button--close').click(function(){
			jQuery('.zoomContainer').remove();
		});

	} );

	// Need to destroy elevateZoom before we close FancyBox
	jQuery( document ).on( "modula_fancybox_lightbox_before_close", function ( e, obj, instance, current ) {
		// This will effectively turn off the ElevateZoom (there is no "destroy" with this JS lib)

		// Return if we don't have image type
		if('undefined' == typeof instance.$image){
			return;
		}

		if ( 'undefined' != typeof instance.$image.data().ezPlus ) {
			instance.$image.data().ezPlus.zoomContainer.remove();
		}

	} );

} );

