(function (Modula) {
    "use strict";

    let modulaZoomAlbumConditions = Backbone.Model.extend({
        initialize: function (args) {
            let rows = jQuery(".modula-settings-container tr[data-container]");
            let tabs = jQuery(".modula-tabs .modula-tab");
            this.set("rows", rows);
            this.set("tabs", tabs);

            this.initEvents();
            this.initValues();
        },

        initValues: function () {
            this.changedZoom(false, wp.Modula.Settings.get("enable_zoom_albums"));
            this.changedZoomType(false, wp.Modula.Settings.get("zoom_type_albums"));
        },

        initEvents: function () {
            this.listenTo(
                wp.Modula.Settings,
                "change:enable_zoom_albums",
                this.changedZoom
            );
            this.listenTo(
                wp.Modula.Settings,
                "change:zoom_type_albums",
                this.changedZoomType
            );

            this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_zoom_albums', this.toggleZoom);
        },


        changedZoom: function (settings, value) {
            var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_zoom_albums"]'),
            children  = currentRow.data( 'children' );

            jQuery.each(children, function(index, item) {

                var child = jQuery('[data-container="'+item+'"]');

                if ( 0 == value && currentRow.hasClass( 'modula_accordion_open' )) {
                    child.setting_state( this, 'off');
                    child.show();
                }else if( 0 == value ){
                    child.hide();
                }else{
                    child.css('opacity', '1');
                    child.find('input, textarea, select, button').removeAttr('disabled');
                    child.show();
                }
            });

            if ("1" == value) {
                currentRow.addClass( 'modula_accordion_open' );
            }
            this.changedZoomType(false, wp.Modula.Settings.get('zoom_type_albums'));
        },

		toggleZoom: function(){

			var rows = this.get( 'rows' ),
				value = wp.Modula.Settings.get('zoom_type_albums'),
				parentRow = rows.filter('[data-container="enable_zoom_albums"]'),
                children = rows.filter('[data-container="zoom_on_hover_albums"], [data-container="zoom_effect_albums"], [data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"],[data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"]');

                if( !parentRow.hasClass( 'modula_accordion_open' ) ){
                    children.hide();
                }else if( '1' == wp.Modula.Settings.attributes.enable_zoom_albums ){
                    children.show();
                    if( 'window' == value && '1' == wp.Modula.Settings.attributes.enable_zoom_albums ) {
                        rows.filter('[data-container="zoom_lens_size_albums"]').setting_state( this, 'off');
        
                        jQuery( 'option[value="easing_albums"]').show();
                    } else if ( 'inner' == value && '1' == wp.Modula.Settings.attributes.enable_zoom_albums ) {
                        rows.filter('[data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"], [data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"],[data-container="zoom_effect_albums"]').setting_state( this, 'off');
                        rows.filter('[data-container="zoom_type_albums"], [data-container="zoom_on_hover_albums"]').setting_state( this, 'on');
                    } else if( 'lens' == value && '1' == wp.Modula.Settings.attributes.enable_zoom_albums ) {
                        rows.filter('[data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"]').setting_state( this, 'off');
                        rows.filter('[data-container="zoom_on_hover_albums"], [data-container="zoom_effect_albums"], [data-container="zoom_type_albums"], [data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"],[data-container="zoom_effect_albums"]').setting_state( this, 'on');
                        jQuery( 'option[value="easing_albums"]').setting_state( this, 'off');
                    }
                }else{
                    children.show();
                    children.setting_state( this, 'off');
                }
	
	
		},

        changedZoomType: function( settings, value ) {
            let rows = this.get("rows"),
                tabs = this.get("tabs"),
				parentRow = rows.filter('[data-container="enable_zoom_albums"]');

            if( '1' != wp.Modula.Settings.attributes.enable_zoom_albums ){
                if( parentRow.hasClass( 'modula_accordion_open' ) ){
                    rows.filter('[data-container="zoom_effect_albums"], [data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"],[data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"]').show();
                    rows.filter('[data-container="zoom_effect_albums"], [data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"],[data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"]').setting_state( this, 'off');
                }else{
                    rows.filter('[data-container="zoom_effect_albums"], [data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"],[data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"]').hide();
                }
               
            }else{
                rows.filter('[data-container="zoom_effect_albums"], [data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"],[data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"]').show();
                rows.filter('[data-container="zoom_effect_albums"], [data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"],[data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"]').setting_state( this, 'on');
            }

            if( 'window' == value && '1' == wp.Modula.Settings.attributes.enable_zoom_albums ) {
                rows.filter('[data-container="zoom_lens_size_albums"]').setting_state( this, 'off');

                jQuery( 'option[value="easing_albums"]').show();
            } else if ( 'inner' == value && '1' == wp.Modula.Settings.attributes.enable_zoom_albums ) {
                rows.filter('[data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"], [data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"],[data-container="zoom_effect_albums"]').setting_state( this, 'off');
                rows.filter('[data-container="zoom_type_albums"]').setting_state( this, 'on');
            } else if( 'lens' == value && '1' == wp.Modula.Settings.attributes.enable_zoom_albums ) {
                rows.filter('[data-container="zoom_window_position_albums"], [data-container="zoom_window_size_albums"], [data-container="zoom_tint_color_albums"], [data-container="zoom_tint_opacity_albums"]').setting_state( this, 'off');
                rows.filter('[data-container="zoom_effect_albums"], [data-container="zoom_type_albums"], [data-container="zoom_lens_size_albums"], [data-container="zoom_lens_shape_albums"],[data-container="zoom_effect_albums"]').setting_state( this, 'on');
                jQuery( 'option[value="easing_albums"]').setting_state( this, 'off');
            }
        }
    });

    jQuery(document).ready(function () {
        new modulaZoomAlbumConditions();
    });
})(jQuery, wp.Modula);
