(function (Modula) {
    "use strict";

    let modulaZoomConditions = Backbone.Model.extend({
        initialize: function (args) {
            let rows = jQuery(".modula-settings-container tr[data-container]");
            let tabs = jQuery(".modula-tabs .modula-tab");
            this.set("rows", rows);
            this.set("tabs", tabs);

            this.initEvents();
            this.initValues();
        },

        initValues: function () {
            this.changedZoom(false, wp.Modula.Settings.get("enable_zoom"));
            this.changedZoomType(false, wp.Modula.Settings.get("zoom_type"));
        },

        initEvents: function () {
            this.listenTo(
                wp.Modula.Settings,
                "change:enable_zoom",
                this.changedZoom
            );
            this.listenTo(
                wp.Modula.Settings,
                "change:zoom_type",
                this.changedZoomType
            );

            this.listenTo(wp.Modula.Settings, 'toggleAccordeon:enable_zoom', this.toggleZoom);
        },

        changedZoom: function (settings, value) {
            var rows = this.get( 'rows' ),
			currentRow = rows.filter('[data-container="enable_zoom"]'),
            children  = currentRow.data( 'children' );

            jQuery.each(children, function(index, item) {

                var child = jQuery('[data-container="'+item+'"]');

                if ( 0 == value && currentRow.hasClass( 'modula_accordion_open' )) {
                    child.setting_state( this, 'off');
                    child.show();
                }else if( 0 == value ){
                    child.hide();
                }else{
                    child.css('opacity', '1');
                    child.find('input, textarea, select, button').removeAttr('disabled');
                    child.show();
                }
            });

            if ("1" == value) {
                currentRow.addClass( 'modula_accordion_open' );
            }
            this.changedZoomType(false, wp.Modula.Settings.get('zoom_type'));
        },

		toggleZoom: function(){

			var rows = this.get( 'rows' ),
				value = wp.Modula.Settings.get('zoom_type'),
				parentRow = rows.filter('[data-container="enable_zoom"]'),
                children = rows.filter('[data-container="zoom_on_hover"], [data-container="zoom_effect"], [data-container="zoom_window_position"], [data-container="zoom_window_size"],[data-container="zoom_lens_size"], [data-container="zoom_lens_shape"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"]');

                if( !parentRow.hasClass( 'modula_accordion_open' ) ){
                    children.hide();
                }else if( '1' == wp.Modula.Settings.attributes.enable_zoom ){
                    children.show();
                    if( 'window' == value && '1' == wp.Modula.Settings.attributes.enable_zoom ) {
                        rows.filter('[data-container="zoom_lens_size"]').setting_state( this, 'off');
        
                        jQuery( 'option[value="easing"]').show();
                    } else if ( 'inner' == value && '1' == wp.Modula.Settings.attributes.enable_zoom ) {
                        rows.filter('[data-container="zoom_window_position"], [data-container="zoom_window_size"], [data-container="zoom_lens_size"], [data-container="zoom_lens_shape"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"],[data-container="zoom_effect"]').setting_state( this, 'off');
                        rows.filter('[data-container="zoom_type"], [data-container="zoom_on_hover"]').setting_state( this, 'on');
                    } else if( 'lens' == value && '1' == wp.Modula.Settings.attributes.enable_zoom ) {
                        rows.filter('[data-container="zoom_window_position"], [data-container="zoom_window_size"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"]').setting_state( this, 'off');
                        rows.filter('[data-container="zoom_on_hover"], [data-container="zoom_effect"], [data-container="zoom_type"], [data-container="zoom_lens_size"], [data-container="zoom_lens_shape"],[data-container="zoom_effect"]').setting_state( this, 'on');
                        jQuery( 'option[value="easing"]').setting_state( this, 'off');
                    }
                }else{
                    children.show();
                    children.setting_state( this, 'off');
                }
	
	
		},

        changedZoomType: function( settings, value ) {
            let rows = this.get("rows"),
                tabs = this.get("tabs"),
				parentRow = rows.filter('[data-container="enable_zoom"]');

            if( '1' != wp.Modula.Settings.attributes.enable_zoom ){
                if( parentRow.hasClass( 'modula_accordion_open' ) ){
                    rows.filter('[data-container="zoom_effect"], [data-container="zoom_window_position"], [data-container="zoom_window_size"],[data-container="zoom_lens_size"], [data-container="zoom_lens_shape"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"]').show();
                    rows.filter('[data-container="zoom_effect"], [data-container="zoom_window_position"], [data-container="zoom_window_size"],[data-container="zoom_lens_size"], [data-container="zoom_lens_shape"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"]').setting_state( this, 'off');
                }else{
                    rows.filter('[data-container="zoom_effect"], [data-container="zoom_window_position"], [data-container="zoom_window_size"],[data-container="zoom_lens_size"], [data-container="zoom_lens_shape"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"]').hide();
                }
               
            }else{
                rows.filter('[data-container="zoom_effect"], [data-container="zoom_window_position"], [data-container="zoom_window_size"],[data-container="zoom_lens_size"], [data-container="zoom_lens_shape"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"]').show();
                rows.filter('[data-container="zoom_effect"], [data-container="zoom_window_position"], [data-container="zoom_window_size"],[data-container="zoom_lens_size"], [data-container="zoom_lens_shape"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"]').setting_state( this, 'on');
            }

            if( 'window' == value && '1' == wp.Modula.Settings.attributes.enable_zoom ) {
                rows.filter('[data-container="zoom_lens_size"]').setting_state( this, 'off');

                jQuery( 'option[value="easing"]').show();
            } else if ( 'inner' == value && '1' == wp.Modula.Settings.attributes.enable_zoom ) {
                rows.filter('[data-container="zoom_window_position"], [data-container="zoom_window_size"], [data-container="zoom_lens_size"], [data-container="zoom_lens_shape"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"],[data-container="zoom_effect"]').setting_state( this, 'off');
                rows.filter('[data-container="zoom_type"]').setting_state( this, 'on');
            } else if( 'lens' == value && '1' == wp.Modula.Settings.attributes.enable_zoom ) {
                rows.filter('[data-container="zoom_window_position"], [data-container="zoom_window_size"], [data-container="zoom_tint_color"], [data-container="zoom_tint_opacity"]').setting_state( this, 'off');
                rows.filter('[data-container="zoom_effect"], [data-container="zoom_type"], [data-container="zoom_lens_size"], [data-container="zoom_lens_shape"],[data-container="zoom_effect"]').setting_state( this, 'on');
                jQuery( 'option[value="easing"]').setting_state( this, 'off');
            }
        }
    });

    jQuery(document).ready(function () {
        new modulaZoomConditions();
    });
})(jQuery, wp.Modula);
