<?php 

/**
 * Main class for Zoom Settings
 * 
 * @since 1.0.0
 */
class Modula_Zoom_Settings {
    /**
     * Holds the admnin class object
     * 
     * @since 1.0.0
     * 
     * @var object
     */
    public static $instance;

    /**
     * Main construct function for our class
     * 
     * @since 1.0.0
     */
    function __construct() {
        //Filter Modula Fields
        add_filter( 'modula_gallery_fields', array( $this, 'modula_zoom_field' ) );

        //Filter Modula Tab
        add_filter( 'modula_gallery_tabs', array( $this, 'modula_zoom_tab' ),99 );
    }

    /**
     * Returns the singleton instance of the class
     * 
     * @since 1.0.0
     * 
     * @return object Modula_Zoom_Settings object
     */
    public static function get_instance() {
        if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Modula_Zoom_Settings ) ) {
            self::$instance = new Modula_Zoom_Settings();
        }

        return self::$instance;
    }

	/**
	 * Add the Zoom tab in settings
	 *
	 * @param array $tabs
	 *
	 * @return mixed $tabs
	 * @since 1.0.0
	 *
	 */
    public function modula_zoom_tab( $tabs ) {
        $tabs['zoom'] = array(
            'label'       => esc_html__( "Zoom", "modula-zoom" ),
            'title'       => esc_html__( "Zoom Settings", "modula-zoom" ),
            'description' => esc_html__( "The settings bellow adjust what type of zoom is displayed in the lightbox.", "modula-zoom" ),
            'icon'        => "dashicons dashicons-search",
            'priority'    => 85
        );

	    if ( isset( $tabs['zoom']['badge'] ) ) {
		    unset( $tabs['zoom']['badge'] );
	    }

        return $tabs;
    }

	/**
	 * Add zoom fields in settings
	 *
	 * @param array $fields
	 *
	 * @return mixed $fields
	 * @since 1.0.0
	 *
	 */
    public function modula_zoom_field( $fields ) {
        $fields['zoom'] = array(
            'enable_zoom'         => array(
                "name"        => esc_html__( 'Enable Zoom', 'modula-zoom' ),
                "type"        => "toggle",
                "default"     => 0,
                "description" => esc_html__( 'Enable this option to have zoom activated inside the lightbox.', 'modula-zoom' ),
                "priority"    => 1,
                "children"    => array( 'zoom_on_hover', 'zoom_type'),
            ),
            'zoom_on_hover'        => array(
                "name"        => esc_html__( 'Zoom on Hover', 'modula-zoom' ),
                "type"        => "toggle",
                "default"     => 1,
                "description" => esc_html__( 'Enable this option for the zoom to happen when hovering over an image', 'modula-zoom' ),
                "priority"    => 3,
                'is_child'    => true,
            ),
            'zoom_type'             => array(
                "name"        => esc_html__( 'Type', 'modula-zoom' ),
                "type"        => "select",
                "values"       => array(
                    'window'      => esc_html__( 'Basic', 'modula-zoom' ),
                    'inner'       => esc_html__( 'Inner', 'modula-zoom' ),
                    'lens'        => esc_html__( 'Lens', 'modula-zoom' ),
                ),
                "default"     => 'basic',
                "description" => esc_html__( 'Choose your preffered zooming type. With basic you customize the window size and where would you like it to be positioned , inner zooms inside the actual image and lens will give you a looking glass effect.', 'modula-zoom' ),
                "priority"    => 5,
                'is_child'    => true,
            ),
            'zoom_effect'          => array(
                "name"        => esc_html__( 'Effect', 'modula-zoom' ),
                "type"        => "select",
                "values"       => array(
                    'none'        => esc_html__( 'No effect', 'modula-zoom' ),
                    'fade_in'     => esc_html__( 'Fade In', 'modula-zoom' ),
                    'fade_out'    => esc_html__( 'Fade Out', 'modula-zoom' ),
                    'fade_in_out' => esc_html__( 'Fade In Out', 'modula-zoom'),
                    'easing'      => esc_html__( 'Easing', 'modula-zoom' ),
                ),
                "default"     => 'fade_in',
                "description" => esc_html__( 'Choose your preffered zooming effect.', 'modula-zoom' ),
                "priority"    => 10,
                'is_child'    => true,
            ),
            'zoom_window_position'   => array(
                "name"        => esc_html__( 'Window Position', 'modula-zoom' ),
                "type"        => "select",
                "values"       => array(
                    'upper_left'  => esc_html__( 'Upper Left', 'modula-zoom' ),
                    'upper_right' => esc_html__( 'Upper Right', 'modula-zoom' ),
                    'lower_left'  => esc_html__( 'Lower Left', 'modula-zoom' ),
                    'lower_right' => esc_html__( 'Lower Right', 'modula-zoom' ),
                ),
                "default"     => 'upper_left',
                "description" => esc_html__( 'Choose your preffered zoom window position.', 'modula-zoom' ),
                "priority"    => 15,
                'is_child'    => true,
            ),
            'zoom_window_size'       => array(
                "name"        => esc_html__( 'Window Size', 'modula-zoom' ),
                "type"        => "select",
                "values"       => array(
                    'small'      => esc_html__( 'Small', 'modula-zoom' ),
                    'medium'     => esc_html__( 'Medium', 'modula-zoom' ),
                    'large'      => esc_html__( 'Large', 'modula-zoom' ),
                    'xlarge'     => esc_html__( 'Extra Large', 'modula-zoom' ),
                ),
                "default"     => 'medium',
                "description" => esc_html__( 'Choose your preffered zoom window size.', 'modula-zoom' ),
                "priority"    => 20,
                'is_child'    => true,
            ),
            'zoom_lens_size'       => array(
                "name"        => esc_html__( 'Lens Size', 'modula-zoom' ),
                "type"        => "select",
                "values"       => array(
                    'small'      => esc_html__( 'Small', 'modula-zoom' ),
                    'medium'     => esc_html__( 'Medium', 'modula-zoom' ),
                    'large'      => esc_html__( 'Large', 'modula-zoom' ),
                    'xlarge'     => esc_html__( 'Extra Large', 'modula-zoom' ),
                ),
                "default"     => 'medium',
                "description" => esc_html__( 'Choose your preffered zoom lens size.', 'modula-zoom' ),
                "priority"    => 25,
                'is_child'    => true,
            ),
            'zoom_lens_shape'        => array(
                "name"        => esc_html__( 'Lens Shape', 'modula-zoom' ),
                "type"        => "select",
                "values"       => array(
                    'round'      => esc_html__( 'Round', 'modula-zoom' ),
                    'square'     => esc_html__( 'Square', 'modula-zoom' ),
                ),
                "default"     => 'round',
                "description" => esc_html__( 'Choose your preffered zoom lens shape.', 'modula-zoom' ),
                "priority"    => 30,
                'is_child'    => true,
            ),
            'zoom_tint_color'        => array(
                "name"        => esc_html__( 'Tint Color', 'modula-zoom' ),
                "type"        => "color",
                "default"     => '',
                "description" => esc_html__( 'Select a tint color or leave blank for no tint.', 'modula-zoom' ),
                "priority"    => 35,
                'is_child'    => true,
            ),
            'zoom_tint_opacity'      => array(
                "name"        => esc_html__( 'Tint Opacity', 'modula-zoom' ),
                "type"        => "ui-slider",
                "default"     => 0,
                "min"         => 0,
                "max"         => 100,
                "step"        => 1,
                "description" => esc_html__( 'Select a tint opacity. 100 will result in it being the full color and 0 the color will not be noticed.', 'modula-zoom' ),
                "priority"    => 40,
                'is_child'    => true,
            ),
        );

        return $fields;
    }
}

$modula_zoom_settings = Modula_Zoom_Settings::get_instance();