<?php
spl_autoload_register(
	function ( $class_name ) {
		if ( strpos( $class_name, 'Modula' ) === false && strpos( $class_name, 'Wpchill' ) === false ) {
			return;
		}

		static $class_map = null;

		if ( null === $class_map ) {
			$base_dir  = untrailingslashit( plugin_dir_path( __FILE__ ) . 'includes' );
			$class_map = modula_build_class_map( $base_dir );
		}

		$class_key = strtolower( $class_name );

		if ( isset( $class_map[ $class_key ] ) ) {
			require $class_map[ $class_key ];
		}
	}
);

function modula_build_class_map( $base_dir ) {
	$class_map = array();
	$iterator  = new RecursiveIteratorIterator(
		new RecursiveDirectoryIterator( $base_dir, RecursiveDirectoryIterator::SKIP_DOTS )
	);

	foreach ( $iterator as $file ) {
		if ( $file->isFile() && strpos( $file->getFilename(), 'class-' ) === 0 ) {
			$class_name               = str_replace(
				array( 'class-', '.php' ),
				array( '', '' ),
				strtolower( $file->getFilename() )
			);
			$class_name               = str_replace( '-', '_', $class_name );
			$class_map[ $class_name ] = $file->getPathname();
		}
	}

	return $class_map;
}
